/*
 * Decompiled with CFR 0.152.
 */
package com.sun.embeddedswing;

import com.sun.embeddedswing.EmbeddedPeer;
import com.sun.embeddedswing.EmbeddedToolkit;
import com.sun.embeddedswing.EventFilter;
import com.sun.embeddedswing.FullScreenEventsMonitor;
import com.sun.embeddedswing.SwingGlueLayer;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.utils.Utils;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;

class EmbeddedEventQueue
extends EventQueue {
    private List<EmbeddedToolkit.CoordinateHandler> lastCoordinateHandlerList;
    private List<EventFilter> filters = new ArrayList<EventFilter>(0);
    private FullScreenEventsMonitor fsMonitor;
    private boolean eventQueueTrusted = false;
    private final ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            EmbeddedEventQueue.this.doPulse();
        }
    };
    private final Runnable pulseRunnable = new Runnable(){

        public void run() {
            EmbeddedEventQueue.this.doPulse();
        }
    };
    private final InvocationEvent pulseEvent = new InvocationEvent((Object)this, this.pulseRunnable);
    private AWTEvent postponed = null;
    private boolean waitForNonPulseEvent = true;
    private static final long RESPONSIVE_THRESHOLD = 33L;
    private final Object lock = new Object();
    private boolean disableTimer = false;
    private ScheduledFuture<?> pulseAlarmFuture = null;
    private FutureTask<Void> pulseRunnableFuture = null;
    private DelayedRunnable animationRunnable = null;
    private final Runnable pulseAlarmRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = EmbeddedEventQueue.this.lock;
            synchronized (object) {
                if (EmbeddedEventQueue.this.pulseRunnableFuture != null) {
                    EventQueue.invokeLater(EmbeddedEventQueue.this.pulseRunnableFuture);
                }
            }
        }
    };

    EmbeddedEventQueue() {
    }

    void addEventFilter(EventFilter eventFilter) {
        this.filters.add(eventFilter);
    }

    void removeEventFilter(EventFilter eventFilter) {
        this.filters.remove(eventFilter);
    }

    void setFullScreenEventsMonitor(FullScreenEventsMonitor fullScreenEventsMonitor) {
        this.fsMonitor = fullScreenEventsMonitor;
    }

    private static boolean isMouseGrab(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
            switch (mouseEvent.getButton()) {
                case 1: {
                    n ^= 0x400;
                    break;
                }
                case 2: {
                    n ^= 0x800;
                    break;
                }
                case 3: {
                    n ^= 0x1000;
                }
            }
        }
        return (n & 0x1C00) != 0;
    }

    private static void moveToVisibleAndOnScreen(EmbeddedToolkit.CoordinateHandler coordinateHandler, Component component, Point2D point2D) {
        Rectangle rectangle;
        Serializable serializable;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            serializable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
            rectangle.width -= ((Insets)serializable).left + ((Insets)serializable).right;
            rectangle.height -= ((Insets)serializable).top + ((Insets)serializable).bottom;
            rectangle.x += ((Insets)serializable).left;
            rectangle.y += ((Insets)serializable).top;
        } else {
            rectangle = new Rectangle(new Point(), toolkit.getScreenSize());
        }
        serializable = coordinateHandler.getEmbeddedPeer().getContainer();
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, (Component)serializable);
        JComponent jComponent = coordinateHandler.getEmbeddedPeer().getParentComponent();
        Rectangle rectangle2 = jComponent.getVisibleRect();
        Point point2 = SwingUtilities.convertPoint(component, (int)point2D.getX(), (int)point2D.getY(), jComponent);
        int n = (int)Math.min((double)(rectangle2.x + rectangle2.width - point2.x), Math.max((double)rectangle.x - point.getX(), (double)(rectangle2.x - point2.x)));
        int n2 = (int)Math.min((double)(rectangle2.y + rectangle2.height - point2.y), Math.max((double)rectangle.y - point.getY(), (double)(rectangle2.y - point2.y)));
        ((Component)serializable).setLocation(((JComponent)serializable).getX() + n, ((JComponent)serializable).getY() + n2);
    }

    private static final boolean checkFSPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AWTPermission("fullScreenExclusive"));
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    private void signalFSEnterAllowed(AWTEvent aWTEvent) {
        if (this.fsMonitor != null && this.eventQueueTrusted) {
            this.fsMonitor.checkFullScreenEnterAllowed(aWTEvent);
        }
    }

    private void signalFSEnterDisabled(AWTEvent aWTEvent) {
        if (this.fsMonitor != null) {
            this.fsMonitor.disableFullScreenEnter();
        }
    }

    private AWTEvent filter(AWTEvent aWTEvent) {
        if (aWTEvent != null && this.filters.size() > 0) {
            for (int i = 0; i < this.filters.size(); ++i) {
                aWTEvent = this.filters.get(i).filter(aWTEvent);
                if (aWTEvent != null) continue;
                return null;
            }
        }
        return aWTEvent;
    }

    private Object beforeDispatch(AWTEvent aWTEvent) {
        Object[] objectArray = null;
        this.signalFSEnterAllowed(aWTEvent);
        if (aWTEvent instanceof MouseEvent) {
            Object object;
            Object object2;
            Object object3;
            List<Object> list;
            Point point;
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Component component = mouseEvent.getComponent();
            Point point2 = mouseEvent.getPoint();
            Component component2 = SwingUtilities.getRoot(component);
            if (component2 == null) {
                return objectArray;
            }
            if (component2 != component && !(component instanceof Applet)) {
                point = SwingUtilities.convertPoint(component, point2, component2);
                mouseEvent.setSource(component2);
                mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            }
            point = mouseEvent.getPoint();
            Component component3 = mouseEvent.getComponent();
            int n = 0;
            if (!EmbeddedEventQueue.isMouseGrab(mouseEvent) && mouseEvent.getID() != 500) {
                n = 1;
            } else if (this.lastCoordinateHandlerList != null && !this.lastCoordinateHandlerList.isEmpty()) {
                switch (mouseEvent.getID()) {
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 506: {
                        n = 2;
                    }
                }
            }
            Point2D.Double double_ = new Point2D.Double();
            ArrayList<Object> arrayList = null;
            if (n == 2) {
                for (int i = 0; i < this.lastCoordinateHandlerList.size(); ++i) {
                    if (this.lastCoordinateHandlerList.get(i).getEmbeddedPeer().getParentComponent() != null) continue;
                    this.lastCoordinateHandlerList = this.lastCoordinateHandlerList.subList(0, i);
                    break;
                }
                list = this.lastCoordinateHandlerList;
            } else {
                arrayList = new ArrayList<Object>();
                list = new ArrayList();
                Point2D point2D = new Point2D.Double();
                point2D.setLocation(point);
                object3 = component3;
                while (object3 != null) {
                    Point point3 = new Point();
                    Object object4 = SwingGlueLayer.getFirstComponentWithClientProperty((Component)object3, EmbeddedToolkit.EmbeddedToolkitKey, (int)((Point2D)point2D).getX(), (int)((Point2D)point2D).getY(), point3);
                    object3 = null;
                    if (object4 == null) continue;
                    ((Point2D)point2D).setLocation(((Point2D)point2D).getX() - point3.getX(), ((Point2D)point2D).getY() - point3.getY());
                    object2 = EmbeddedToolkit.getEmbeddedToolkit((JComponent)object4).createCoordinateHandler((JComponent)object4, point2D, mouseEvent);
                    if (object2 == null) continue;
                    object = new Point2D.Double();
                    ((Point2D)object).setLocation(point2D);
                    point2D = object2.transform(point2D, null, mouseEvent);
                    list.add(object2);
                    double_.setLocation(point2D);
                    arrayList.add(object);
                    object3 = object2.getEmbeddedPeer().getEmbeddedComponent();
                }
                if (n == 1) {
                    this.lastCoordinateHandlerList = list;
                }
            }
            if (!list.isEmpty()) {
                Object object52;
                Object object6;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    Component component4 = component3;
                    object3 = new Point2D.Double();
                    ((Point2D)object3).setLocation(point);
                    for (Object object4 : list) {
                        object2 = object4.getEmbeddedPeer();
                        object = ((EmbeddedPeer)object2).getParentComponent();
                        object6 = SwingUtilities.convertPoint((Component)object, 0, 0, component4);
                        ((Point2D)object3).setLocation(((Point2D)object3).getX() - ((Point)object6).getX(), ((Point2D)object3).getY() - ((Point)object6).getY());
                        object52 = new Point2D.Double(((Point2D)object3).getX(), ((Point2D)object3).getY());
                        object3 = object4.transform((Point2D)object3, null, mouseEvent);
                        double_.setLocation((Point2D)object3);
                        arrayList.add(object52);
                        component4 = ((EmbeddedPeer)object2).getEmbeddedComponent();
                    }
                }
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                object3 = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
                boolean bl = false;
                for (int i = 0; i < list.size(); ++i) {
                    object2 = ((EmbeddedToolkit.CoordinateHandler)list.get(i)).getEmbeddedPeer();
                    object = ((EmbeddedPeer)object2).getEmbeddedToolkit();
                    object6 = null;
                    object6 = bl ? object3 : (Point2D)arrayList.get(i);
                    mouseEvent.translatePoint((int)((Point2D)object6).getX() - mouseEvent.getX(), (int)((Point2D)object6).getY() - mouseEvent.getY());
                    object52 = ((EmbeddedToolkit)object).processMouseEvent(mouseEvent, (Point2D)arrayList.get(i), (EmbeddedPeer)object2);
                    if (bl || object52 == null) {
                        bl = true;
                        continue;
                    }
                    arrayList2.add(object52);
                }
                EmbeddedToolkit.CoordinateHandler coordinateHandler = (EmbeddedToolkit.CoordinateHandler)list.get(list.size() - 1);
                object2 = coordinateHandler.getEmbeddedPeer().getEmbeddedComponent();
                if (!bl) {
                    EmbeddedEventQueue.moveToVisibleAndOnScreen((EmbeddedToolkit.CoordinateHandler)list.get(0), (Component)object2, double_);
                    object = SwingUtilities.convertPoint((Component)object2, (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), component3);
                } else {
                    object = object3;
                }
                mouseEvent.translatePoint(((Point)object).x - mouseEvent.getX(), ((Point)object).y - mouseEvent.getY());
                for (Object object52 : list) {
                    object52.getEmbeddedPeer().getShell().setContains(true);
                }
                objectArray = new Object[]{list, arrayList, arrayList2};
            } else {
                mouseEvent.setSource(component);
                mouseEvent.translatePoint(point2.x - mouseEvent.getX(), point2.y - mouseEvent.getY());
            }
        }
        return objectArray;
    }

    private void afterDispatch(AWTEvent aWTEvent, Object object) {
        if (aWTEvent instanceof MouseEvent && object != null) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Object[] objectArray = (Object[])object;
            List list = (List)objectArray[0];
            List list2 = (List)objectArray[1];
            List list3 = (List)objectArray[2];
            for (Object object2 : list) {
                object2.getEmbeddedPeer().getShell().setContains(false);
            }
            for (int i = list3.size() - 1; i >= 0; --i) {
                Object object2;
                object2 = (Runnable)list3.get(i);
                if (object2 == null) continue;
                Point2D point2D = (Point2D)list2.get(i);
                mouseEvent.translatePoint((int)point2D.getX() - mouseEvent.getX(), (int)point2D.getY() - mouseEvent.getY());
                object2.run();
            }
        }
        this.signalFSEnterDisabled(aWTEvent);
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        Object object = this.beforeDispatch(aWTEvent);
        super.dispatchEvent(aWTEvent);
        this.afterDispatch(aWTEvent, object);
    }

    public void push(EventQueue eventQueue) {
        if (!EmbeddedEventQueue.checkFSPermission()) {
            this.eventQueueTrusted = false;
            if (this.fsMonitor != null) {
                this.fsMonitor.disableFullScreenEnter();
            }
        }
        super.push(eventQueue);
    }

    private static long getWhen(AWTEvent aWTEvent) {
        long l = Long.MIN_VALUE;
        if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            l = inputEvent.getWhen();
        } else if (aWTEvent instanceof InputMethodEvent) {
            InputMethodEvent inputMethodEvent = (InputMethodEvent)aWTEvent;
            l = inputMethodEvent.getWhen();
        } else if (aWTEvent instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)aWTEvent;
            l = actionEvent.getWhen();
        } else if (aWTEvent instanceof InvocationEvent) {
            InvocationEvent invocationEvent = (InvocationEvent)aWTEvent;
            l = invocationEvent.getWhen();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AWTEvent getNextEvent(EventQueue eventQueue) throws InterruptedException {
        AWTEvent aWTEvent = null;
        if (this.postponed != null) {
            aWTEvent = this.postponed;
            this.postponed = null;
        } else {
            AWTEvent aWTEvent2 = null;
            do {
                DelayedRunnable delayedRunnable = null;
                Object object = this.lock;
                synchronized (object) {
                    delayedRunnable = this.animationRunnable;
                }
                if (delayedRunnable != null && !this.waitForNonPulseEvent && delayedRunnable.getDelay() <= 0L) {
                    aWTEvent = this.pulseEvent;
                    this.postponed = aWTEvent2;
                    this.waitForNonPulseEvent = true;
                    continue;
                }
                if (aWTEvent2 != null) {
                    aWTEvent = aWTEvent2;
                    continue;
                }
                aWTEvent2 = eventQueue == this ? super.getNextEvent() : eventQueue.getNextEvent();
                if ((aWTEvent2 = this.filter(aWTEvent2)) == null) continue;
                long l = System.currentTimeMillis();
                boolean bl = this.waitForNonPulseEvent = l - EmbeddedEventQueue.getWhen(aWTEvent2) > 33L;
            } while (aWTEvent == null);
        }
        return aWTEvent;
    }

    public AWTEvent getNextEvent() throws InterruptedException {
        return this.getNextEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPulse() {
        Object object = this.lock;
        synchronized (object) {
            this.disableTimer = true;
            this.stopPulseAlarm();
            if (this.animationRunnable != null) {
                this.animationRunnable.run();
            }
            this.disableTimer = false;
            this.updatePulseAlarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAnimationRunnable(DelayedRunnable delayedRunnable) {
        Object object = this.lock;
        synchronized (object) {
            this.animationRunnable = delayedRunnable;
            this.updatePulseAlarm();
        }
    }

    private static ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
            private final ThreadFactory delegate = Executors.defaultThreadFactory();
            private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread thread, Throwable throwable) {
                }
            };

            public Thread newThread(Runnable runnable) {
                Thread thread = this.delegate.newThread(runnable);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
                return thread;
            }
        });
        return scheduledThreadPoolExecutor;
    }

    private static synchronized ScheduledExecutorService getPulseAlarmExecutor() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
        AppContext appContext = AccessController.doPrivileged(new PrivilegedAction<AppContext>(){

            @Override
            public AppContext run() {
                return AppContext.getAppContext();
            }
        });
        if (appContext != null && appContext.isDisposed()) {
            return null;
        }
        if (appContext != null) {
            scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)appContext.get(EmbeddedEventQueue.class);
            if (scheduledThreadPoolExecutor == null) {
                scheduledThreadPoolExecutor = EmbeddedEventQueue.getScheduledThreadPoolExecutor();
                appContext.put(EmbeddedEventQueue.class, scheduledThreadPoolExecutor);
                final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2 = scheduledThreadPoolExecutor;
                appContext.addPropertyChangeListener("disposed", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        WeakReference<ScheduledThreadPoolExecutor> weakReference;
                        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        if (bl && (scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)(weakReference = new WeakReference<ScheduledThreadPoolExecutor>(scheduledThreadPoolExecutor2)).get()) != null) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    scheduledThreadPoolExecutor.setThreadFactory(Executors.defaultThreadFactory());
                                    scheduledThreadPoolExecutor.shutdownNow();
                                    return null;
                                }
                            });
                        }
                    }
                });
            }
        } else {
            scheduledThreadPoolExecutor = EmbeddedEventQueue.getScheduledThreadPoolExecutor();
        }
        return scheduledThreadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePulseAlarm() {
        Object object = this.lock;
        synchronized (object) {
            if (this.disableTimer) {
                return;
            }
            if (this.animationRunnable != null) {
                if (this.pulseRunnableFuture == null || this.pulseRunnableFuture.isDone()) {
                    int n = (int)this.animationRunnable.getDelay();
                    this.pulseRunnableFuture = new FutureTask<Object>(this.pulseRunnable, null);
                    ScheduledExecutorService scheduledExecutorService = EmbeddedEventQueue.getPulseAlarmExecutor();
                    if (scheduledExecutorService != null) {
                        this.pulseAlarmFuture = scheduledExecutorService.schedule(this.pulseAlarmRunnable, (long)n, TimeUnit.MILLISECONDS);
                    }
                }
            } else {
                this.stopPulseAlarm();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPulseAlarm() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pulseAlarmFuture != null) {
                this.pulseAlarmFuture.cancel(false);
                this.pulseAlarmFuture = null;
            }
            if (this.pulseRunnableFuture != null) {
                this.pulseRunnableFuture.cancel(false);
                this.pulseRunnableFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register() {
        GenericDeclaration genericDeclaration;
        Object object;
        this.eventQueueTrusted = EmbeddedEventQueue.checkFSPermission();
        boolean bl = false;
        if (System.getSecurityManager() == null || !this.eventQueueTrusted) {
            try {
                Utils.platformClassForName("java.util.concurrent.Callable", true);
                object = Utils.platformClassForName("com.sun.java.swing.SwingUtilities3", true);
                genericDeclaration = ((Class)object).getMethod("setEventQueueDelegate", Map.class);
                ((Method)genericDeclaration).invoke(object, EventQueueDelegateFactory.getObjectMap(this));
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (!bl) {
            object = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if ("jep.MySimpleEventQueue".equals(object.getClass().getName()) || "org.netbeans.core.TimableEventQueue".equals(object.getClass().getName()) || System.getProperty("javafx.protectEEQ") != null) {
                System.out.println("Apply EventQueue protection workaround");
                try {
                    Object object2;
                    genericDeclaration = Utils.platformClassForName("sun.awt.SunToolkit", true);
                    Field field = ((Class)genericDeclaration).getDeclaredField("POST_EVENT_QUEUE_KEY");
                    field.setAccessible(true);
                    AppContext appContext = AppContext.getAppContext();
                    Object object3 = object2 = appContext.get(field.get(genericDeclaration));
                    synchronized (object3) {
                        ((EventQueue)object).push(this);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Failed to get protective lock to install embeddedEventQueue due to " + exception);
                    exception.printStackTrace();
                    ((EventQueue)object).push(this);
                }
            } else {
                ((EventQueue)object).push(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventQueueDelegateFactory {
        private EventQueueDelegateFactory() {
        }

        static Map<String, Map<String, Object>> getObjectMap(final EmbeddedEventQueue embeddedEventQueue) {
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
            final AWTEvent[] aWTEventArray = new AWTEvent[1];
            final Object[] objectArray = new Object[1];
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() {
                    embeddedEventQueue.afterDispatch(aWTEventArray[0], objectArray[0]);
                    return null;
                }
            };
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("event", aWTEventArray);
            hashMap2.put("handle", objectArray);
            hashMap2.put("method", callable);
            hashMap.put("afterDispatch", hashMap2);
            final AWTEvent[] aWTEventArray2 = new AWTEvent[1];
            Callable<Object> callable2 = new Callable<Object>(){

                @Override
                public Object call() {
                    return embeddedEventQueue.beforeDispatch(aWTEventArray2[0]);
                }
            };
            hashMap2 = new HashMap();
            hashMap2.put("event", aWTEventArray2);
            hashMap2.put("method", callable2);
            hashMap.put("beforeDispatch", hashMap2);
            final EventQueue[] eventQueueArray = new EventQueue[1];
            Callable<AWTEvent> callable3 = new Callable<AWTEvent>(){

                @Override
                public AWTEvent call() throws Exception {
                    return embeddedEventQueue.getNextEvent(eventQueueArray[0]);
                }
            };
            hashMap2 = new HashMap();
            hashMap2.put("eventQueue", eventQueueArray);
            hashMap2.put("method", callable3);
            hashMap.put("getNextEvent", hashMap2);
            return hashMap;
        }
    }
}

