/*
 * Decompiled with CFR 0.152.
 */
package com.sun.embeddedswing;

import com.sun.embeddedswing.EmbeddedEventQueue;
import com.sun.embeddedswing.EmbeddedPopupFactory;
import com.sun.embeddedswing.EmbeddedRepaintManager;
import com.sun.embeddedswing.EventFilter;
import com.sun.embeddedswing.FullScreenEventsMonitor;
import com.sun.embeddedswing.ScreenConfigurationUpdater;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.utils.Utils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.PopupFactory;
import javax.swing.RepaintManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingGlueLayer {
    private static boolean repaintManagerClassInitialized = false;
    private static Class<?> repaintManagerClass;
    private static Object repaintManager;
    private boolean popupFactoryInitialized = false;
    private final EmbeddedEventQueue eventQueue;
    private static final Object SWING_GLUELAYER_KEY;
    private final Map<Object, Object> contextMap = Collections.synchronizedMap(new HashMap());

    public SwingGlueLayer() {
        this.eventQueue = new EmbeddedEventQueue();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SwingGlueLayer.this.eventQueue.register();
            }
        });
    }

    public static synchronized SwingGlueLayer getSwingGlueLayer() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        SwingGlueLayer swingGlueLayer = (SwingGlueLayer)uIDefaults.get(SWING_GLUELAYER_KEY);
        if (swingGlueLayer == null) {
            swingGlueLayer = new SwingGlueLayer();
            uIDefaults.put(SWING_GLUELAYER_KEY, swingGlueLayer);
        }
        return swingGlueLayer;
    }

    public static Map<Object, Object> getContextMap() {
        return SwingGlueLayer.getSwingGlueLayer().contextMap;
    }

    void registerRepaintManager(JComponent jComponent) {
        if (!repaintManagerClassInitialized) {
            repaintManagerClassInitialized = true;
            try {
                repaintManagerClass = Utils.platformClassForName("javax.swing.RepaintManager", true);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Object object = repaintManager = repaintManagerClass != null ? RepaintManagerRegister.createRepaintManager() : null;
        }
        if (!this.popupFactoryInitialized) {
            this.popupFactoryInitialized = true;
            PopupFactory.setSharedInstance(new EmbeddedPopupFactory());
        }
        if (repaintManager == null) {
            return;
        }
        RepaintManagerRegister.registerRepaintManager(jComponent, repaintManager);
    }

    public void setAnimationRunnable(DelayedRunnable delayedRunnable) {
        this.eventQueue.setAnimationRunnable(delayedRunnable);
    }

    public void addEventFilter(EventFilter eventFilter) {
        this.eventQueue.addEventFilter(eventFilter);
    }

    public void removeEventFilter(EventFilter eventFilter) {
        this.eventQueue.removeEventFilter(eventFilter);
    }

    public void setFullScreenEventsMonitor(FullScreenEventsMonitor fullScreenEventsMonitor) {
        this.eventQueue.setFullScreenEventsMonitor(fullScreenEventsMonitor);
    }

    public void registerAndUpdateScreenConfigurationListener(TKScreenConfigurationListener tKScreenConfigurationListener) {
        final ScreenConfigurationUpdater screenConfigurationUpdater = new ScreenConfigurationUpdater(tKScreenConfigurationListener);
        screenConfigurationUpdater.updateNow();
        this.addEventFilter(new EventFilter(){

            public AWTEvent filter(AWTEvent aWTEvent) {
                screenConfigurationUpdater.update();
                return aWTEvent;
            }
        });
    }

    static JComponent getAncestorWithClientProperty(Component component, Object object) {
        Container container;
        if (component == null) {
            return null;
        }
        for (container = component.getParent(); !(container == null || container instanceof JComponent && ((JComponent)container).getClientProperty(object) != null); container = container.getParent()) {
        }
        return (JComponent)container;
    }

    static JComponent getFirstComponentWithClientProperty(Component component, Object object, int n, int n2, Point point) {
        if (!component.contains(n, n2)) {
            return null;
        }
        if (component instanceof JComponent && ((JComponent)component).getClientProperty(object) != null) {
            return (JComponent)component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2 = componentArray[i];
                if (component2 == null || !component2.isVisible()) continue;
                Point point2 = component2.getLocation();
                if (!component2.contains(n - point2.x, n2 - point2.y)) continue;
                JComponent jComponent = SwingGlueLayer.getFirstComponentWithClientProperty(component2, object, n - point2.x, n2 - point2.y, point2);
                if (jComponent != null) {
                    point.x += point2.x;
                    point.y += point2.y;
                    return jComponent;
                }
                return null;
            }
        }
        return null;
    }

    static {
        SWING_GLUELAYER_KEY = new StringBuilder("SwingGlueLayerKey");
    }

    private static class RepaintManagerRegister {
        private static final Method setDelegateRepaintManagerMethod;
        private static final Class<?> swingUtilities3Class;
        private static final Method getWindowsMethod;

        private RepaintManagerRegister() {
        }

        static Object createRepaintManager() {
            return new EmbeddedRepaintManager(null);
        }

        static void registerRepaintManager(JComponent jComponent, Object object) {
            if (setDelegateRepaintManagerMethod == null) {
                RepaintManager repaintManager = RepaintManager.currentManager(null);
                if (repaintManager != object) {
                    ((EmbeddedRepaintManager)object).setDelegate(repaintManager);
                    RepaintManager.setCurrentManager((EmbeddedRepaintManager)object);
                    if (getWindowsMethod != null) {
                        try {
                            Window[] windowArray = null;
                            for (Window window : windowArray = (Window[])getWindowsMethod.invoke((Object)null, new Object[0])) {
                                window.repaint();
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            try {
                setDelegateRepaintManagerMethod.invoke(swingUtilities3Class, jComponent, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        static {
            Class clazz = null;
            Method method = null;
            try {
                clazz = Utils.platformClassForName("com.sun.java.swing.SwingUtilities3", true);
                method = clazz.getMethod("setDelegateRepaintManager", JComponent.class, repaintManagerClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (clazz == null || method == null) {
                clazz = null;
                method = null;
            }
            swingUtilities3Class = clazz;
            setDelegateRepaintManagerMethod = method;
            Method method2 = null;
            try {
                method2 = Window.class.getMethod("getWindows", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            getWindowsMethod = method2;
        }
    }
}

