/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public class ReaderUTF8
extends Reader {
    private InputStream is;
    private byte[] buff;
    private int bidx = 0;
    private int bcnt = 0;

    public ReaderUTF8(InputStream inputStream) {
        this.is = inputStream;
        this.buff = new byte[64];
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        block5: for (n3 = 0; n3 < n2; ++n3) {
            char c;
            if (this.bidx >= this.bcnt) {
                this.bcnt = this.is.read(this.buff, 0, this.buff.length);
                if (this.bcnt < 0) {
                    return n3 != 0 ? n3 : -1;
                }
                this.bidx = 0;
            }
            if ((c = (char)this.buff[this.bidx++]) <= '\u007f') {
                cArray[n++] = c;
                continue;
            }
            switch (c & 0xF0) {
                case 192: 
                case 208: {
                    cArray[n++] = (char)((c & 0x1F) << 6 | this.getch() & 0x3F);
                    continue block5;
                }
                case 224: {
                    cArray[n++] = (char)((c & 0xF) << 12 | (this.getch() & 0x3F) << 6 | this.getch() & 0x3F);
                    continue block5;
                }
                case 240: {
                    throw new UnsupportedEncodingException();
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return n3;
    }

    public int read() throws IOException {
        int n = this.is.read();
        if (n < 0) {
            return -1;
        }
        if (n > 127) {
            switch (n & 0xF0) {
                case 192: 
                case 208: {
                    n = (n & 0x1F) << 6 | this.is.read() & 0x3F;
                    break;
                }
                case 224: {
                    n = (n & 0xF) << 12 | (this.is.read() & 0x3F) << 6 | this.is.read() & 0x3F;
                    break;
                }
                case 240: {
                    throw new UnsupportedEncodingException();
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return n;
    }

    public void close() throws IOException {
        this.is.close();
    }

    private char getch() throws IOException {
        if (this.bidx >= this.bcnt) {
            this.bcnt = this.is.read(this.buff, 0, this.buff.length);
            if (this.bcnt <= 0) {
                throw new EOFException();
            }
            this.bidx = 0;
        }
        return (char)this.buff[this.bidx++];
    }
}

