/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io;

import com.sun.javafx.io.FileContents;
import com.sun.javafx.io.MeteredFileOutputStream;
import com.sun.javafx.io.StorageImpl;
import com.sun.javafx.io.StorageListener;
import com.sun.javafx.io.impl.AbstractFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class FileContentsImpl
implements FileContents {
    private String _name;
    private AbstractFile _file;
    private String _url;
    private long _limit = Long.MAX_VALUE;
    private StorageListener _listener;
    private static final String FILE_NOT_FOUND = "FileNotFoundException";
    private static final boolean DEBUG = StorageImpl.DEBUG;

    FileContentsImpl(AbstractFile abstractFile, String string, long l, StorageListener storageListener) throws IOException {
        this._file = abstractFile;
        this._url = string;
        this._limit = l;
        this._listener = storageListener;
        int n = string.lastIndexOf(47);
        this._name = n != -1 ? string.substring(n + 1) : string;
    }

    public String getName() {
        return this._name;
    }

    public long getLength() throws IOException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new Long(FileContentsImpl.this._file.length());
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        return (Long)object;
    }

    public InputStream openInputStream() throws IOException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return FileContentsImpl.this._file.openInputStream();
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            this.rethrowIOException((IOException)object);
        }
        return (InputStream)object;
    }

    public OutputStream openOutputStream(final boolean bl) throws IOException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new MeteredFileOutputStream(FileContentsImpl.this._file, bl, FileContentsImpl.this, FileContentsImpl.this._listener);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            this.rethrowIOException((IOException)object);
        }
        return (OutputStream)object;
    }

    private void rethrowIOException(IOException iOException) throws IOException {
        if (iOException.getClass().getName().indexOf(FILE_NOT_FOUND) > 0) {
            throw new IOException("FileNotFoundException: " + this._name);
        }
        throw iOException;
    }

    public boolean canRead() throws IOException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Boolean(FileContentsImpl.this._file.canRead());
            }
        });
        return bl;
    }

    public boolean canWrite() throws IOException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Boolean(FileContentsImpl.this._file.canWrite());
            }
        });
        return bl;
    }

    public long getMaxLength() throws IOException {
        return this._limit;
    }

    public long setMaxLength(long l) throws IOException {
        this._limit = StorageImpl.getInstance().setMaxLength(this._url, l);
        return this._limit;
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("FileContentsImpl." + string);
        }
    }
}

