/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io;

import com.sun.javafx.io.File;
import com.sun.javafx.io.FileContents;
import com.sun.javafx.io.StorageImpl;
import com.sun.javafx.io.StorageListener;
import com.sun.javafx.io.impl.AbstractFactory;
import java.io.IOException;

public class FileImpl
implements File {
    private static final int CREATE_EXCEPTION = -1;
    private static StorageImpl _storage = StorageImpl.getInstance();
    private FileContents _fcontents;
    private String _filename;
    private String _name;
    private StorageListener _listener;
    private static final boolean DEBUG = StorageImpl.DEBUG;

    public FileImpl(String string, StorageListener storageListener) {
        this._name = string;
        this._filename = StorageImpl.getURLName(this._name);
        this._listener = storageListener;
        FileImpl.print("<init> : _filename = " + this._filename + " _name=" + this._name);
    }

    long getDefaultMaxSize() {
        return AbstractFactory.getAbstractStorage().getFileSizeLimit();
    }

    public int create() {
        return this.create(this.getDefaultMaxSize());
    }

    public int create(long l) {
        FileImpl.print("create: _filename=" + this._filename + " _name=" + this._name);
        try {
            return (int)_storage.create(this._filename, l);
        }
        catch (IOException iOException) {
            if (DEBUG || !iOException.getMessage().endsWith("already exists")) {
                iOException.printStackTrace();
            }
            return -1;
        }
    }

    public boolean exists() {
        return _storage.exists(this._name);
    }

    public FileContents get() {
        if (this._fcontents == null) {
            try {
                this._fcontents = _storage.getFileContents(this._filename, this._listener);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this._fcontents;
    }

    public boolean remove() {
        FileImpl.print("remove: start; _filename=" + this._filename + " _name=" + this._name);
        if (_storage.exists(this._name)) {
            try {
                _storage.delete(this._filename);
                FileImpl.print("remove: deleted " + this._filename);
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        FileImpl.print("remove: file " + this._filename + " has been already removed or did not exist.");
        return true;
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("FileImpl." + string);
        }
    }
}

