/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io;

import com.sun.javafx.io.FileContentsImpl;
import com.sun.javafx.io.StorageListener;
import com.sun.javafx.io.impl.AbstractFactory;
import com.sun.javafx.io.impl.AbstractFile;
import java.io.IOException;
import java.io.OutputStream;

final class MeteredFileOutputStream
extends OutputStream {
    private FileContentsImpl _fileContents;
    private long _written = 0L;
    private OutputStream _outputStream;
    private StorageListener _listener;
    private static final boolean DEBUG = AbstractFactory.getAbstractStorage().isTraceEnabled();

    MeteredFileOutputStream(AbstractFile abstractFile, boolean bl, FileContentsImpl fileContentsImpl, StorageListener storageListener) throws IOException {
        this._fileContents = fileContentsImpl;
        this._written = abstractFile.length();
        this._outputStream = abstractFile.openOutputStream(bl);
        this._listener = storageListener;
        MeteredFileOutputStream.print("<init>: overwrite=" + bl + " _written=" + this._written);
        if (bl) {
            this._listener.bytesRemoved(this._written);
            this._written = 0L;
        }
    }

    public void write(int n) throws IOException {
        this.checkWrite(1);
        this._outputStream.write(n);
        ++this._written;
        this.bytesAdded(1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkWrite(n2);
        this._outputStream.write(byArray, n, n2);
        this._written += (long)n2;
        this.bytesAdded(n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        this._outputStream.close();
        super.close();
        this.bytesAdded(0);
    }

    public void flush() throws IOException {
        this._outputStream.flush();
        super.flush();
        this.bytesAdded(0);
    }

    private void checkWrite(int n) throws IOException {
        long l = this._fileContents.getMaxLength();
        if (this._written + (long)n > l) {
            MeteredFileOutputStream.print("checkWrite: Maximum file length exceeded: _written=" + this._written + " len=" + n + " maxLength=" + l);
            throw new IOException("Maximum file length (" + l + ") exceeded.");
        }
    }

    private void bytesAdded(int n) {
        StorageListener storageListener = this._listener;
        storageListener.bytesAdded(n);
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("MeteredFileOutputStream." + string);
        }
    }
}

