/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io;

import com.sun.javafx.io.impl.AbstractStorage;
import java.util.HashMap;
import java.util.Map;

public class URLUtil {
    static Bits encodedInPath = new Bits(256);
    private static Map<String, String> canonicalizedURLMap;

    public static String asPathURL(String string) {
        if (string == null) {
            return null;
        }
        if (!string.endsWith("/")) {
            return string + "/";
        }
        return string;
    }

    public static boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            return string2 == string;
        }
        if ("http".equals(URLUtil.getProtocol(string)) && "http".equals(URLUtil.getProtocol(string2)) && URLUtil.getPort(string) != URLUtil.getPort(string2)) {
            string = URLUtil.normalizePort(string);
            string2 = URLUtil.normalizePort(string2);
        }
        return string.toString().equals(string2.toString());
    }

    public static String getProtocol(String string) {
        if (null == string) {
            return null;
        }
        int n = string.indexOf(58);
        if (-1 == n) {
            return "";
        }
        String string2 = string.substring(0, n);
        if (-1 != string2.indexOf(47) || -1 != string2.indexOf(46) || -1 != string2.indexOf(63) || -1 != string2.indexOf(37)) {
            return "";
        }
        return string2;
    }

    public static int getPort(String string) {
        int n = string.indexOf(58);
        if (-1 == n) {
            return -1;
        }
        if (URLUtil.getProtocol(string).equals(string.substring(0, n)) && -1 == (n = string.indexOf(58, n + 1))) {
            return -1;
        }
        int n2 = string.indexOf("/", n + 1);
        if (-1 == n2) {
            n2 = string.length();
        }
        int n3 = 0;
        for (int i = n + 1; i < n2; ++i) {
            char c = string.charAt(i);
            if ('0' > c || '9' < c) {
                return -1;
            }
            n3 *= 10;
            n3 += c - 48;
        }
        return n3;
    }

    public static int compareTo(String string, String string2) {
        if ("http".equals(URLUtil.getProtocol(string)) && "http".equals(URLUtil.getProtocol(string2)) && URLUtil.getPort(string) != URLUtil.getPort(string2)) {
            string = URLUtil.normalizePort(string);
            string2 = URLUtil.normalizePort(string2);
        }
        return string.compareTo(string2);
    }

    public static String getBaseURL(String string) {
        if (null == string) {
            return null;
        }
        String string2 = URLUtil.getProtocol(string);
        int n = string2.length();
        if (':' == string.charAt(n)) {
            ++n;
        }
        if (string2.equals("file")) {
            return "file:";
        }
        while ('/' == string.charAt(n)) {
            ++n;
        }
        int n2 = string.indexOf(47, n);
        if (-1 == n2) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    public static String getFile(String string) {
        return string.substring(URLUtil.getBaseURL(string).length(), string.length());
    }

    public static String getHost(String string) {
        int n;
        if (null == string) {
            return "";
        }
        String string2 = URLUtil.getBaseURL(string);
        if ((string2 = string2.substring(URLUtil.getProtocol(string2).length(), string2.length())).startsWith("://")) {
            string2 = string2.substring(3, string2.length());
        }
        if (-1 != (n = string2.indexOf(58))) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static String normalizePort(String string) {
        if (URLUtil.getPort(string) != -1) {
            return string;
        }
        String string2 = URLUtil.getBaseURL(string);
        int n = string2.length();
        return string2 + ":80" + string.substring(n, string.length());
    }

    public static String encodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                stringBuffer.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    URLUtil.escape(stringBuffer, c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u07ff') {
                URLUtil.escape(stringBuffer, (char)(0xE0 | c >> 12 & 0xF));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 6 & 0x3F));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            URLUtil.escape(stringBuffer, (char)(0xC0 | c >> 6 & 0x1F));
            URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
        }
        if (!string.equals(stringBuffer.toString())) {
            System.out.println("     String: " + string);
            System.out.println(" encoded to: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char c) {
        stringBuffer.append('%');
        stringBuffer.append(Integer.toHexString(c >> 4 & 0xF));
        stringBuffer.append(Integer.toHexString(c & 0xF));
    }

    public static String decodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '%') {
                ++n;
            } else {
                try {
                    c = URLUtil.unescape(string, n);
                    n += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = URLUtil.unescape(string, n);
                                n += 3;
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = URLUtil.unescape(string, n);
                                char c3 = URLUtil.unescape(string, n += 3);
                                n += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                new IllegalArgumentException().printStackTrace();
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            stringBuffer.append(c);
        }
        if (!string.equals(stringBuffer.toString())) {
            System.out.println("     String: " + string);
            System.out.println(" decoded to: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static char unescape(String string, int n) {
        return (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
    }

    public static String getDecodedPath(String string) {
        String string2 = string.substring(URLUtil.getBaseURL(string).length(), string.length());
        string2 = string2.replace('/', AbstractStorage.getSeparator());
        return URLUtil.decodePath(string2);
    }

    public static String getPathFromURL(String string) {
        return URLUtil.getDecodedPath(string);
    }

    public static synchronized String canonicalize(String string) {
        if (string.indexOf("file:") == -1) {
            return string;
        }
        String string2 = canonicalizedURLMap.get(string);
        if (string2 != null) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf("file://///") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(10));
        } else if (string.indexOf("file:///\\") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(9));
        } else if (string.indexOf("file://\\") == 0) {
            stringBuffer.append("file:////");
            stringBuffer.append(string.substring(9));
        } else if (string.indexOf("file:\\") == 0) {
            if (string.indexOf(58, 6) != -1 || string.indexOf(124, 6) != -1) {
                stringBuffer.append("file:///");
            } else {
                stringBuffer.append("file:////");
            }
            stringBuffer.append(string.substring(6));
        } else if (string.indexOf("file://") == 0 && string.charAt(7) != '/') {
            if (string.indexOf(58, 7) != -1 || string.indexOf(124, 7) != -1) {
                stringBuffer.append("file:///");
            } else {
                stringBuffer.append("file:////");
            }
            stringBuffer.append(string.substring(7));
        } else {
            stringBuffer.append(string);
        }
        boolean bl = false;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '\\') {
                stringBuffer.setCharAt(i, '/');
                continue;
            }
            if (bl || c != '|') continue;
            stringBuffer.setCharAt(i, ':');
            bl = true;
        }
        String string3 = stringBuffer.toString();
        canonicalizedURLMap.put(string, string3);
        return string3;
    }

    public static String canonicalizeDocumentBaseURL(String string) {
        int n = -1;
        int n2 = string.indexOf(35);
        int n3 = string.indexOf(63);
        if (n3 != -1 && n2 != -1) {
            n = Math.min(n2, n3);
        } else if (n2 != -1) {
            n = n2;
        } else if (n3 != -1) {
            n = n3;
        }
        String string2 = n == -1 ? string : string.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n4 = stringBuffer.toString().indexOf("|");
        if (n4 >= 0) {
            stringBuffer.setCharAt(n4, ':');
        }
        if (n != -1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string, boolean bl) {
        String string2 = string;
        if (AbstractStorage.getSeparator() != '/') {
            string2 = string2.replace(AbstractStorage.getSeparator(), '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl) {
            string2 = string2 + "/";
        }
        return string2;
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
        canonicalizedURLMap = new HashMap<String, String>();
    }

    public static class Bits {
        private byte[] bitArray;

        public Bits(int n) {
            int n2 = (n + 7) / 8;
            this.bitArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.bitArray[n3++] = 0;
            }
        }

        public void set(int n) {
            int n2 = n / 8;
            byte by = (byte)(1 << n % 8);
            if (n2 < this.bitArray.length) {
                int n3 = n2;
                this.bitArray[n3] = (byte)(this.bitArray[n3] & by);
            }
        }

        public boolean get(int n) {
            int n2 = n / 8;
            byte by = (byte)(1 << n % 8);
            return 0 != (this.bitArray[n2] & by);
        }
    }
}

