/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import com.sun.javafx.io.http.impl.BaseTask;
import com.sun.javafx.io.http.impl.WaitingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class BufferingInputStream
extends InputStream {
    private final WaitingOutputStream wos;
    private final InputStream is;
    private InputStream bis;

    public BufferingInputStream(InputStream inputStream, int n) {
        this.wos = new WaitingOutputStream(null, n);
        this.is = inputStream;
        this.bis = null;
    }

    public InputStream transfer(BaseTask baseTask, long l) throws IOException {
        if (baseTask.isCancelled()) {
            throw new InterruptedIOException("Cancelled");
        }
        int n = baseTask.optimalChunkSize(l);
        baseTask.notifyProgress(true, true, l);
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while ((n3 = this.is.read(byArray)) > 0) {
            if (baseTask.isCancelled()) {
                throw new InterruptedIOException("Cancelled");
            }
            this.wos.write(byArray, 0, n3);
            baseTask.notifyProgress(true, false, n2 += n3);
        }
        this.bis = this.wos.getInputStream();
        return this.bis;
    }

    public int read() throws IOException {
        return this.bis == null ? -1 : this.bis.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.bis == null ? -1 : this.bis.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.bis == null ? -1 : this.bis.read(byArray, n, n2);
    }

    public int available() throws IOException {
        return this.bis == null ? 0 : this.bis.available();
    }

    public void close() throws IOException {
        super.close();
        this.wos.close();
        this.is.close();
        if (this.bis != null) {
            this.bis.close();
            this.bis = null;
        }
    }

    public boolean markSupported() {
        return this.bis == null ? false : this.bis.markSupported();
    }

    public void mark(int n) {
        if (this.bis == null) {
            throw new IllegalStateException("operation not supported until transfer is complete");
        }
        this.bis.mark(n);
    }

    public void reset() throws IOException {
        if (this.bis == null) {
            throw new IllegalStateException("operation not supported until transfer is complete");
        }
        this.bis.reset();
    }

    public long skip(long l) throws IOException {
        if (this.bis == null) {
            throw new IllegalStateException("operation not supported until transfer is complete");
        }
        return this.bis.skip(l);
    }
}

