/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import com.sun.javafx.io.http.impl.BaseTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class WaitingOutputStream
extends ByteArrayOutputStream {
    private final OutputStream os;
    private volatile boolean closed = false;

    public WaitingOutputStream(OutputStream outputStream, int n) {
        super(n);
        this.os = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        this.closed = true;
        WaitingOutputStream waitingOutputStream = this;
        synchronized (waitingOutputStream) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilClosed() throws InterruptedException {
        while (!this.closed) {
            WaitingOutputStream waitingOutputStream = this;
            synchronized (waitingOutputStream) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(BaseTask baseTask, long l) throws IOException {
        try {
            if (baseTask.isCancelled()) {
                throw new InterruptedIOException("Cancelled");
            }
            if (l > Integer.MAX_VALUE) {
                throw new IOException("can't transfer because buffer size (" + l + ") exceeds Integer.MAX_VALUE");
            }
            baseTask.notifyProgress(false, true, this.count);
            int n = 0;
            int n2 = baseTask.optimalChunkSize(l);
            while (n < this.count) {
                if (baseTask.isCancelled()) {
                    throw new InterruptedIOException("Cancelled");
                }
                int n3 = Math.min(this.count - n, n2);
                this.os.write(this.buf, n, n3);
                baseTask.notifyProgress(false, false, n += n3);
            }
        }
        finally {
            this.os.close();
        }
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

