/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl.desktop;

import com.sun.javafx.io.http.impl.Connection;
import com.sun.javafx.util.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class DesktopConnection
implements Connection {
    private URLConnection connection;

    public void open(String string) throws IOException {
        URL uRL = new URL(string);
        this.connection = uRL.openConnection();
    }

    public void setMethod(String string) throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.connection;
            httpURLConnection.setRequestMethod(string);
            this.connection.setDoInput(true);
            if ("POST".equals(string) || "PUT".equals(string)) {
                this.connection.setDoOutput(true);
            }
        }
    }

    public void setRequestProperty(String string, String string2) throws IOException {
        this.connection.setRequestProperty(string, string2);
    }

    public void connect() throws IOException {
        try {
            this.connection.connect();
        }
        catch (SecurityException securityException) {
            if (Platform.checkConnectAcrossDomain(this.connection.getURL())) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            DesktopConnection.this.connection.connect();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable.getClass() == IOException.class) {
                        throw (IOException)throwable;
                    }
                    if (throwable.getClass() == RuntimeException.class) {
                        throw (RuntimeException)throwable;
                    }
                    IOException iOException = new IOException();
                    iOException.initCause(throwable);
                    throw iOException;
                }
            }
            throw securityException;
        }
    }

    public void close() throws IOException {
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public InputStream getErrorStream() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getErrorStream();
        }
        return null;
    }

    public int getResponseCode() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseCode();
        }
        return 0;
    }

    public String getResponseMessage() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseMessage();
        }
        return null;
    }

    public String getHeaderFieldKey(int n) throws IOException {
        return this.connection.getHeaderFieldKey(n);
    }

    public String getHeaderField(int n) throws IOException {
        return this.connection.getHeaderField(n);
    }
}

