/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.animation.AnimationProvider;
import com.sun.javafx.functions.Function0;
import com.sun.javafx.runtime.FXExit;
import com.sun.javafx.runtime.NamedArgumentProvider;
import com.sun.javafx.runtime.RuntimeProvider;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.lang.FX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    public static volatile Thread uiThread;
    private static RuntimeProvider provider;
    private static AnimationProvider animationProvider;
    private static String[] commandLineArgs;
    private static NamedArgumentProvider namedArgProvider;
    private static boolean loadAnimationProviderFailed;

    public static void start(final Class<?> clazz, String[] stringArray) throws Throwable {
        block9: {
            if (stringArray != null) {
                Entry.setNamedArgumentProvider(NamedArgumentProviderDefault.getInstance(stringArray));
                if (namedArgProvider == null) {
                    commandLineArgs = (String[])stringArray.clone();
                }
            }
            final Method method = clazz.getMethod(Entry.entryMethodName(), Sequence.class);
            Sequence<String> sequence = Sequences.make(TypeInfo.String, stringArray);
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            String string = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
                            SystemProperties.setFXProperty("javafx.application.codebase", string);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        method.setAccessible(true);
                        provider = Entry.runtimeProviderLocator();
                        return null;
                    }
                });
                if (provider != null && provider.usesRuntimeLibrary(clazz)) {
                    provider.run(method, stringArray);
                    break block9;
                }
                try {
                    method.invoke(null, sequence);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
            catch (AccessControlException accessControlException) {
                try {
                    method.invoke(null, sequence);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
        }
    }

    public static void deferAction(final Function0<Void> function0) {
        Entry.deferAction(new Runnable(){

            public void run() {
                function0.invoke$(null, null, null);
            }
        });
    }

    public static void deferAction(Runnable runnable) {
        if (provider == null) {
            provider = Entry.runtimeProviderLocator();
        }
        assert (provider != null);
        provider.deferAction(runnable);
    }

    public static void exit() {
        if (provider == null) {
            provider = Entry.runtimeProviderLocator();
        }
        assert (provider != null);
        provider.exit();
    }

    public static void setNamedArgumentProvider(NamedArgumentProvider namedArgumentProvider) {
        namedArgProvider = namedArgumentProvider;
    }

    public static Sequence<? extends String> getArguments() {
        return Sequences.make(TypeInfo.String, commandLineArgs);
    }

    private static Object getArgument(int n) {
        String[] stringArray = commandLineArgs;
        if (stringArray == null) {
            return null;
        }
        if (n < 0 || n >= stringArray.length) {
            return null;
        }
        return stringArray[n];
    }

    public static Object getArgument(String string) {
        NamedArgumentProvider namedArgumentProvider = namedArgProvider;
        Object object = null;
        if (namedArgumentProvider != null) {
            object = namedArgumentProvider.get(string);
        }
        if (object == null) {
            try {
                return Entry.getArgument(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return object;
    }

    public static AnimationProvider getAnimationProvider() {
        if (!loadAnimationProviderFailed && animationProvider == null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Entry.animationProvider = Entry.animationProviderLocator();
                    return null;
                }
            });
            if (animationProvider == null) {
                loadAnimationProviderFailed = true;
            }
        }
        return animationProvider;
    }

    private static AnimationProvider animationProviderLocator() {
        Iterator iterator;
        Object object;
        boolean bl;
        String string;
        Class<?> clazz;
        try {
            clazz = Class.forName("java.util.ServiceLoader", true, null);
            string = "load";
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("sun.misc.Service", true, null);
                string = "providers";
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new AssertionError((Object)"Failed discovering ServiceLoader");
            }
        }
        try {
            object = clazz.getMethod(string, Class.class, ClassLoader.class);
            ClassLoader classLoader = Entry.class.getClassLoader();
            Object object2 = ((Method)object).invoke(null, AnimationProvider.class, classLoader);
            if (bl) {
                Method method = clazz.getMethod("iterator", new Class[0]);
                object2 = method.invoke(object2, new Object[0]);
            }
            iterator = (Iterator)object2;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        if (iterator.hasNext()) {
            object = (AnimationProvider)iterator.next();
            return object;
        }
        return null;
    }

    private static RuntimeProvider runtimeProviderLocator() {
        Iterator iterator;
        Object object;
        boolean bl;
        String string;
        Class clazz;
        try {
            clazz = Class.forName("java.util.ServiceLoader", true, null);
            string = "load";
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = new Class[1];
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        object[0] = Class.forName("sun.misc.Service", true, null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        object[0] = null;
                    }
                    return null;
                }
            });
            clazz = object[0];
            string = "providers";
            bl = false;
        }
        if (clazz == null) {
            throw new AssertionError((Object)"Failed discovering ServiceLoader");
        }
        try {
            Method method = clazz.getMethod(string, Class.class, ClassLoader.class);
            object = Thread.currentThread().getContextClassLoader();
            Object object2 = method.invoke(null, RuntimeProvider.class, object);
            if (bl) {
                Method method2 = clazz.getMethod("iterator", new Class[0]);
                object2 = method2.invoke(object2, new Object[0]);
            }
            iterator = (Iterator)object2;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        try {
            return iterator.hasNext() ? (RuntimeProvider)iterator.next() : new NoRuntimeDefault();
        }
        catch (Error error) {
            if (error.getClass().getSimpleName().equals("ServiceConfigurationError")) {
                return new NoRuntimeDefault();
            }
            throw error;
        }
    }

    public static String entryMethodName() {
        return "javafx$run$";
    }

    static {
        loadAnimationProviderFailed = false;
    }

    private static class NamedArgumentProviderDefault
    implements NamedArgumentProvider {
        private static final char DELIMITER = '=';
        private Properties namedArguments;

        private NamedArgumentProviderDefault(Properties properties) {
            this.namedArguments = properties;
        }

        public Object get(String string) {
            return this.namedArguments.getProperty(string);
        }

        static NamedArgumentProvider getInstance(String[] stringArray) {
            Properties properties = new Properties();
            for (String string : stringArray) {
                int n = string.indexOf(61);
                if (n <= 0) {
                    return null;
                }
                properties.setProperty(string.substring(0, n), string.substring(n + 1));
            }
            return new NamedArgumentProviderDefault(properties);
        }
    }

    private static class NoRuntimeDefault
    extends Thread
    implements RuntimeProvider {
        private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();

        private NoRuntimeDefault() {
        }

        public boolean usesRuntimeLibrary(Class clazz) {
            return true;
        }

        public Object run(final Method method, final String ... stringArray) throws Throwable {
            this.taskQueue.add(new Runnable(){

                public void run() {
                    try {
                        NoRuntimeDefault.this.main(method, stringArray);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
            this.start();
            return null;
        }

        private boolean hasActiveAnimation() {
            if (animationProvider == null) {
                return false;
            }
            return animationProvider.hasActiveAnimation();
        }

        public void run() {
            try {
                Runnable runnable;
                while ((runnable = this.taskQueue.poll()) != null || this.hasActiveAnimation()) {
                    if (runnable != null) {
                        runnable.run();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
                FX.exit();
            }
            catch (FXExit fXExit) {
                return;
            }
        }

        private Object main(Method method, String ... stringArray) throws Throwable {
            try {
                return method.invoke(null, Sequences.make(TypeInfo.String, stringArray));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof FXExit) {
                    return null;
                }
                throw throwable;
            }
        }

        public void deferAction(Runnable runnable) {
            this.taskQueue.add(runnable);
        }

        public void exit() {
            try {
                System.exit(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

