/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.annotation.JavafxBindees;
import com.sun.javafx.runtime.sequence.Sequence;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FXDOTWriter {
    static final String FONTDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10";
    static final String GRAPHDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, rankdir=LR";
    static final String NODEDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, label=\"\\N\", shape=record, style=filled, fillcolor=lightgrey, color=black";
    static final String EDGEDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, arrowhead=open";
    static final String STARTNODESTYLE = "fillcolor=pink";
    static final String INTRAEDGESTYLE = "style=dashed, color=grey";
    static final String INTEREDGESTYLE = "style=dashed, color=darkGrey";
    private int objectLimit = 256;
    private int fieldLimit = 64;
    private int arrayLimit = 32;
    private int stringLimit = 32;
    private Map<Object, Node> visited = new IdentityHashMap<Object, Node>();
    Map<Class, Field[]> fieldCache = new HashMap<Class, Field[]>();
    Map<Class, FXField[]> fxFieldCache = new HashMap<Class, FXField[]>();
    private Properties graphProperties = new Properties();
    private Properties nodeProperties = new Properties();
    private Properties edgeProperties = new Properties();
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();
    private PrintStream dotStream;
    private boolean filtering = false;
    private Set<Object> includeObjects = new HashSet<Object>();
    private Set<Object> excludeObjects = new HashSet<Object>();
    private List<Class> includeClasses = new ArrayList<Class>();
    private List<Class> excludeClasses = new ArrayList<Class>();
    private boolean expandCollections = false;
    private boolean expandFXObjects = false;
    private boolean displayStatics = false;
    private boolean displayLinks = true;
    private boolean displayIntraDependencies = true;
    private boolean displayInterDependencies = true;
    private boolean displayFXFlags = false;

    public FXDOTWriter(String string) {
        try {
            this.dotStream = new PrintStream(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.graphProperties.addProperties(GRAPHDEFAULTS);
        this.nodeProperties.addProperties(NODEDEFAULTS);
        this.edgeProperties.addProperties(EDGEDEFAULTS);
    }

    public static void graph(String string, Object ... objectArray) {
        FXDOTWriter fXDOTWriter = new FXDOTWriter(string);
        String string2 = STARTNODESTYLE;
        for (Object object : objectArray) {
            if (object instanceof String) {
                string2 = (String)object;
                continue;
            }
            fXDOTWriter.addNode(string2, object);
        }
        fXDOTWriter.close();
    }

    public void addNodes(Object ... objectArray) {
        String string = null;
        for (Object object : objectArray) {
            if (object instanceof String) {
                string = (String)object;
                continue;
            }
            this.addNode(string, object);
        }
    }

    public void addNode(String string, Object object) {
        if (object == null) {
            return;
        }
        if (this.isPrimitive(object)) {
            return;
        }
        Node node = this.getNode(object);
        for (int i = this.nodes.size(); i < this.nodes.size(); ++i) {
            Node node2 = this.nodes.get(i);
            object = node2.object;
            Class<?> clazz = object.getClass();
            this.addHeader(object, clazz, node2);
            if (clazz.isArray()) {
                if (i < this.arrayLimit && this.shouldDetail(object)) {
                    this.addArrayDetail(object, node2);
                    continue;
                }
                this.addContinuation(node2);
                continue;
            }
            if (i < this.objectLimit && this.shouldDetail(object)) {
                if (!this.expandFXObjects && object instanceof FXObject) {
                    this.addFXObjectDetail(object, clazz, node2);
                    continue;
                }
                if (!this.expandFXObjects && object instanceof Sequence) {
                    this.addSequenceDetail(object, clazz, node2);
                    continue;
                }
                if (!this.expandCollections && object instanceof Collection) {
                    this.addCollectionDetail(object, clazz, node2);
                    continue;
                }
                if (!this.expandCollections && object instanceof Map) {
                    this.addMapDetail(object, clazz, node2);
                    continue;
                }
                if (this.displayStatics && object instanceof Class) {
                    this.addClassDetail(object, clazz, node2);
                    continue;
                }
                this.addObjectDetail(object, clazz, node2);
                continue;
            }
            this.addContinuation(node2);
        }
        if (string != null) {
            node.addProperties(string);
        }
    }

    public void objectLimit(int n) {
        this.objectLimit = n;
    }

    public void fieldLimit(int n) {
        this.fieldLimit = n;
    }

    public void arrayLimit(int n) {
        this.arrayLimit = n;
    }

    public void stringLimit(int n) {
        this.stringLimit = n;
    }

    public void expandCollections(boolean bl) {
        this.expandCollections = bl;
    }

    public void expandFXObjects(boolean bl) {
        this.expandFXObjects = bl;
    }

    public void displayFXFlags(boolean bl) {
        this.displayFXFlags = bl;
    }

    public void displayStatics(boolean bl) {
        this.displayStatics = bl;
    }

    public void displayLinks(boolean bl) {
        this.displayLinks = bl;
    }

    public void displayIntraDependencies(boolean bl) {
        this.displayIntraDependencies = bl;
    }

    public void displayInterDependencies(boolean bl) {
        this.displayInterDependencies = bl;
    }

    public void includeObjects(Object ... objectArray) {
        for (Object object : objectArray) {
            this.includeObjects.add(object);
        }
        this.filtering = true;
    }

    public void excludeObjects(Object ... objectArray) {
        for (Object object : objectArray) {
            this.excludeObjects.add(object);
        }
        this.filtering = true;
    }

    public void includeClasses(Class ... classArray) {
        for (Class clazz : classArray) {
            this.includeClasses.add(clazz);
        }
        this.filtering = true;
    }

    public void excludeClasses(Class ... classArray) {
        for (Class clazz : classArray) {
            this.excludeClasses.add(clazz);
        }
        this.filtering = true;
    }

    public void addEdge(Object object, Object object2) {
        this.addEdge(object, -1, object2, -1, null);
    }

    public void addEdge(Object object, Object object2, String string) {
        this.addEdge(object, -1, object2, -1, string);
    }

    public void addEdge(Object object, int n, Object object2, int n2) {
        this.addEdge(object, n, object2, n2, null);
    }

    public void addEdge(Object object, int n, Object object2, int n2, String string) {
        this.addEdge(this.getNode(object), n, this.getNode(object2), n2, string);
    }

    private void addEdge(Node node, int n, Node node2, int n2) {
        this.addEdge(node, n, node2, n2, null);
    }

    public void close() {
        if (this.dotStream != null) {
            this.writeGraph();
            this.dotStream.close();
            this.dotStream = null;
        }
    }

    private boolean isPrimitive(Object object) {
        return object.getClass().isPrimitive() || object instanceof Number || object instanceof Boolean || object instanceof String;
    }

    private void writeGraph() {
        this.dotStream.println("digraph g {");
        this.dotStream.print(" graph ");
        this.graphProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        this.dotStream.print(" node ");
        this.nodeProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        this.dotStream.print(" edge ");
        this.edgeProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        for (Node element : this.nodes) {
            this.dotStream.print(" node" + element.id + " ");
            element.writeProperties(this.dotStream);
            this.dotStream.println(";");
        }
        for (Edge edge : this.edges) {
            this.dotStream.print(" node" + edge.head.id + (edge.headFieldId < 0 ? ":f" : ":f" + edge.headFieldId));
            this.dotStream.print(" -> ");
            this.dotStream.print(" node" + edge.tail.id + (edge.tailFieldId < 0 ? ":f" : ":f" + edge.tailFieldId));
            this.dotStream.print(" ");
            edge.writeProperties(this.dotStream);
            this.dotStream.println(";");
        }
        this.dotStream.println("}");
    }

    private Node getNode(Object object) {
        if (object == null) {
            return null;
        }
        Node node = null;
        try {
            node = this.visited.get(object);
        }
        catch (Throwable throwable) {
            return null;
        }
        if (node == null) {
            node = new Node(this.nodes.size(), object);
            this.nodes.add(node);
            this.visited.put(object, node);
        }
        return node;
    }

    private boolean shouldDetail(Object object) {
        if (object == this) {
            return false;
        }
        if (!this.filtering) {
            return true;
        }
        if (!this.includeObjects.isEmpty()) {
            return this.includeObjects.contains(object);
        }
        if (!this.includeClasses.isEmpty()) {
            for (Class clazz : this.includeClasses) {
                if (!clazz.isInstance(object)) continue;
                return true;
            }
            return false;
        }
        if (!this.excludeObjects.isEmpty() && this.excludeObjects.contains(object)) {
            return false;
        }
        if (!this.excludeClasses.isEmpty()) {
            for (Class clazz : this.excludeClasses) {
                if (!clazz.isInstance(object)) continue;
                return false;
            }
        }
        return true;
    }

    private void addEdge(Node node, int n, Node node2, int n2, String string) {
        if (node == null || node2 == null) {
            return;
        }
        if (n > this.getLimit(node) && node.id >= this.objectLimit) {
            n = -1;
        }
        if (n2 > this.getLimit(node2) && node2.id >= this.objectLimit) {
            n2 = -1;
        }
        Edge edge = new Edge(this.edges.size(), node, n, node2, n2);
        if (string != null) {
            edge.addProperties(string);
        }
        this.edges.add(edge);
    }

    private int getLimit(Node node) {
        return node.object.getClass().isArray() ? this.arrayLimit : this.fieldLimit;
    }

    private String getClassName(Class clazz) {
        String string = clazz.getCanonicalName();
        if (string == null) {
            string = clazz.getName();
        }
        if (string == null) {
            string = clazz.getSimpleName();
        }
        return string;
    }

    private void addHeader(Object object, Class clazz, Node node) {
        if (this.displayStatics && object instanceof Class) {
            clazz = (Class)object;
        }
        String string = this.getClassName(clazz);
        if (object instanceof FXObject) {
            string = string + "(FX)";
        } else if (object instanceof Class) {
            string = string + "(Class)";
        }
        node.addProperty("label", "<f> " + string);
    }

    private void addContinuation(Node node) {
        node.extendProperty("label", " | ...");
    }

    private Object getValue(Field field, Object object) {
        Object object2 = null;
        try {
            object2 = field.get(object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return object2;
    }

    private int getIntValue(Field field, Object object) {
        int n = 0;
        try {
            n = field.getInt(object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    private Field[] getFields(Class clazz) {
        if (clazz == null) {
            return new Field[0];
        }
        if (this.displayStatics && clazz == Class.class) {
            return new Field[0];
        }
        Field[] fieldArray = this.fieldCache.get(clazz);
        if (fieldArray != null) {
            return fieldArray;
        }
        Field[] fieldArray2 = this.getFields(clazz.getSuperclass());
        Field[] fieldArray3 = clazz.getDeclaredFields();
        fieldArray = new Field[fieldArray2.length + fieldArray3.length];
        System.arraycopy(fieldArray2, 0, fieldArray, 0, fieldArray2.length);
        System.arraycopy(fieldArray3, 0, fieldArray, fieldArray2.length, fieldArray3.length);
        this.fieldCache.put(clazz, fieldArray);
        return fieldArray;
    }

    private void addObjectDetail(Object object, Class clazz, Node node) {
        Field[] fieldArray = this.getFields(clazz);
        if (this.displayStatics && fieldArray.length != 0) {
            this.addEdge(node, -1, this.getNode(clazz), -1);
        }
        for (int i = 0; i < fieldArray.length && i < this.fieldLimit; ++i) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 8) != 0) continue;
            field.setAccessible(true);
            String string = field.getName();
            Object object2 = this.getValue(field, object);
            Format format = new Format(object2);
            this.addNodeField(node, string, i, format.string);
            if (!this.displayLinks || format.isSimple) continue;
            this.addEdge(node, i, this.getNode(object2), -1);
        }
        if (fieldArray.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private void addClassDetail(Object object, Class clazz, Node node) {
        Field[] fieldArray = this.getFields((Class)object);
        for (int i = 0; i < fieldArray.length && i < this.fieldLimit; ++i) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 8) == 0) continue;
            field.setAccessible(true);
            String string = field.getName();
            Object object2 = this.getValue(field, object);
            Format format = new Format(object2);
            this.addNodeField(node, string, i, format.string);
            if (!this.displayLinks || format.isSimple) continue;
            this.addEdge(node, i, this.getNode(object2), -1);
        }
        if (fieldArray.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private FXField[] getFXFields(Object object, Class clazz) {
        Object object2;
        int n;
        Object object3;
        FXField[] fXFieldArray = this.fxFieldCache.get(clazz);
        if (fXFieldArray != null) {
            return fXFieldArray;
        }
        Field[] fieldArray = this.getFields(clazz);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<FXField> arrayList = new ArrayList<FXField>();
        if (this.getClassName(clazz).endsWith("$Script") && (object3 = clazz.getEnclosingClass()) != null) {
            Field[] fieldArray2 = this.getFields((Class)object3);
            n = fieldArray2.length;
            for (int i = 0; i < n; ++i) {
                object2 = fieldArray2[i];
                if ((((Field)object2).getModifiers() & 8) == 0) continue;
                hashMap.put(((Field)object2).getName(), object2);
            }
        }
        object3 = fieldArray;
        int n2 = ((Field[])object3).length;
        for (n = 0; n < n2; ++n) {
            Field field = object3[n];
            object2 = field.getName();
            hashMap.put((String)object2, field);
            if (!((String)object2).startsWith("VOFF$") || (field.getModifiers() & 8) == 0) continue;
            String string = ((String)object2).substring("VOFF$".length() - 1);
            String string2 = this.getClassName(field.getDeclaringClass()).replaceAll("\\.", "\\$");
            String string3 = field.getDeclaringClass().getSimpleName();
            String string4 = string.startsWith(string2, 1) ? string.substring(string2.length() + 2) : (string.startsWith(string3, 1) ? string.substring(string3.length() + 2) : string.substring(1));
            int n3 = this.getIntValue(field, null);
            FXField fXField = new FXField(string4, string, n3, null);
            arrayList.add(fXField);
        }
        int n4 = arrayList.size();
        fXFieldArray = new FXField[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            FXField fXField = (FXField)arrayList.get(n2);
            try {
                fXField.field = (Field)hashMap.get(fXField.varName);
                fXField.bindees = fXField.field.getAnnotation(JavafxBindees.class).value();
                fXField.flags = ((Field)hashMap.get("VFLG" + fXField.varName)).getInt(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            fXFieldArray[n2] = fXField;
        }
        this.fxFieldCache.put(clazz, fXFieldArray);
        return fXFieldArray;
    }

    private FXField findField(FXField[] fXFieldArray, String string) {
        for (FXField fXField : fXFieldArray) {
            if (!string.equals(fXField.varName)) continue;
            return fXField;
        }
        return null;
    }

    private void addFXObjectDetail(Object object, Class clazz, Node node) {
        FXField[] fXFieldArray = this.getFXFields(object, clazz);
        for (int i = 0; i < fXFieldArray.length && i < this.fieldLimit; ++i) {
            String string;
            FXField fXField = fXFieldArray[i];
            Field field = fXField.field;
            field.setAccessible(true);
            String string2 = fXField.name;
            Object object2 = this.getValue(field, object);
            if (this.displayFXFlags) {
                string2 = string2 + " (0x" + Integer.toHexString(fXField.flags) + ")";
            }
            Format format = new Format(object2);
            this.addNodeField(node, string2, fXField.voff, format.string);
            if (this.displayLinks && !format.isSimple) {
                this.addEdge(node, fXField.voff, this.getNode(object2), -1);
            }
            if ((string = fXField.bindees) == null || !this.displayIntraDependencies && !this.displayInterDependencies) continue;
            for (String string3 : string.split(",")) {
                Object object3;
                String[] stringArray = string3.split("\\.");
                FXField fXField2 = this.findField(fXFieldArray, stringArray[0]);
                if (stringArray.length == 1) {
                    if (!this.displayIntraDependencies) continue;
                    this.addEdge(node, fXField2.voff, node, fXField.voff, INTRAEDGESTYLE);
                    continue;
                }
                if (!this.displayInterDependencies || (object3 = this.getValue(fXField2.field, object)) == null) continue;
                FXField[] fXFieldArray2 = this.getFXFields(object3, object3.getClass());
                FXField fXField3 = this.findField(fXFieldArray2, stringArray[1]);
                this.addEdge(this.getNode(object3), fXField3.voff, node, fXField.voff, INTEREDGESTYLE);
            }
        }
        if (fXFieldArray.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private void addSequenceDetail(Object object, Class clazz, Node node) {
        Sequence sequence = (Sequence)object;
        int n = Math.min(sequence.size(), this.arrayLimit + 1);
        Object[] objectArray = new Object[n];
        sequence.toArray(0, n, objectArray, 0);
        this.addArrayDetail(objectArray, node);
    }

    private void addCollectionDetail(Object object, Class clazz, Node node) {
        Object[] objectArray = ((Collection)object).toArray();
        this.addArrayDetail(objectArray, node);
    }

    private void addMapDetail(Object object, Class clazz, Node node) {
        Object[] objectArray = ((Map)object).entrySet().toArray();
        this.addArrayDetail(objectArray, node);
    }

    private void addArrayDetail(Object object, Node node) {
        int n = Array.getLength(object);
        if (object instanceof char[] || object instanceof byte[] && this.allASCII((byte[])object)) {
            Format format = new Format(object);
            String string = " | " + format.string;
            node.extendProperty("label", string);
            n = 0;
        } else {
            for (int i = 0; i < n && i < this.arrayLimit; ++i) {
                Object object2 = Array.get(object, i);
                Format format = new Format(object2);
                this.addNodeField(node, null, i, format.string);
                if (!this.displayLinks || format.isSimple) continue;
                this.addEdge(node, i, this.getNode(object2), -1);
            }
        }
        if (n >= this.arrayLimit) {
            this.addContinuation(node);
        }
    }

    private void addNodeField(Node node, String string, int n, String string2) {
        String string3 = " | ";
        string3 = string3 + "<f" + n + "> ";
        if (string != null) {
            string3 = string3 + string + ": ";
        }
        string3 = string3 + string2;
        node.extendProperty("label", string3);
    }

    private String formatString(String string, String string2) {
        boolean bl;
        boolean bl2 = bl = string.length() > this.stringLimit;
        if (bl) {
            string = string.substring(0, this.stringLimit - 1);
        }
        string = string2 + string + string2;
        if (bl) {
            string = string + "...";
        }
        return string;
    }

    private static String escapeString(String string) {
        if (FXDOTWriter.needsEscape(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\"');
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.current();
            while (c != '\uffff') {
                if (c == '\"' || c == '\'' || c == '{' || c == '}' || c == '[' || c == ']') {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                } else if (c < ' ' || c > '~') {
                    stringBuilder.append("\\\\u");
                    String string2 = "0000" + Integer.toHexString(c);
                    string2 = string2.substring(string2.length() - 4);
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append(c);
                }
                c = stringCharacterIterator.next();
            }
            stringBuilder.append('\"');
            string = stringBuilder.toString();
        }
        return string;
    }

    private static boolean needsEscape(String string) {
        if (string.length() > 0 && string.charAt(0) == '\"') {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (!Character.isJavaIdentifierPart(c) && c != '-') {
                return true;
            }
            c = stringCharacterIterator.next();
        }
        return false;
    }

    private boolean allASCII(byte[] byArray) {
        for (byte by : byArray) {
            char c = (char)by;
            if (c >= ' ' || '~' >= c) continue;
            return false;
        }
        return false;
    }

    static class Edge
    extends Element {
        Node head;
        int headFieldId;
        Node tail;
        int tailFieldId;

        Edge(int n, Node node, int n2, Node node2, int n3) {
            super(n);
            this.head = node;
            this.headFieldId = n2;
            this.tail = node2;
            this.tailFieldId = n3;
        }
    }

    static class Element
    extends Properties {
        int id;

        Element(int n) {
            this.id = n;
        }
    }

    class FXField {
        static final String voffPrefix = "VOFF$";
        static final String vflgPrefix = "VFLG";
        String name;
        String varName;
        int voff;
        int flags;
        Field field;
        String bindees;

        FXField(String string, String string2, int n, Field field) {
            this.name = string;
            this.varName = string2;
            this.voff = n;
        }
    }

    class Format {
        String string = "";
        boolean isSimple = true;

        Format(Object object) {
            if (object == null) {
                this.string = this.string + object;
                this.isSimple = false;
            } else if (object instanceof String) {
                this.string = FXDOTWriter.this.formatString((String)object, "\"");
            } else if (object instanceof char[]) {
                this.string = FXDOTWriter.this.formatString(new String((char[])object), "'");
            } else if (object instanceof byte[] && FXDOTWriter.this.allASCII((byte[])object)) {
                this.string = FXDOTWriter.this.formatString(new String((byte[])object), "'");
            } else if (object instanceof Character) {
                Character c = (Character)object;
                this.string = "'" + c + "'";
            } else if (!FXDOTWriter.this.expandCollections && object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Format format = new Format(entry.getKey());
                Format format2 = new Format(entry.getValue());
                if (!format.isSimple) {
                    this.isSimple = false;
                } else {
                    this.string = format.string + "-\\>";
                    if (format2.isSimple) {
                        this.string = this.string + format2.string;
                    } else {
                        this.isSimple = false;
                    }
                }
            } else if (FXDOTWriter.this.isPrimitive(object)) {
                this.string = this.string + object;
            } else {
                this.isSimple = false;
            }
        }
    }

    static class Node
    extends Element {
        Object object;

        Node(int n, Object object) {
            super(n);
            this.object = object;
        }
    }

    static class Properties {
        private Map<String, String> properties = new HashMap<String, String>();

        Properties() {
        }

        void addProperty(String string, String string2) {
            this.properties.put(string, string2);
        }

        void addProperties(String string) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\s*,\\s*")) {
                String[] stringArray2 = string2.split("\\s*=\\s*");
                if (stringArray2.length == 1) {
                    this.properties.put(stringArray2[0], "true");
                    continue;
                }
                this.properties.put(stringArray2[0], stringArray2[1]);
            }
        }

        void extendProperty(String string, String string2) {
            String string3 = this.getProperty(string);
            if (string3 == null) {
                string3 = "";
            }
            string3 = string3 + string2;
            this.addProperty(string, string3);
        }

        String getProperty(String string) {
            return this.properties.get(string);
        }

        void writeProperties(PrintStream printStream) {
            if (!this.properties.isEmpty()) {
                printStream.print("[");
                String string = "";
                for (String string2 : this.properties.keySet()) {
                    String string3 = this.properties.get(string2);
                    if (string3.equals("true")) {
                        printStream.print(string + string2);
                    } else {
                        printStream.print(string + string2 + "=" + FXDOTWriter.escapeString(string3));
                    }
                    string = ", ";
                }
                printStream.print("]");
            }
        }
    }
}

