/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.FXBase;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.annotation.JavafxSignature;
import javafx.animation.KeyValueTarget;

public class Pointer
implements KeyValueTarget {
    private final KeyValueTarget.Type type;
    private final FXObject obj;
    private final int varnum;

    @JavafxSignature(value="(Ljava/lang/Object;)Lcom/sun/javafx/runtime/Pointer;")
    public static Pointer make(KeyValueTarget.Type type, FXObject fXObject, int n) {
        return new Pointer(type, fXObject, n);
    }

    public static boolean equals(Pointer pointer, Pointer pointer2) {
        return pointer == null ? pointer2 == null : pointer.equals(pointer2);
    }

    private Pointer(KeyValueTarget.Type type, FXObject fXObject, int n) {
        this.type = type;
        this.obj = fXObject;
        this.varnum = n;
    }

    public Object getDefaultValue() {
        switch (this.type) {
            case BYTE: {
                return (byte)0;
            }
            case SHORT: {
                return (short)0;
            }
            case INTEGER: {
                return 0;
            }
            case LONG: {
                return 0L;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case BOOLEAN: {
                return false;
            }
            case SEQUENCE: {
                return TypeInfo.Object.emptySequence;
            }
            case OBJECT: {
                return null;
            }
        }
        return null;
    }

    public FXObject getFXObject() {
        return this.obj;
    }

    public int getVarNum() {
        return this.varnum;
    }

    public KeyValueTarget.Type getType() {
        return this.type;
    }

    public Pointer unwrap() {
        return this;
    }

    public Object get() {
        return this.obj != null ? this.obj.get$(this.varnum) : this.getDefaultValue();
    }

    public Object get(int n) {
        assert (this.type == KeyValueTarget.Type.SEQUENCE) : "expecting a sequence type";
        return this.obj != null ? this.obj.elem$(this.varnum, n) : null;
    }

    public void set(Object object) {
        if (this.obj != null) {
            this.obj.set$(this.varnum, object);
        }
    }

    public void set(int n, Object object) {
        assert (this.type == KeyValueTarget.Type.SEQUENCE) : "expecting a sequence type";
        if (this.obj != null) {
            this.obj.set$(this.varnum, object);
        }
    }

    public int size() {
        assert (this.type == KeyValueTarget.Type.SEQUENCE) : "expecting a sequence type";
        return this.obj != null ? this.obj.size$(this.varnum) : 0;
    }

    public Object getValue() {
        return this.get();
    }

    public void setValue(Object object) {
        this.set(object);
    }

    public boolean equals(Object object) {
        if (object instanceof Pointer) {
            Pointer pointer = (Pointer)object;
            return this.obj == pointer.obj && this.varnum == pointer.varnum;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.obj) ^ this.varnum;
    }

    public void addDependency(FXObject fXObject) {
        if (this.obj != null) {
            this.obj.addDependent$(this.varnum, fXObject, 0);
        }
    }

    public void removeDependency(FXObject fXObject) {
        if (this.obj != null) {
            this.obj.removeDependent$(this.varnum, fXObject);
        }
    }

    public static void switchDependence(Pointer pointer, Pointer pointer2, FXObject fXObject, int n) {
        if (pointer != pointer2 && fXObject != null) {
            FXObject fXObject2 = pointer != null ? pointer.getFXObject() : null;
            FXObject fXObject3 = pointer2 != null ? pointer2.getFXObject() : null;
            int n2 = pointer != null ? pointer.getVarNum() : 0;
            int n3 = pointer2 != null ? pointer2.getVarNum() : 0;
            fXObject.switchDependence$(fXObject2, n2, fXObject3, n3, n);
        }
    }

    public BoundPointer bind(Pointer pointer) {
        final FXObject fXObject = this.getFXObject();
        final int n = this.getVarNum();
        final int n2 = pointer.getVarNum();
        FXBase fXBase = new FXBase(){

            public boolean update$(FXObject fXObject2, int n6, int n22, int n3, int n4, int n5) {
                if ((n5 & 8) == 8 && fXObject != null) {
                    fXObject.set$(n, fXObject2.get$(n2));
                }
                return true;
            }
        };
        this.set(n, pointer.get());
        pointer.addDependency(fXBase);
        return new BoundPointer(this, pointer, fXBase);
    }

    public static class BoundPointer
    extends Pointer {
        private Pointer srcPtr;
        private FXObject listener;

        private BoundPointer(Pointer pointer, Pointer pointer2, FXObject fXObject) {
            super(pointer.getType(), pointer.getFXObject(), pointer.getVarNum());
            this.srcPtr = pointer2;
            this.listener = fXObject;
        }

        public void unbind() {
            this.srcPtr.removeDependency(this.listener);
            this.srcPtr = null;
            this.listener = null;
        }
    }
}

