/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.liveconnect;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.ConversionDelegate;
import java.util.List;
import javafx.reflect.FXClassType;
import javafx.reflect.FXLocal;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceType;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class FXConversionDelegate
implements ConversionDelegate {
    private FXLocal.Context context = FXLocal.getContext();
    private Bridge bridge;
    private static final int TOSTRING_CONVERSION_PENALTY = 50;
    private static final int JSOBJECT_CONVERSION_PENALTY = 2500;
    private FXType booleanType;
    private FXType charType;
    private FXType byteType;
    private FXType shortType;
    private FXType integerType;
    private FXType longType;
    private FXType floatType;
    private FXType doubleType;

    public FXConversionDelegate(Bridge bridge) {
        this.bridge = bridge;
        this.booleanType = this.context.getBooleanType();
        this.charType = this.context.getCharacterType();
        this.byteType = this.context.getByteType();
        this.shortType = this.context.getShortType();
        this.integerType = this.context.getIntegerType();
        this.longType = this.context.getLongType();
        this.floatType = this.context.getFloatType();
        this.doubleType = this.context.getDoubleType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int conversionCost(Object object, Object object2) {
        FXClassType fXClassType;
        if (!(object2 instanceof FXType)) {
            return -1;
        }
        FXType fXType = (FXType)object2;
        if (object == null) {
            if (!(fXType instanceof FXPrimitiveType)) return 0;
            return -1;
        }
        if (fXType instanceof FXPrimitiveType) {
            if (fXType.equals(this.floatType) ? object instanceof Float : (fXType.equals(this.doubleType) ? object instanceof Double : (fXType.equals(this.booleanType) ? object instanceof Boolean : (fXType.equals(this.integerType) ? object instanceof Integer : (fXType.equals(this.longType) ? object instanceof Long : (fXType.equals(this.shortType) ? object instanceof Short : (fXType.equals(this.byteType) ? object instanceof Byte : fXType.equals(this.charType) && object instanceof Character))))))) {
                return 0;
            }
            if (!(object instanceof String) && !(object instanceof Number) && !(object instanceof Character) && !(object instanceof Boolean)) return -1;
            return 1;
        }
        if (object instanceof JSObject) {
            if (!this.canConvert((JSObject)object, fXType)) return -1;
            return 2500;
        }
        if (!(fXType instanceof FXClassType)) {
            return -1;
        }
        if (object instanceof FXValue) {
            if (!(object instanceof FXObjectValue)) return -1;
            fXClassType = ((FXObjectValue)object).getClassType();
        } else {
            fXClassType = this.context.makeClassRef(object.getClass());
        }
        if (!fXClassType.equals(fXType)) return this.conversionDistance(fXClassType, (FXClassType)fXType);
        return 0;
    }

    private int conversionDistance(FXClassType fXClassType, FXClassType fXClassType2) {
        int n = this.conversionDistance(fXClassType, fXClassType2, 0);
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        return n;
    }

    private int conversionDistance(FXClassType fXClassType, FXClassType fXClassType2, int n) {
        if (fXClassType.equals(fXClassType2)) {
            return n;
        }
        List<FXClassType> list = fXClassType.getSuperClasses(false);
        int n2 = Integer.MAX_VALUE;
        for (FXClassType fXClassType3 : list) {
            n2 = Math.min(n2, this.conversionDistance(fXClassType3, fXClassType2, 1 + n));
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean convert(Object object, Object object2, Object[] objectArray) throws Exception {
        void var5_10;
        if (!(object2 instanceof FXType)) {
            return false;
        }
        FXType fXType = (FXType)object2;
        if (object == null) {
            return true;
        }
        if (fXType instanceof FXPrimitiveType) {
            boolean bl = object instanceof Number;
            if (fXType.equals(this.floatType)) {
                if (bl) {
                    objectArray[0] = this.context.mirrorOf(((Number)object).floatValue());
                    return true;
                }
                if (object instanceof String) {
                    objectArray[0] = this.context.mirrorOf(Float.valueOf((String)object));
                    return true;
                }
                if (object instanceof Boolean) {
                    objectArray[0] = this.context.mirrorOf((Boolean)object != false ? 1.0f : 0.0f);
                    return true;
                }
                if (!(object instanceof Character)) throw FXConversionDelegate.inconvertible(object, fXType);
                objectArray[0] = this.context.mirrorOf((float)((Character)object).charValue());
                return true;
            }
            if (fXType.equals(this.doubleType)) {
                if (bl) {
                    objectArray[0] = this.context.mirrorOf(((Number)object).doubleValue());
                    return true;
                }
                if (object instanceof String) {
                    objectArray[0] = this.context.mirrorOf(Double.valueOf((String)object));
                    return true;
                }
                if (object instanceof Boolean) {
                    objectArray[0] = this.context.mirrorOf((Boolean)object != false ? 1.0 : 0.0);
                    return true;
                }
                if (!(object instanceof Character)) throw FXConversionDelegate.inconvertible(object, fXType);
                objectArray[0] = this.context.mirrorOf((double)((Character)object).charValue());
                return true;
            }
            if (fXType.equals(this.integerType)) {
                if (bl) {
                    objectArray[0] = this.context.mirrorOf(((Number)object).intValue());
                    return true;
                }
                if (object instanceof String) {
                    objectArray[0] = this.context.mirrorOf(Integer.valueOf((String)object));
                    return true;
                }
                if (object instanceof Boolean) {
                    objectArray[0] = this.context.mirrorOf((Boolean)object != false ? 1 : 0);
                    return true;
                }
                if (!(object instanceof Character)) throw FXConversionDelegate.inconvertible(object, fXType);
                objectArray[0] = this.context.mirrorOf((int)((Character)object).charValue());
                return true;
            }
            if (fXType.equals(this.longType)) {
                if (bl) {
                    objectArray[0] = this.context.mirrorOf(((Number)object).longValue());
                    return true;
                }
                if (object instanceof String) {
                    objectArray[0] = this.context.mirrorOf(Long.valueOf((String)object));
                    return true;
                }
                if (object instanceof Boolean) {
                    objectArray[0] = this.context.mirrorOf((Boolean)object != false ? 1L : 0L);
                    return true;
                }
                if (!(object instanceof Character)) throw FXConversionDelegate.inconvertible(object, fXType);
                objectArray[0] = this.context.mirrorOf((long)((Character)object).charValue());
                return true;
            }
            if (fXType.equals(this.shortType)) {
                if (bl) {
                    objectArray[0] = this.context.mirrorOf(((Number)object).shortValue());
                    return true;
                }
                if (object instanceof String) {
                    objectArray[0] = this.context.mirrorOf(Short.valueOf((String)object));
                    return true;
                }
                if (object instanceof Boolean) {
                    objectArray[0] = this.context.mirrorOf((Boolean)object != false ? (short)1 : 0);
                    return true;
                }
                if (!(object instanceof Character)) throw FXConversionDelegate.inconvertible(object, fXType);
                objectArray[0] = this.context.mirrorOf((short)((Character)object).charValue());
                return true;
            }
            if (fXType.equals(this.byteType)) {
                if (bl) {
                    objectArray[0] = this.context.mirrorOf(((Number)object).byteValue());
                    return true;
                }
                if (object instanceof String) {
                    objectArray[0] = this.context.mirrorOf(Byte.valueOf((String)object));
                    return true;
                }
                if (object instanceof Boolean) {
                    objectArray[0] = this.context.mirrorOf((Boolean)object != false ? (byte)1 : 0);
                    return true;
                }
                if (!(object instanceof Character)) throw FXConversionDelegate.inconvertible(object, fXType);
                objectArray[0] = this.context.mirrorOf((byte)((Character)object).charValue());
                return true;
            }
            if (!fXType.equals(this.booleanType)) throw FXConversionDelegate.inconvertible(object, fXType);
            if (object instanceof Boolean) {
                objectArray[0] = this.context.mirrorOf((Boolean)object);
                return true;
            }
            if (bl) {
                double d = ((Number)object).doubleValue();
                objectArray[0] = this.context.mirrorOf(!Double.isNaN(d) && d != 0.0);
                return true;
            }
            if (object instanceof String) {
                objectArray[0] = this.context.mirrorOf(((String)object).length() != 0);
                return true;
            }
            if (!(object instanceof Character)) throw FXConversionDelegate.inconvertible(object, fXType);
            objectArray[0] = this.context.mirrorOf(((Character)object).charValue() != '\u0000');
            return true;
        }
        if (object instanceof JSObject) {
            if (this.isStringType(fXType)) {
                objectArray[0] = this.context.mirrorOf(object.toString());
            } else {
                if (!(fXType instanceof FXSequenceType)) throw FXConversionDelegate.inconvertible(object, fXType);
                try {
                    JSObject jSObject = (JSObject)object;
                    FXType fXType2 = ((FXSequenceType)fXType).getComponentType();
                    int n = ((Number)jSObject.getMember("length")).intValue();
                    FXValue[] fXValueArray = new FXValue[n];
                    Object[] objectArray2 = new Object[1];
                    for (int i = 0; i < n; ++i) {
                        Object object3 = null;
                        try {
                            object3 = jSObject.getSlot(i);
                        }
                        catch (JSException jSException) {
                            // empty catch block
                        }
                        if (object3 == null) continue;
                        this.convert(object3, fXType2, objectArray2);
                        fXValueArray[i] = (FXValue)objectArray2[0];
                    }
                    objectArray[0] = this.context.makeSequence(fXType2, fXValueArray);
                    return true;
                }
                catch (Exception exception) {
                    throw FXConversionDelegate.inconvertible(object, fXType, exception);
                }
            }
        }
        if (!(fXType instanceof FXClassType)) {
            throw FXConversionDelegate.inconvertible(object, fXType);
        }
        if (object instanceof FXValue) {
            if (!(object instanceof FXObjectValue)) throw FXConversionDelegate.inconvertible(object, fXType);
            FXClassType fXClassType = ((FXObjectValue)object).getClassType();
        } else {
            FXLocal.ClassType classType = this.context.makeClassRef(object.getClass());
        }
        if (!fXType.isAssignableFrom((FXType)var5_10)) {
            throw FXConversionDelegate.inconvertible((FXType)var5_10, fXType);
        }
        objectArray[0] = object instanceof FXValue ? (FXValue)object : this.context.mirrorOf(object);
        return true;
    }

    private boolean isStringType(FXType fXType) {
        return fXType instanceof FXLocal.ClassType && ((FXLocal.ClassType)fXType).getJavaImplementationClass() == String.class;
    }

    private boolean canConvert(JSObject jSObject, FXType fXType) {
        if (this.isStringType(fXType)) {
            return true;
        }
        if (fXType instanceof FXSequenceType) {
            try {
                jSObject.getMember("length");
                return true;
            }
            catch (JSException jSException) {
                // empty catch block
            }
        }
        return false;
    }

    private static IllegalArgumentException inconvertible(Object object, FXType fXType) {
        return FXConversionDelegate.inconvertible(object, fXType, null);
    }

    private static IllegalArgumentException inconvertible(Object object, FXType fXType, Exception exception) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Object " + object + " can not be converted to " + fXType);
        if (exception != null) {
            illegalArgumentException.initCause(exception);
        }
        return illegalArgumentException;
    }

    private static IllegalArgumentException inconvertible(FXType fXType, FXType fXType2) {
        return FXConversionDelegate.inconvertible(fXType, fXType2, null);
    }

    private static IllegalArgumentException inconvertible(FXType fXType, FXType fXType2, Exception exception) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("FXType " + fXType.getName() + " can not be converted to " + fXType2.getName());
        if (exception != null) {
            illegalArgumentException.initCause(exception);
        }
        return illegalArgumentException;
    }
}

