/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArraySequence
extends ArraySequence<Boolean> {
    boolean[] array;

    public BooleanArraySequence(int n, TypeInfo<Boolean> typeInfo) {
        super(typeInfo);
        this.array = new boolean[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public BooleanArraySequence(int n) {
        this(n, TypeInfo.Boolean);
    }

    public BooleanArraySequence() {
        this(16, TypeInfo.Boolean);
    }

    public BooleanArraySequence(TypeInfo<Boolean> typeInfo, boolean ... blArray) {
        this(typeInfo, blArray, false);
    }

    public BooleanArraySequence(TypeInfo<Boolean> typeInfo, boolean[] blArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = blArray;
        } else {
            this.array = new boolean[blArray.length];
            System.arraycopy(blArray, 0, this.array, 0, blArray.length);
        }
        this.gapStart = this.gapEnd = blArray.length;
    }

    public BooleanArraySequence(boolean[] blArray, int n, int n2) {
        super(TypeInfo.Boolean);
        this.array = new boolean[n2];
        System.arraycopy(blArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public BooleanArraySequence(Sequence<? extends Boolean> sequence) {
        super(TypeInfo.Boolean);
        int n = sequence.size();
        this.array = new boolean[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new boolean[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (boolean[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Boolean getRawArrayElementAsObject(int n) {
        return this.array[n];
    }

    public BooleanArraySequence makeNew(int n) {
        return new BooleanArraySequence(n, this.getElementType());
    }

    @Override
    public boolean getAsBoolean(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return false;
        }
        return this.array[n];
    }

    public void add(boolean bl) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = bl;
    }

    @Override
    public void add(Sequence<? extends Boolean> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, boolean[] blArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, blArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, blArray, n3, n2);
    }

    @Override
    protected BooleanArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        BooleanArraySequence booleanArraySequence = new BooleanArraySequence(n3, this.getElementType());
        booleanArraySequence.addFromArray(this.array, 0, n);
        booleanArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return booleanArraySequence;
    }

    public void replace(int n, boolean bl) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = bl;
    }

    public void replace(int n, int n2, boolean bl, boolean bl2) {
        if (n2 == n + 1 && !bl2) {
            this.replace(n, bl);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl2 ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = bl;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Boolean> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static boolean extractOldElement(ArraySequence<Boolean> arraySequence, Sequence<? extends Boolean> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3);
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3);
            }
        }
        return (Boolean)arraySequence.getDefaultValue();
    }

    public static boolean extractNewElement(ArraySequence<Boolean> arraySequence, int n, Sequence<? extends Boolean> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2);
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2);
        }
        return (Boolean)arraySequence.getDefaultValue();
    }
}

