/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NumberRangeSequence
extends AbstractSequence<Float>
implements Sequence<Float> {
    private final float start;
    private final float step;
    private final int size;

    public NumberRangeSequence(float f, float f2, float f3, boolean bl) {
        super(TypeInfo.Float);
        if (f3 == 0.0f) {
            throw new IllegalArgumentException("Range step of zero");
        }
        this.start = f;
        this.step = f3;
        this.size = Sequences.calculateFloatRangeSize(f, f2, f3, bl);
    }

    public NumberRangeSequence(float f, float f2, float f3) {
        this(f, f2, f3, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Float get(int n) {
        if (n < 0 || n >= this.size) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(this.start + (float)n * this.step);
    }

    @Override
    public float getAsFloat(int n) {
        if (n < 0 || n >= this.size) {
            return 0.0f;
        }
        return this.start + (float)n * this.step;
    }

    @Override
    public void toArray(int n, int n2, Object[] objectArray, int n3) {
        if (n < 0 || n2 > 0 && n + n2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        float f = this.start + (float)n * this.step;
        for (int i = n3; i < n3 + n2; ++i) {
            objectArray[i] = Float.valueOf(f);
            f += this.step;
        }
    }
}

