/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArraySequence
extends ArraySequence<Short> {
    short[] array;

    public ShortArraySequence(int n, TypeInfo<Short> typeInfo) {
        super(typeInfo);
        this.array = new short[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public ShortArraySequence(int n) {
        this(n, TypeInfo.Short);
    }

    public ShortArraySequence() {
        this(16, TypeInfo.Short);
    }

    public ShortArraySequence(TypeInfo<Short> typeInfo, short ... sArray) {
        this(typeInfo, sArray, false);
    }

    public ShortArraySequence(TypeInfo<Short> typeInfo, short[] sArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = sArray;
        } else {
            this.array = new short[sArray.length];
            System.arraycopy(sArray, 0, this.array, 0, sArray.length);
        }
        this.gapStart = this.gapEnd = sArray.length;
    }

    public ShortArraySequence(short[] sArray, int n, int n2) {
        super(TypeInfo.Short);
        this.array = new short[n2];
        System.arraycopy(sArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public ShortArraySequence(Sequence<? extends Short> sequence) {
        super(TypeInfo.Short);
        int n = sequence.size();
        this.array = new short[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new short[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (short[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Short getRawArrayElementAsObject(int n) {
        return this.array[n];
    }

    public ShortArraySequence makeNew(int n) {
        return new ShortArraySequence(n, this.getElementType());
    }

    @Override
    public short getAsShort(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return 0;
        }
        return this.array[n];
    }

    public void add(short s) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = s;
    }

    @Override
    public void add(Sequence<? extends Short> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, short[] sArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, sArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, sArray, n3, n2);
    }

    @Override
    protected ShortArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        ShortArraySequence shortArraySequence = new ShortArraySequence(n3, this.getElementType());
        shortArraySequence.addFromArray(this.array, 0, n);
        shortArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return shortArraySequence;
    }

    public void replace(int n, short s) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = s;
    }

    public void replace(int n, int n2, short s, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, s);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = s;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Short> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static short extractOldElement(ArraySequence<Short> arraySequence, Sequence<? extends Short> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3);
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3);
            }
        }
        return (Short)arraySequence.getDefaultValue();
    }

    public static short extractNewElement(ArraySequence<Short> arraySequence, int n, Sequence<? extends Short> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2);
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2);
        }
        return (Short)arraySequence.getDefaultValue();
    }
}

