/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.desktop;

import com.sun.imageio.plugins.gif.GIFImageMetadata;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.desktop.JUtil;
import com.sun.javafx.util.Platform;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class AWTImageLoader
implements ImageLoader {
    private Object frame;
    private Object[] frames;
    private int[] frameDelay;
    private String url;
    private int width;
    private int height;
    private boolean preserveRatio;
    private boolean smooth;
    private boolean error = false;
    private Exception exception = null;
    private static final ColorSpace srgbCS = ColorSpace.getInstance(1000);

    private void init(String string, int n, int n2, boolean bl, boolean bl2) {
        this.url = string;
        this.width = n <= 0 ? 0 : n;
        this.height = n2 <= 0 ? 0 : n2;
        this.preserveRatio = bl;
        this.smooth = bl2;
    }

    public AWTImageLoader(InputStream inputStream, int n, int n2, boolean bl, boolean bl2) {
        this.init(null, n, n2, bl, bl2);
        try {
            this.readImageFromStream(inputStream);
        }
        catch (IOException iOException) {
            this.error = true;
            this.exception = iOException;
        }
    }

    public AWTImageLoader(BufferedImage bufferedImage, int n, int n2, boolean bl, boolean bl2) {
        this.init(null, n, n2, bl, bl2);
        if (bufferedImage != null) {
            if ((bufferedImage = this.maybeScaleImage(bufferedImage, true)) != null) {
                this.width = bufferedImage.getWidth();
                this.height = bufferedImage.getHeight();
            }
            this.frame = this.asPlatformImage(bufferedImage);
        } else {
            this.frame = null;
        }
    }

    public AWTImageLoader(String string, int n, int n2, boolean bl, boolean bl2) {
        this.init(string, n, n2, bl, bl2);
        this.readImage();
    }

    public Object getFrame(int n) {
        if (this.frame != null) {
            return this.frame;
        }
        if (this.frames != null && n < this.frames.length) {
            return this.frames[n];
        }
        return null;
    }

    public Object[] getFrames() {
        return this.frames;
    }

    public int getFrameDelay(int n) {
        if (this.frameDelay != null) {
            return this.frameDelay[n];
        }
        return 0;
    }

    public int getFrameCount() {
        if (this.frame != null) {
            return 1;
        }
        if (this.frames != null) {
            return this.frames.length;
        }
        return 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getError() {
        return this.error;
    }

    public Exception getException() {
        return this.exception;
    }

    protected BufferedImage createCompatibleImage(int n, int n2, int n3) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (GraphicsEnvironment.isHeadless()) {
            if (n3 == 3) {
                return new BufferedImage(n, n2, 3);
            }
            return new BufferedImage(n, n2, 1);
        }
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(n, n2, n3);
    }

    protected BufferedImage asCompatibleImage(BufferedImage bufferedImage) {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        BufferedImage bufferedImage2 = bufferedImage;
        if (!GraphicsEnvironment.isHeadless() && !(graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration()).getColorModel(bufferedImage.getTransparency()).equals(bufferedImage.getColorModel())) {
            bufferedImage2 = this.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    protected Object asPlatformImage(BufferedImage bufferedImage) {
        return bufferedImage;
    }

    static BufferedImage convertColorSpace(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, srgbCS, null);
        colorConvertOp.filter(writableRaster, writableRaster);
        ComponentColorModel componentColorModel = new ComponentColorModel(srgbCS, colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency(), colorModel.getTransferType());
        return new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), null);
    }

    BufferedImage maybeScaleImage(BufferedImage bufferedImage, boolean bl) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (!(this.width == 0 && this.height == 0 || this.width == n && this.height == n2)) {
            if (this.preserveRatio) {
                if (this.width == 0) {
                    this.width = (int)((float)n * (float)this.height / (float)n2);
                } else if (this.height == 0) {
                    this.height = (int)((float)n2 * (float)this.width / (float)n);
                } else {
                    float f = Math.min((float)this.width / (float)n, (float)this.height / (float)n2);
                    this.width = (int)((float)n * f);
                    this.height = (int)((float)n2 * f);
                }
            } else {
                if (this.height == 0) {
                    this.height = n2;
                }
                if (this.width == 0) {
                    this.width = n;
                }
            }
            if (this.width == 0) {
                this.width = 1;
            }
            if (this.height == 0) {
                this.height = 1;
            }
            if (n != this.width || n2 != this.height) {
                return this.scale(bufferedImage, this.width, this.height);
            }
        }
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            try {
                bufferedImage2 = this.asCompatibleImage(bufferedImage);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                bufferedImage2 = bufferedImage;
            }
        }
        return bufferedImage2;
    }

    private BufferedImage scale(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImage;
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = bufferedImage2.getTransparency();
        if (this.smooth) {
            do {
                n3 = n3 > n ? Math.max(n3 / 2, n) : n;
                n4 = n4 > n2 ? Math.max(n4 / 2, n2) : n2;
                BufferedImage bufferedImage3 = this.createCompatibleImage(n3, n4, n5);
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(bufferedImage2, 0, 0, n3, n4, null);
                graphics2D.dispose();
                bufferedImage2 = bufferedImage3;
            } while (n3 != n || n4 != n2);
        } else {
            bufferedImage2 = this.createCompatibleImage(n, n2, n5);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    private void readImageFrames(ImageReader imageReader, int n) throws IOException {
        Object[] objectArray;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        BufferedImage[] bufferedImageArray = new BufferedImage[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            objectArray = imageReader.read(i);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(i);
            GIFImageMetadata gIFImageMetadata = (GIFImageMetadata)iIOMetadata;
            int n4 = gIFImageMetadata.imageHeight;
            int n5 = gIFImageMetadata.imageWidth;
            int n6 = gIFImageMetadata.imageLeftPosition;
            int n7 = gIFImageMetadata.imageTopPosition;
            bl = bl || gIFImageMetadata.transparentColorFlag;
            nArray4[i] = gIFImageMetadata.delayTime * 10;
            nArray3[i] = gIFImageMetadata.disposalMethod;
            nArray[i] = gIFImageMetadata.imageLeftPosition;
            nArray2[i] = gIFImageMetadata.imageTopPosition;
            n2 = Math.max(n2, n5 + n6);
            n3 = Math.max(n3, n4 + n7);
            bufferedImageArray[i] = objectArray;
        }
        BufferedImage bufferedImage = null;
        objectArray = new Object[n];
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage2 = bl ? this.createCompatibleImage(n2, n3, 3) : this.createCompatibleImage(n2, n3, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            if (bl) {
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, n2, n3);
            }
            if (i > 0 && (n8 == 1 || n8 == 3) && bufferedImage != null) {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage(bufferedImage, 0, 0, null, null);
            }
            if ((n8 = nArray3[i]) == 1) {
                bufferedImage = bufferedImage2;
            }
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawImage(bufferedImageArray[i], nArray[i], nArray2[i], null, null);
            graphics2D.dispose();
            BufferedImage bufferedImage3 = this.maybeScaleImage(bufferedImage2, false);
            if (i == 0) {
                this.width = bufferedImage3.getWidth();
                this.height = bufferedImage3.getHeight();
            }
            objectArray[i] = this.asPlatformImage(bufferedImage3);
        }
        this.frames = objectArray;
        this.frameDelay = nArray4;
    }

    ImageReader findImageReader(ImageInputStream imageInputStream) {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        while (imageReader == null && iterator != null && iterator.hasNext()) {
            imageReader = iterator.next();
        }
        if (imageReader != null) {
            imageReader.setInput(imageInputStream);
        } else if (imageInputStream != null) {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imageReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readImageFromStream(InputStream inputStream) throws IOException {
        ImageReader imageReader = null;
        try {
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
            if (memoryCacheImageInputStream == null) {
                this.error = true;
                return;
            }
            imageReader = this.findImageReader(memoryCacheImageInputStream);
            if (imageReader == null) {
                this.error = true;
                return;
            }
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            String string = imageReader.getFormatName();
            int n = imageReader.getMinIndex();
            int n2 = 1;
            boolean bl = false;
            if ("gif".equalsIgnoreCase(string)) {
                n2 = imageReader.getNumImages(true);
            } else if ("jpeg".equalsIgnoreCase(string)) {
                Iterator<ImageTypeSpecifier> iterator = imageReader.getImageTypes(n);
                boolean bl2 = true;
                while (iterator.hasNext()) {
                    ImageTypeSpecifier imageTypeSpecifier = iterator.next();
                    ColorModel colorModel = imageTypeSpecifier.getColorModel();
                    ColorSpace colorSpace = colorModel.getColorSpace();
                    if (!colorSpace.isCS_sRGB() && colorSpace.getType() == 5 && colorModel instanceof ComponentColorModel) {
                        if (JUtil.isJava6()) {
                            imageReadParam.setDestinationType(imageTypeSpecifier);
                            bl = true;
                            break;
                        }
                        if (!bl2) break;
                        bl = true;
                        break;
                    }
                    bl2 = false;
                }
            }
            if (n2 == 1) {
                Object object = imageReader.read(n, imageReadParam);
                if (bl) {
                    object = AWTImageLoader.convertColorSpace((BufferedImage)object);
                }
                if ((object = this.maybeScaleImage((BufferedImage)object, true)) != null) {
                    this.width = ((BufferedImage)object).getWidth();
                    this.height = ((BufferedImage)object).getHeight();
                }
                this.frame = this.asPlatformImage((BufferedImage)object);
            } else {
                this.readImageFrames(imageReader, n2);
            }
        }
        catch (IOException iOException) {
            this.error = true;
            this.exception = iOException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.error = true;
        }
        finally {
            ImageInputStream imageInputStream;
            if (imageReader != null && (imageInputStream = (ImageInputStream)imageReader.getInput()) != null) {
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {}
                imageReader.removeAllIIOReadProgressListeners();
                imageReader.dispose();
            }
        }
    }

    void readImage() {
        try {
            InputStream inputStream = new URL(this.url).openStream();
            this.readImageFromStream(inputStream);
        }
        catch (SecurityException securityException) {
            if (Platform.checkConnectAcrossDomain(this.url)) {
                try {
                    InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new URL(AWTImageLoader.this.url).openStream();
                        }
                    });
                    this.readImageFromStream(inputStream);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    this.error = true;
                    if (throwable.getClass() == RuntimeException.class) {
                        throw (RuntimeException)throwable;
                    }
                    this.exception = (Exception)throwable;
                }
                catch (IOException iOException) {
                    this.error = true;
                    this.exception = iOException;
                }
            }
            throw securityException;
        }
        catch (IOException iOException) {
            this.error = true;
            this.exception = iOException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AsyncImageLoader
    extends AbstractRemoteResource<AWTImageLoader> {
        int width;
        int height;
        boolean preserveRatio;
        boolean smooth;

        public AsyncImageLoader(AsyncOperationListener<AWTImageLoader> asyncOperationListener, String string, int n, int n2, boolean bl, boolean bl2) {
            super(string, asyncOperationListener);
            this.width = n;
            this.height = n2;
            this.preserveRatio = bl;
            this.smooth = bl2;
        }

        @Override
        protected AWTImageLoader processStream(InputStream inputStream) throws IOException {
            return new AWTImageLoader(inputStream, this.width, this.height, this.preserveRatio, this.smooth);
        }
    }
}

