/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.desktop;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PerformanceTrackerHelper {
    public static final boolean isPerfLoggingEnabled;
    static final boolean isPerfLoggerAvailable;
    static final Method logEventMethod;
    static final Method outputLogMethod;
    static final boolean useNano;
    static long lastTime;
    static long firstTime;

    public static void logEvent(final String string) {
        final long l = System.currentTimeMillis();
        if (firstTime == 0L) {
            firstTime = l;
        }
        if (isPerfLoggingEnabled && isPerfLoggerAvailable) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        logEventMethod.invoke(null, "JavaFX> " + string + " (" + (l - firstTime) + "ms total, " + (l - lastTime) + "ms)");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        lastTime = l;
    }

    public static void outputLog() {
        if (isPerfLoggingEnabled && isPerfLoggerAvailable) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        outputLogMethod.invoke(null, (Object[])null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    public static long nanoTime() {
        if (useNano) {
            return System.nanoTime();
        }
        return System.currentTimeMillis() * 1000000L;
    }

    static {
        final boolean[] blArray = new boolean[]{false, false};
        final Method[] methodArray = new Method[]{null, null};
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (System.getProperty("sun.perflog") != null) {
                        blArray[1] = true;
                        Class<?> clazz = Class.forName("sun.misc.PerformanceLogger", true, null);
                        blArray[0] = true;
                        methodArray[0] = clazz.getMethod("setTime", String.class);
                        methodArray[1] = clazz.getMethod("outputLog", null);
                        if (System.getProperty("sun.perflog.fx.exitflush") != null) {
                            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                                public void run() {
                                    PerformanceTrackerHelper.outputLog();
                                }
                            }));
                        }
                    }
                }
                catch (Throwable throwable) {
                    methodArray[0] = null;
                    blArray[0] = false;
                }
                return null;
            }
        });
        isPerfLoggerAvailable = blArray[0];
        isPerfLoggingEnabled = blArray[1];
        logEventMethod = methodArray[0];
        outputLogMethod = methodArray[1];
        boolean bl = false;
        try {
            System.nanoTime();
            bl = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        useNano = bl;
    }
}

