/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd;

import com.sun.javafx.tools.fxd.CancelledException;
import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.ContainerEntry;
import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.loader.misc.FXDLogger;
import javafx.async.RunnableFuture;

public final class ParseOnBackgroundTaskImpl
implements RunnableFuture {
    private final ContainerEntry m_entry;
    private final DocumentParser m_parser;
    private FXDRootElement m_root = null;
    private FXDContainer m_container = null;
    private String m_entryName = null;

    public ParseOnBackgroundTaskImpl(ContainerEntry containerEntry, DocumentParser documentParser) {
        this.m_entry = containerEntry;
        this.m_parser = documentParser;
    }

    public void run() throws Exception {
        try {
            this.m_container = this.m_entry.getContainer();
            this.m_entryName = this.m_entry.getEntryName();
            this.m_root = this.m_container.getRoot(this.m_entryName, this.m_parser);
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (Exception exception) {
            FXDLogger.error("Background parsing task failed", exception);
            throw exception;
        }
    }

    public FXDContainer getContainer() {
        return this.m_container;
    }

    public String getEntryName() {
        return this.m_entryName;
    }

    public FXDRootElement getRootElement() {
        return this.m_root;
    }
}

