/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.scene.fxd;

import com.sun.javafx.tools.fxd.FXDReference;
import com.sun.javafx.tools.fxd.container.scene.fxd.ContentHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDParser;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;
import com.sun.javafx.tools.fxd.container.scene.fxd.lexer.ContentLexer;
import java.io.IOException;

abstract class ContentListener {
    private ContentListener() {
    }

    public static ContentListener create(ContentHandler contentHandler) {
        return new ContentHandlerImpl(contentHandler);
    }

    public static ContentListener create(ContentLexer contentLexer) {
        return new ContentLexerImpl(contentLexer);
    }

    abstract boolean stopOnError();

    abstract void parsingStarted(FXDParser var1);

    abstract void endNode(Object var1, int var2) throws FXDException;

    abstract Object startNodeArray(int var1) throws FXDException;

    abstract void endNodeArray(Object var1, int var2) throws FXDException;

    abstract void arrayElement(Object var1, String var2, int var3, int var4) throws FXDException;

    abstract Object startNode(String var1, int var2, boolean var3) throws FXDException;

    abstract void attribute(Object var1, String var2, String var3, int var4, int var5, boolean var6) throws FXDException;

    abstract FXDReference createReference(String var1) throws FXDException;

    abstract void parsingFinished() throws IOException, FXDException;

    abstract void identifier(String var1, int var2) throws FXDException;

    abstract void separator(char var1, int var2) throws FXDException;

    abstract void operator(char var1, int var2) throws FXDException;

    abstract void attributeName(String var1, int var2, boolean var3) throws FXDException;

    abstract void comment(int var1, int var2);

    abstract void lineComment(int var1, int var2);

    abstract void error(int var1, int var2, FXDSyntaxErrorException var3);

    abstract void attributeValue(String var1, int var2, int var3) throws FXDException;

    private static class ContentHandlerImpl
    extends ContentListener {
        protected final ContentHandler m_handler;

        public ContentHandlerImpl(ContentHandler contentHandler) {
            assert (contentHandler != null);
            this.m_handler = contentHandler;
        }

        boolean stopOnError() {
            return this.m_handler.stopOnError();
        }

        void parsingStarted(FXDParser fXDParser) {
            this.m_handler.parsingStarted(fXDParser);
        }

        void endNode(Object object, int n) throws FXDException {
            this.m_handler.endNode(object, n);
        }

        Object startNodeArray(int n) throws FXDException {
            return this.m_handler.startNodeArray(n);
        }

        void endNodeArray(Object object, int n) throws FXDException {
            this.m_handler.endNodeArray(object, n);
        }

        void arrayElement(Object object, String string, int n, int n2) throws FXDException {
            this.m_handler.arrayElement(object, string, n, n2);
        }

        Object startNode(String string, int n, boolean bl) throws FXDException {
            return this.m_handler.startNode(string, n, bl);
        }

        void attribute(Object object, String string, String string2, int n, int n2, boolean bl) throws FXDException {
            this.m_handler.attribute(object, string, string2, n, n2, bl);
        }

        FXDReference createReference(String string) throws FXDException {
            return this.m_handler.createReference(string);
        }

        void parsingFinished() throws IOException, FXDException {
        }

        void identifier(String string, int n) throws FXDException {
        }

        void separator(char c, int n) throws FXDException {
        }

        void operator(char c, int n) throws FXDException {
        }

        void attributeName(String string, int n, boolean bl) throws FXDException {
        }

        void attributeValue(String string, int n, int n2) throws FXDException {
        }

        void comment(int n, int n2) {
        }

        void lineComment(int n, int n2) {
        }

        void error(int n, int n2, FXDSyntaxErrorException fXDSyntaxErrorException) {
        }
    }

    private static class ContentLexerImpl
    extends ContentListener {
        protected final ContentLexer m_lexer;

        protected ContentLexerImpl(ContentLexer contentLexer) {
            assert (contentLexer != null);
            this.m_lexer = contentLexer;
        }

        boolean stopOnError() {
            return this.m_lexer.stopOnError();
        }

        void parsingStarted(FXDParser fXDParser) {
            this.m_lexer.parsingStarted(fXDParser);
        }

        void endNode(Object object, int n) throws FXDException {
            this.separator('}', n - 1);
        }

        Object startNodeArray(int n) throws FXDException {
            this.separator('[', n - 1);
            return null;
        }

        void endNodeArray(Object object, int n) throws FXDException {
            this.separator(']', n);
        }

        void parsingFinished() throws IOException, FXDException {
            this.m_lexer.parsingFinished();
        }

        void identifier(String string, int n) throws FXDException {
            this.m_lexer.identifier(string, n);
        }

        void separator(char c, int n) throws FXDException {
            this.m_lexer.separator(c, n);
        }

        void operator(char c, int n) throws FXDException {
            this.m_lexer.operator(c, n);
        }

        void attributeName(String string, int n, boolean bl) throws FXDException {
            if (string != null) {
                this.m_lexer.attributeName(string, n - string.length(), bl);
            }
        }

        void attributeValue(String string, int n, int n2) throws FXDException {
            if (string != null) {
                this.m_lexer.attributeValue(string, n, n2 - string.length());
            }
        }

        void comment(int n, int n2) {
            this.m_lexer.comment(n, n2);
        }

        void lineComment(int n, int n2) {
            this.m_lexer.lineComment(n, n2);
        }

        void arrayElement(Object object, String string, int n, int n2) throws FXDException {
        }

        Object startNode(String string, int n, boolean bl) throws FXDException {
            return null;
        }

        void attribute(Object object, String string, String string2, int n, int n2, boolean bl) throws FXDException {
        }

        FXDReference createReference(String string) throws FXDException {
            return FXDReference.parse(string, null);
        }

        void error(int n, int n2, FXDSyntaxErrorException fXDSyntaxErrorException) {
            this.m_lexer.error(n, n2, fXDSyntaxErrorException);
        }
    }
}

