/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import com.sun.javafx.util.CrossDomainXML;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public class Platform {
    private static String osName = System.getProperty("os.name");
    private static boolean hasCDXML = false;
    private static boolean isCDXMLSet = false;

    public static final boolean isMac() {
        return "Mac OS X".equals(osName);
    }

    public static boolean checkConnectAcrossDomain(URL uRL) {
        if (Platform.hasCrossDomainXML()) {
            return false;
        }
        try {
            final Class<SecurityManager> clazz = SecurityManager.class;
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Method method = clazz.getDeclaredMethod("getClassContext", new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
            });
            Class[] classArray = (Class[])method.invoke((Object)System.getSecurityManager(), new Object[0]);
            if (classArray != null && CrossDomainXML.check(classArray, uRL, uRL.getHost(), uRL.getPort(), -1)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean checkConnectAcrossDomain(String string) {
        try {
            return Platform.checkConnectAcrossDomain(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private static final boolean hasCrossDomainXML() {
        if (!isCDXMLSet) {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName("com.sun.deploy.net.CrossDomainXML", false, null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            });
            hasCDXML = clazz != null;
            isCDXMLSet = true;
        }
        return hasCDXML;
    }
}

