/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmc;

import com.sun.media.jmc.MediaCorruptedException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.ProtocolType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PeerManager;
import com.sun.media.jmcimpl.PlayerPeer;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Media {
    public static final double TIME_UNKNOWN = Double.NEGATIVE_INFINITY;
    URI uri;
    private MediaPeer peer;
    private ProtocolType protocolType;
    private VideoDataBuffer.Format[] formats;
    private static VideoDataBuffer.Format[] guessedPreferredFormats;

    public Media(URI uRI) throws MediaUnavailableException, MediaUnsupportedException, MediaCorruptedException {
        this(uRI, null);
    }

    public Media(URI uRI, String[] stringArray) throws MediaUnavailableException, MediaUnsupportedException, MediaCorruptedException {
        this.uri = uRI;
        this.protocolType = null;
        this.formats = Media.convertStringsToFormats(stringArray);
        if (this.getClass() == Media.class) {
            this.peer = PeerManager.getMediaPeer(uRI, this.formats);
        }
    }

    private static VideoDataBuffer.Format[] convertStringsToFormats(String[] stringArray) {
        if (stringArray == null) {
            return Media.guessFormats();
        }
        ArrayList<VideoDataBuffer.Format> arrayList = new ArrayList<VideoDataBuffer.Format>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(VideoDataBuffer.Format.valueOf(stringArray[i]));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new VideoDataBuffer.Format[0]);
    }

    private static synchronized VideoDataBuffer.Format[] guessFormats() {
        if (guessedPreferredFormats == null && (guessedPreferredFormats = AccessController.doPrivileged(new PrivilegedAction<VideoDataBuffer.Format[]>(){

            @Override
            public VideoDataBuffer.Format[] run() {
                try {
                    Class<?> clazz = Class.forName("com.sun.javafx.sg.prism.PrismMediaFrameHandler");
                    Method method = clazz.getMethod("getPreferredMediaFormats", new Class[0]);
                    return (VideoDataBuffer.Format[])method.invoke(clazz, new Object[0]);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        })) == null) {
            guessedPreferredFormats = new VideoDataBuffer.Format[]{VideoDataBuffer.Format.XRGB};
        }
        return guessedPreferredFormats;
    }

    public VideoDataBuffer.Format[] getRequestedFormats() {
        return this.formats;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.peer != null ? this.peer.getMediaTracks() : null;
    }

    public double getDuration() {
        if (this.peer != null) {
            return this.peer.getDuration();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public ContainerType getContainerType() {
        if (this.peer != null) {
            return this.peer.getContainerType();
        }
        return null;
    }

    public ProtocolType getProtocolType() {
        if (this.protocolType == null && this.uri != null) {
            this.protocolType = ProtocolType.getTypeForScheme(this.uri.getScheme());
        }
        return this.protocolType;
    }

    public URI getURI() {
        return this.uri;
    }

    public <T> T getMetadata(String string, Class<T> clazz) {
        Object object;
        Map<String, Object> map = this.getMetadata();
        if (map != null && clazz.isInstance(object = map.get(string))) {
            return (T)object;
        }
        return null;
    }

    public Map<String, Object> getMetadata() {
        return this.peer != null ? this.peer.getMetadata() : null;
    }

    public int getFrameWidth() {
        return this.peer == null ? 0 : this.peer.getFrameWidth();
    }

    public int getFrameHeight() {
        return this.peer == null ? 0 : this.peer.getFrameHeight();
    }

    PlayerPeer getPlayerPeer() {
        PlayerPeer playerPeer = null;
        if (this.peer != null) {
            playerPeer = this.peer.getPlayerPeer();
        }
        return playerPeer;
    }
}

