/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import java.io.PrintStream;
import java.util.Formatter;

public class MediaLog {
    LogEntry[] logEntries;
    int readPosition = 0;
    int writePosition = 0;
    int numEntries = 0;
    long nanoOffset = 0L;
    boolean logging = false;
    int requestedSize = 5000;
    private static MediaLog sysLog = null;

    public MediaLog() {
        this(5000);
    }

    public MediaLog(int n) {
        this.requestedSize = n;
    }

    public static synchronized MediaLog getSysLog() {
        if (sysLog == null) {
            sysLog = new MediaLog(32000);
        }
        return sysLog;
    }

    public synchronized void reset() {
        this.numEntries = 0;
        this.readPosition = 0;
        this.writePosition = 0;
    }

    public synchronized void start() {
        if (this.logEntries == null) {
            this.logEntries = new LogEntry[this.requestedSize];
            for (int i = 0; i < this.requestedSize; ++i) {
                this.logEntries[i] = new LogEntry();
            }
        }
        this.logging = true;
        this.logEvent(0L, "Log Started");
    }

    public synchronized void pause() {
        this.logEvent(0L, "Log Paused");
        this.logging = false;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void logEvent(double d, String string) {
        this.logEvent((long)(d * 1.0E9), string);
    }

    public synchronized void logEvent(long l, String string) {
        if (!this.logging || this.logEntries == null || this.logEntries.length == 0) {
            return;
        }
        if (this.numEntries < this.logEntries.length) {
            ++this.numEntries;
        } else {
            this.readPosition = this.readPosition++ % this.logEntries.length;
        }
        this.logEntries[this.writePosition].currentTime = System.nanoTime() + this.nanoOffset;
        this.logEntries[this.writePosition].mediaTime = l;
        this.logEntries[this.writePosition].what = string;
        this.writePosition = (this.writePosition + 1) % this.logEntries.length;
    }

    public synchronized void sychronizeToMediaTime(double d) {
        this.synchronizeToMediaTime((long)(d * 1.0E9));
    }

    public synchronized void synchronizeToMediaTime(long l) {
        this.logEvent(l, "Setting Wall Time");
        this.nanoOffset = l - System.nanoTime();
        this.logEvent(l, "Set Wall Time");
    }

    public void printLog() {
        this.printLog(System.out);
    }

    String toString(long l) {
        int n = (int)(l / 60000000000L);
        int n2 = (int)(l / 1000000000L) % 60;
        int n3 = (int)(l / 1000L % 1000000L);
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        formatter.format("%02d:%02d,%06d", n, n2, n3);
        return stringBuilder.toString();
    }

    public void printLog(PrintStream printStream) {
        int n = this.numEntries;
        int n2 = this.readPosition;
        if (this.logEntries == null) {
            printStream.println("Log not started");
        } else {
            printStream.println("Wall Time | Media Time | Event " + this.numEntries);
            for (int i = 0; i < n; ++i) {
                printStream.println(this.toString(this.logEntries[n2].currentTime) + "  " + this.toString(this.logEntries[n2].mediaTime) + "   " + this.logEntries[n2].what);
                n2 = (n2 + 1) % this.logEntries.length;
            }
        }
    }

    class LogEntry {
        long currentTime;
        long mediaTime;
        String what;

        LogEntry() {
        }
    }
}

