/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet loaded = new HashSet();
    private static boolean usingJNLPAppletLauncher;
    private static Method jnlpLoadLibraryMethod;

    public static synchronized void loadLibrary(String string) {
        if (!loaded.contains(string)) {
            NativeLibLoader.loadLibraryInternal(string);
            loaded.add(string);
        }
    }

    private static void loadLibraryInternal(String string) {
        if (usingJNLPAppletLauncher && !string.equals("jawt")) {
            try {
                if (jnlpLoadLibraryMethod == null) {
                    Class<?> clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    jnlpLoadLibraryMethod = clazz.getDeclaredMethod("loadLibrary", String.class);
                }
                jnlpLoadLibraryMethod.invoke(null, string);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(exception);
            }
        } else {
            System.loadLibrary(string);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.jnlp.applet.launcher");
                usingJNLPAppletLauncher = Boolean.valueOf(string);
                return null;
            }
        });
    }
}

