/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.corevideo;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.OperationUnsupportedException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.event.SizeChangedEvent;
import com.sun.media.jmcimpl.AbstractPlayerPeer;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.corevideo.CoreVideoBuffer;
import com.sun.media.jmcimpl.plugins.corevideo.CoreVideoMedia;
import java.net.URI;
import java.nio.Buffer;
import java.util.IdentityHashMap;
import java.util.Iterator;

class CoreVideoPlayer
extends AbstractPlayerPeer
implements PlayerPeer {
    private float fader = 0.0f;
    private CoreVideoMedia mediaPeer = null;
    private boolean deferRateChange = true;
    private VideoDataBuffer.Format[] supportedPixelFormats;
    private final IdentityHashMap videoBufferList = new IdentityHashMap(64);
    private final IdentityHashMap staleBufferList = new IdentityHashMap(8);
    private CoreVideoBuffer nextVideoFrame = null;
    private int lastWidth = 0;
    private int lastHeight = 0;
    float g_fader = 0.0f;
    double g_lastRateSet = 1.0;

    public CoreVideoPlayer(VideoDataBuffer.Format[] formatArray) throws MediaException {
        this.earlyTaskLoop = true;
        this.deferRateChange = true;
        this.mediaPeer = null;
        if (null == formatArray) {
            formatArray = new VideoDataBuffer.Format[]{VideoDataBuffer.Format.XRGB};
        }
        this.supportedPixelFormats = formatArray;
    }

    public CoreVideoPlayer(CoreVideoMedia coreVideoMedia, VideoDataBuffer.Format[] formatArray) throws MediaException {
        this(formatArray);
        this.setMedia(coreVideoMedia);
    }

    public synchronized MediaPeer getMediaPeer() {
        return this.mediaPeer;
    }

    public VideoDataBuffer.Format[] getPixelFormats() {
        return this.supportedPixelFormats;
    }

    public void finalize() {
        this.dispose();
    }

    protected synchronized double plugin_getMediaTime() {
        if (null != this.mediaPeer) {
            return this.mediaPeer.getMediaTime();
        }
        return Double.NEGATIVE_INFINITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean plugin_newFrame() {
        if (null != this.mediaPeer) {
            IdentityHashMap identityHashMap = this.videoBufferList;
            synchronized (identityHashMap) {
                if (null == this.nextVideoFrame) {
                    this.nextVideoFrame = this.mediaPeer.getNextFrame();
                    if (null != this.nextVideoFrame && (this.lastWidth != this.nextVideoFrame.getWidth() || this.lastHeight != this.nextVideoFrame.getHeight())) {
                        this.lastWidth = this.nextVideoFrame.getWidth();
                        this.lastHeight = this.nextVideoFrame.getHeight();
                        this.sendEvent(new SizeChangedEvent(this.mediaPeer.getMediaTime(), "Size Changed", this, this.lastWidth, this.lastHeight));
                    }
                }
            }
            return null != this.nextVideoFrame;
        }
        throw new OperationUnsupportedException("bad movie : " + this.uri);
    }

    protected synchronized void plugin_pause() {
        if (null != this.mediaPeer) {
            this.deferRateChange = true;
            this.mediaPeer.stop();
            this.ClearVideoBufferList();
        }
    }

    protected synchronized void plugin_start() {
        if (null != this.mediaPeer) {
            this.deferRateChange = false;
            this.native_SetRate(this.g_lastRateSet);
            this.mediaPeer.play();
            this.ClearVideoBufferList();
        }
    }

    protected synchronized void plugin_stop() {
        if (null != this.mediaPeer) {
            this.deferRateChange = true;
            this.mediaPeer.stop();
            this.ClearVideoBufferList();
        }
    }

    protected synchronized void plugin_provideCleanContext() {
        this.ReleaseResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReleaseResources() {
        if (null != this.mediaPeer) {
            AbstractPlayerPeer.ImagePumpState imagePumpState = this.currentImagePump;
            synchronized (imagePumpState) {
                this.mediaPeer.stop();
                this.mediaPeer.close();
                this.mediaPeer = null;
                this.ClearVideoBufferList();
            }
        }
    }

    private void native_SetRate(double d) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setRate(d);
        }
    }

    protected synchronized void plugin_prerollMovie() {
        if (null != this.mediaPeer) {
            this.processPluginEvent(101);
        }
    }

    protected synchronized void plugin_setBalance(float f) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setBalance(f);
        }
    }

    protected synchronized void plugin_setFader(float f) {
        this.g_fader = f;
    }

    protected synchronized void plugin_setRate(double d) {
        this.g_lastRateSet = d;
        if (!this.deferRateChange) {
            this.native_SetRate(d);
        }
    }

    private synchronized void setMedia(CoreVideoMedia coreVideoMedia) {
        if (coreVideoMedia == this.mediaPeer) {
            return;
        }
        if (null != this.mediaPeer) {
            this.ReleaseResources();
        }
        this.mediaPeer = coreVideoMedia;
        if (null != this.mediaPeer) {
            this.processPluginEvent(100);
        }
    }

    protected synchronized void plugin_setSource(URI uRI) {
        if (null == uRI) {
            this.ReleaseResources();
            return;
        }
        this.setMedia(new CoreVideoMedia(uRI, this));
    }

    protected synchronized void plugin_setMediaTime(double d) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setMediaTime(d);
        }
    }

    protected synchronized void plugin_setStopTime(double d) {
    }

    protected synchronized void plugin_setStartTime(double d) {
    }

    protected boolean plugin_endOfMedia() {
        return false;
    }

    protected synchronized void plugin_getMovieProperties() {
        if (null != this.mediaPeer) {
            this.mediaPeer.updateMovieProperties();
            this.syncMovieProperties();
        }
    }

    private double getProgressTime() {
        double d = Double.NEGATIVE_INFINITY;
        if (null != this.mediaPeer) {
            d = this.mediaPeer.getAvailableDuration();
        }
        return d;
    }

    protected final void syncMovieProperties() {
        AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties = new AbstractPlayerPeer.NativePlayerPeerProperties(this);
        nativePlayerPeerProperties.imageWidth = this.mediaPeer.getMovieWidth();
        nativePlayerPeerProperties.imageHeight = this.mediaPeer.getMovieHeight();
        nativePlayerPeerProperties.duration = this.mediaPeer.getDuration();
        nativePlayerPeerProperties.rate = this.mediaPeer.getRate();
        nativePlayerPeerProperties.bufferProgressTime = this.getProgressTime();
        nativePlayerPeerProperties.mediaTime = this.mediaPeer.getMediaTime();
        nativePlayerPeerProperties.volume = this.mediaPeer.getVolume();
        nativePlayerPeerProperties.balance = this.mediaPeer.getBalance();
        nativePlayerPeerProperties.fader = this.fader;
        this.syncMovieProperties(nativePlayerPeerProperties);
    }

    protected synchronized void plugin_setVolume(float f) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setVolume(f);
        }
    }

    protected void plugin_transferFrame(int[] nArray, int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void plugin_transferFrame(VideoDataBuffer videoDataBuffer) {
        CoreVideoBuffer coreVideoBuffer = null;
        IdentityHashMap identityHashMap = this.videoBufferList;
        synchronized (identityHashMap) {
            coreVideoBuffer = this.nextVideoFrame;
            this.nextVideoFrame = null;
            videoDataBuffer.setBuffer(null);
            if (null != coreVideoBuffer) {
                Buffer buffer = coreVideoBuffer.getBuffer();
                buffer.rewind();
                if (!this.videoBufferList.containsKey(buffer)) {
                    this.videoBufferList.put(buffer, coreVideoBuffer);
                }
                videoDataBuffer.setBuffer(buffer);
                videoDataBuffer.setWidth(coreVideoBuffer.getWidth());
                videoDataBuffer.setHeight(coreVideoBuffer.getHeight());
                videoDataBuffer.setLineStride(coreVideoBuffer.getLineStride());
                videoDataBuffer.setFormat(coreVideoBuffer.getFormat());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFrameData(VideoDataBuffer videoDataBuffer) {
        Buffer buffer = videoDataBuffer.getBuffer();
        videoDataBuffer.setBuffer(null);
        if (null != buffer) {
            CoreVideoBuffer coreVideoBuffer = null;
            IdentityHashMap identityHashMap = this.videoBufferList;
            synchronized (identityHashMap) {
                if (this.videoBufferList.containsKey(buffer) && null != (coreVideoBuffer = (CoreVideoBuffer)this.videoBufferList.get(buffer))) {
                    coreVideoBuffer.unlock();
                }
            }
            if (null == coreVideoBuffer) {
                identityHashMap = this.staleBufferList;
                synchronized (identityHashMap) {
                    if (this.staleBufferList.containsKey(buffer) && null != (coreVideoBuffer = (CoreVideoBuffer)this.staleBufferList.get(buffer))) {
                        coreVideoBuffer.unlock();
                        coreVideoBuffer.dispose();
                        this.staleBufferList.remove(buffer);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ClearVideoBufferList() {
        CoreVideoBuffer coreVideoBuffer;
        Iterator iterator;
        IdentityHashMap identityHashMap = this.videoBufferList;
        synchronized (identityHashMap) {
            iterator = this.videoBufferList.values().iterator();
            while (iterator.hasNext()) {
                coreVideoBuffer = (CoreVideoBuffer)iterator.next();
                if (null != coreVideoBuffer) {
                    if (!coreVideoBuffer.isLocked()) {
                        coreVideoBuffer.dispose();
                    } else {
                        this.staleBufferList.put(coreVideoBuffer.getBuffer(), coreVideoBuffer);
                    }
                }
                iterator.remove();
            }
            this.videoBufferList.clear();
            if (null != this.nextVideoFrame) {
                this.nextVideoFrame.unlock();
                this.nextVideoFrame.dispose();
                this.nextVideoFrame = null;
            }
        }
        identityHashMap = this.staleBufferList;
        synchronized (identityHashMap) {
            iterator = this.staleBufferList.values().iterator();
            while (iterator.hasNext()) {
                coreVideoBuffer = (CoreVideoBuffer)iterator.next();
                if (null == coreVideoBuffer || coreVideoBuffer.isLocked()) continue;
                coreVideoBuffer.dispose();
                iterator.remove();
            }
        }
    }
}

