/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.NativeLibLoader;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.directshow.DShowEngine;
import com.sun.media.jmcimpl.plugins.directshow.DShowMedia;
import com.sun.media.jmcimpl.plugins.directshow.DShowPlayer;
import com.sun.media.jmcimpl.spi.DefaultPlayerPeerProvider;
import com.sun.media.jmcimpl.spi.MediaPeerProvider;
import com.sun.media.jmcimpl.spi.PlayerPeerProvider;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DShowProvider
extends DefaultPlayerPeerProvider
implements MediaPeerProvider {
    static ContainerType ContainerAVI = new ContainerType(ContainerType.Container.AVI, "Audio-Video Interleaved", new String[]{"avi"}, new String[]{"video/avi", "video/msvideo", "video/x-msvideo"});
    static ContainerType ContainerASF = new ContainerType(ContainerType.Container.ASF, "Advanced Systems Format (ASF/WMA/WMV)", new String[]{"asf", "wma", "wmv"}, new String[]{"video/x-ms-asf", "audio/x-ms-wma", "video/x-ms-wmv"});
    static ContainerType ContainerMP4 = new ContainerType(ContainerType.Container.MP4, "MPEG-4", new String[]{"mp4"}, new String[]{"video/mp4"});
    static ContainerType ContainerMPEG1 = new ContainerType(ContainerType.Container.MPEG1, "Motion Picture Experts Group (MPEG)", new String[]{"mpg", "mpeg", "mp1", "mp2", "mp3", "m1v", "m1a", "m2a", "mpa", "mpv"}, new String[]{"audio/mpeg", "video/mpeg"});
    static ContainerType ContainerMOV = new ContainerType(ContainerType.Container.MOV, "QuickTime 2.0", new String[]{"qt", "mov"}, new String[]{"video/quicktime"});
    static ContainerType ContainerWAVE = new ContainerType(ContainerType.Container.WAVE, "Waveform audio", new String[]{"wav"}, new String[]{"audio/wav", "audio/wave", "audio/x-wav"});
    static ContainerType ContainerAIFF = new ContainerType(ContainerType.Container.AIFF, "Audio Interchange File Format", new String[]{"aif", "aiff", "aifc"}, new String[]{"audio/aiff", "audio/x-aiff"});
    static ContainerType ContainerAU = new ContainerType(ContainerType.Container.AU, "Next/SUN audio", new String[]{"au", "snd"}, new String[]{"audio/basic", "audio/ulaw"});
    static ContainerType ContainerMIDI = new ContainerType(ContainerType.Container.MIDI, "Standard MIDI File (SMF)", new String[]{"mid", "midi", "smf", "kar"}, new String[]{"audio/midi", "audio/x-midi"});
    static ContainerType ContainerOGG = new ContainerType(ContainerType.Container.OGG, "Ogg", new String[]{"ogg", "oga", "ogv", "ogx"}, new String[]{"application/ogg", "audio/ogg", "video/ogg", "application/x-ogg", "audio/x-ogg", "video/x-ogg"});
    static ContainerType ContainerFLV = new ContainerType(ContainerType.Container.FLV, "Flash Video", new String[]{"flv"}, new String[]{"video/flv"});
    static ContainerType ContainerFXM = new ContainerType(ContainerType.Container.FXM, "Sun FX Media", new String[]{"fxm"}, new String[]{"video/fxm"});
    static ContainerType[] myMediaFileTypes = new ContainerType[]{ContainerAVI, ContainerASF, ContainerMPEG1, ContainerMOV, ContainerWAVE, ContainerAIFF, ContainerAU, ContainerMIDI, ContainerMP4, ContainerOGG, ContainerFLV, ContainerFXM};
    private static boolean libsOK = false;
    private final List playableURIs = Collections.synchronizedList(new ArrayList(2));
    private static final String libPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("java.library.path");
        }
    });
    private static final String userDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("user.dir");
        }
    });
    DShowEngine cachedEngine = null;
    URI cachedEngineURI = null;

    public DShowProvider() {
        super(myMediaFileTypes, PlayerPeerProvider.PlaybackMode.Lightweight);
    }

    private synchronized boolean init(final VideoDataBuffer.Format[] formatArray) {
        if (libsOK) {
            return true;
        }
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return false;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    NativeLibLoader.loadLibrary("msvcr71");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                try {
                    NativeLibLoader.loadLibrary("msvcp71");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                try {
                    NativeLibLoader.loadLibrary("jmc");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                try {
                    DShowEngine.nInit(formatArray == null ? VideoDataBuffer.Format.XRGB : formatArray[0]);
                    libsOK = true;
                }
                catch (Exception exception) {
                    throw new MediaUnsupportedException("Problem loading support DLL");
                }
                return null;
            }
        });
        return libsOK;
    }

    public static ContainerType[] getSupportedContainerTypes() {
        return myMediaFileTypes;
    }

    @Override
    public ContainerType[] getContainerTypes() {
        return myMediaFileTypes;
    }

    @Override
    public PlayerPeerProvider.PlaybackMode canPlay(URI uRI, VideoDataBuffer.Format[] formatArray) {
        if (!this.init(formatArray)) {
            return PlayerPeerProvider.PlaybackMode.None;
        }
        String string = uRI.toASCIIString();
        if (this.playableURIs.contains(string)) {
            return PlayerPeerProvider.PlaybackMode.Lightweight;
        }
        DShowEngine dShowEngine = DShowEngine.canPlay(uRI, true);
        if (null == dShowEngine) {
            return PlayerPeerProvider.PlaybackMode.None;
        }
        this.addToEngineCache(dShowEngine, uRI);
        this.playableURIs.add(string);
        return PlayerPeerProvider.PlaybackMode.Lightweight;
    }

    @Override
    public PlayerPeer createPlayerPeer(URI uRI, VideoDataBuffer.Format[] formatArray) throws MediaException {
        if (!this.init(formatArray)) {
            throw new MediaException("DirectShow peers are not initialized.");
        }
        PlayerPeer playerPeer = null;
        URI uRI2 = this.cachedEngineURI;
        DShowEngine dShowEngine = this.useCachedEngine(uRI);
        try {
            playerPeer = null != dShowEngine ? new DShowPlayer(dShowEngine, uRI2) : new DShowPlayer(uRI);
        }
        catch (MediaException mediaException) {
            if (playerPeer != null) {
                playerPeer.dispose();
                playerPeer = null;
            }
            if (dShowEngine != null) {
                dShowEngine.ReleaseResources();
                dShowEngine = null;
            }
            throw mediaException;
        }
        return playerPeer;
    }

    @Override
    public Class<? extends PlayerPeer> getPlayerPeerClass() {
        return DShowPlayer.class;
    }

    @Override
    public boolean canDecode(URI uRI, VideoDataBuffer.Format[] formatArray) {
        return this.canPlay(uRI, formatArray) != PlayerPeerProvider.PlaybackMode.None;
    }

    @Override
    public MediaPeer createMediaPeer(URI uRI, VideoDataBuffer.Format[] formatArray) throws MediaException {
        if (!this.init(formatArray)) {
            throw new MediaException("DirectShow peers are not initialized.");
        }
        if (this.canPlay(uRI, formatArray) == PlayerPeerProvider.PlaybackMode.None) {
            throw new MediaException("DirectShow does not support this movie format.");
        }
        DShowMedia dShowMedia = null;
        URI uRI2 = this.cachedEngineURI;
        DShowEngine dShowEngine = this.useCachedEngine(uRI);
        dShowMedia = null != dShowEngine ? new DShowMedia(dShowEngine, uRI2) : new DShowMedia(uRI);
        return dShowMedia;
    }

    void addToEngineCache(DShowEngine dShowEngine, URI uRI) {
        if (null != this.cachedEngine) {
            this.cachedEngine.ReleaseResources();
        }
        this.cachedEngine = dShowEngine;
        this.cachedEngineURI = uRI.normalize();
    }

    DShowEngine useCachedEngine(URI uRI) {
        DShowEngine dShowEngine = null;
        uRI.normalize();
        if (uRI.equals(this.cachedEngineURI)) {
            dShowEngine = this.cachedEngine;
            this.cachedEngine = null;
            this.cachedEngineURI = null;
        }
        return dShowEngine;
    }
}

