/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmcimpl.AbstractPlayerPeer;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.Utils;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTMediaInfo;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTMediaPeer;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTUtils;
import java.net.URI;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.EnumSet;

class GSTPlayerPeer
extends AbstractPlayerPeer {
    private long peerInfo;
    private GSTMediaPeer mediaPeer;
    private double rate = 1.0;
    private boolean stateEOS = false;
    private FrameHolder frameHolder = new FrameHolder();
    private EventHandler eventHandler = new EventHandler();

    GSTPlayerPeer() {
    }

    private native long nativeSetURI(String var1, Object var2, Object var3);

    private native void nativeDestroyPeer(long var1);

    private native int nativePlay(long var1);

    private native int nativePause(long var1);

    private native int nativeStop(long var1);

    private native void nativeSetMediaTime(long var1, long var3, double var5);

    private native void nativeSetRate(long var1, double var3);

    private native void nativeSetVolume(long var1, double var3);

    private native void nativeSetStopTime(long var1, long var3, double var5);

    private native void nativeSetStartTime(long var1, long var3, double var5);

    protected synchronized void plugin_setSource(URI uRI) {
        if (uRI != null) {
            this.peerInfo = this.nativeSetURI(GSTUtils.normalize(uRI).toString(), this.frameHolder, this.eventHandler);
            if (this.peerInfo == 0L) {
                throw new MediaException("Could not create GStreamer peer");
            }
            this.sendMediaEvent(100);
        }
    }

    protected synchronized void plugin_provideCleanContext() {
        if (this.peerInfo != 0L) {
            this.plugin_stop();
            this.nativeDestroyPeer(this.peerInfo);
            this.peerInfo = 0L;
            this.mediaPeer = null;
            this.rate = 1.0;
            this.stateEOS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void plugin_getMovieProperties() {
        AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties = new AbstractPlayerPeer.NativePlayerPeerProperties(this);
        MovieProperties movieProperties = MovieProperties.queryProperties(this.peerInfo);
        GSTPlayerPeer gSTPlayerPeer = this;
        synchronized (gSTPlayerPeer) {
            nativePlayerPeerProperties.imageWidth = this.mediaPeer != null ? this.mediaPeer.getFrameWidth() : 0;
            nativePlayerPeerProperties.imageHeight = this.mediaPeer != null ? this.mediaPeer.getFrameHeight() : 0;
            nativePlayerPeerProperties.duration = movieProperties.getDuration();
            nativePlayerPeerProperties.mediaTime = this.stateEOS ? nativePlayerPeerProperties.duration : movieProperties.getMediaTime();
            nativePlayerPeerProperties.volume = movieProperties.getVolume();
            nativePlayerPeerProperties.rate = this.rate;
        }
        this.syncMovieProperties(nativePlayerPeerProperties);
    }

    protected void setCaps(AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties) {
        nativePlayerPeerProperties.caps = EnumSet.noneOf(PlayerPeer.Capabilities.class);
        nativePlayerPeerProperties.caps.add(PlayerPeer.Capabilities.isLightweight);
        nativePlayerPeerProperties.caps.add(PlayerPeer.Capabilities.supportsRate);
        nativePlayerPeerProperties.caps.add(PlayerPeer.Capabilities.supportsVolume);
        if (nativePlayerPeerProperties.duration != Double.POSITIVE_INFINITY) {
            nativePlayerPeerProperties.caps.add(PlayerPeer.Capabilities.supportsSeeking);
        }
    }

    protected void plugin_prerollMovie() {
        StateChangeReturn stateChangeReturn;
        if (this.peerInfo != 0L && (stateChangeReturn = StateChangeReturn.forInt(this.nativePause(this.peerInfo))) == StateChangeReturn.NO_PREROLL) {
            this.sendMediaEvent(101);
        }
    }

    protected void plugin_start() {
        if (this.peerInfo != 0L) {
            this.nativePlay(this.peerInfo);
        }
    }

    protected void plugin_pause() {
        if (this.peerInfo != 0L) {
            this.nativePause(this.peerInfo);
        }
    }

    protected void plugin_stop() {
        if (this.peerInfo != 0L) {
            this.nativeStop(this.peerInfo);
        }
    }

    protected void plugin_setMediaTime(double d) {
        if (!this.isSeekable()) {
            throw new MediaException("Seeking is not available");
        }
        if (this.peerInfo != 0L) {
            d = Utils.reduceValue(d, 0.0, this.getDuration());
            this.nativeSetMediaTime(this.peerInfo, GSTUtils.toNanoseconds(d), this.getRate());
        }
        this.stateEOS = false;
    }

    protected void plugin_setStopTime(double d) {
        if (this.peerInfo != 0L) {
            d = Utils.reduceValue(d, 0.0, this.getDuration());
            this.nativeSetStopTime(this.peerInfo, GSTUtils.toNanoseconds(d), this.getRate());
        }
    }

    protected void plugin_setStartTime(double d) {
        if (this.peerInfo != 0L) {
            d = Utils.reduceValue(d, 0.0, this.getDuration());
            this.nativeSetStartTime(this.peerInfo, GSTUtils.toNanoseconds(d), this.getRate());
        }
    }

    protected void plugin_setRate(double d) {
        if (d != this.rate) {
            if (this.peerInfo != 0L && d != 0.0) {
                this.nativeSetRate(this.peerInfo, d);
                if (this.rate == 0.0) {
                    this.start();
                }
            } else {
                this.pause();
            }
            this.rate = d;
        }
    }

    protected synchronized void plugin_setVolume(float f) {
        if (this.peerInfo != 0L) {
            this.nativeSetVolume(this.peerInfo, f);
        }
    }

    protected boolean plugin_newFrame() {
        return this.frameHolder.hasNewFrame();
    }

    protected void plugin_transferFrame(int[] nArray, int n, int n2) {
        this.frameHolder.transferFrame(nArray, n, n2);
    }

    protected void plugin_transferFrame(VideoDataBuffer videoDataBuffer) {
        int n;
        if (this.mediaPeer == null) {
            videoDataBuffer.setBuffer(null);
            return;
        }
        int n2 = this.mediaPeer.getFrameWidth();
        int n3 = n2 * (n = this.mediaPeer.getFrameHeight());
        if (n3 == 0) {
            videoDataBuffer.setWidth(n2);
            videoDataBuffer.setHeight(n);
            videoDataBuffer.setBuffer(null);
            return;
        }
        Buffer buffer = videoDataBuffer.getBuffer();
        IntBuffer intBuffer = null;
        if (buffer instanceof IntBuffer && (intBuffer = (IntBuffer)buffer).capacity() != n3) {
            intBuffer = null;
        }
        buffer = null;
        if (intBuffer == null) {
            intBuffer = IntBuffer.allocate(n3);
            buffer = intBuffer;
        }
        videoDataBuffer.setBuffer(intBuffer);
        intBuffer.clear();
        videoDataBuffer.setWidth(n2);
        videoDataBuffer.setHeight(n);
        videoDataBuffer.setFormat(VideoDataBuffer.Format.XRGB);
        this.frameHolder.transferFrame(intBuffer.array(), n2, n);
    }

    public synchronized MediaPeer getMediaPeer() {
        return this.mediaPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isSeekable() {
        AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.duration != Double.POSITIVE_INFINITY;
        }
    }

    private void sendMediaEvent(int n) {
        this.getExecutor().execute(new AbstractPlayerPeer.Execute_mediaEvent(this, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double plugin_getMediaTime() {
        AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.mediaTime;
        }
    }

    protected boolean plugin_endOfMedia() {
        return false;
    }

    protected void plugin_setBalance(float f) {
    }

    protected void plugin_setFader(float f) {
    }

    private class EventHandler {
        private EventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle_eos(long l) {
            GSTPlayerPeer gSTPlayerPeer = GSTPlayerPeer.this;
            synchronized (gSTPlayerPeer) {
                GSTPlayerPeer.this.stateEOS = true;
            }
        }

        private void handle_buffering(int n) {
        }

        private void handle_preroll() {
            GSTPlayerPeer.this.sendMediaEvent(101);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle_media_info(GSTMediaInfo gSTMediaInfo) {
            GSTPlayerPeer gSTPlayerPeer = GSTPlayerPeer.this;
            synchronized (gSTPlayerPeer) {
                GSTPlayerPeer.this.mediaPeer = GSTMediaPeer.createMediaPeer(GSTPlayerPeer.this.uri, gSTMediaInfo);
            }
        }
    }

    private class FrameHolder {
        private boolean newFrameFlag = false;

        private FrameHolder() {
        }

        private native void nativeTransferFrame(long var1, int[] var3, int var4, int var5);

        private void preroll() {
            this.render();
        }

        private void render() {
            this.newFrameFlag = true;
        }

        public synchronized boolean hasNewFrame() {
            boolean bl = this.newFrameFlag;
            this.newFrameFlag = false;
            return bl;
        }

        public synchronized void transferFrame(int[] nArray, int n, int n2) {
            this.nativeTransferFrame(GSTPlayerPeer.this.peerInfo, nArray, n, n2);
        }
    }

    private static class MovieProperties {
        private long duration;
        private long mediaTime;
        private double volume;

        private static native MovieProperties nativeQueryProperties(long var0);

        private MovieProperties(long l, long l2, double d) {
            this.duration = l;
            this.mediaTime = l2;
            this.volume = d;
        }

        static MovieProperties queryProperties(long l) {
            return l != 0L ? MovieProperties.nativeQueryProperties(l) : null;
        }

        double getDuration() {
            return GSTUtils.toSeconds(this.duration);
        }

        double getMediaTime() {
            return GSTUtils.toSeconds(this.mediaTime);
        }

        float getVolume() {
            return (float)this.volume;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StateChangeReturn {
        FAILURE(0),
        SUCCESS(1),
        ASYNC(2),
        NO_PREROLL(3);

        private int value;

        private StateChangeReturn(int n2) {
            this.value = n2;
        }

        static StateChangeReturn forInt(int n) {
            for (StateChangeReturn stateChangeReturn : StateChangeReturn.values()) {
                if (stateChangeReturn.value != n) continue;
                return stateChangeReturn;
            }
            return FAILURE;
        }
    }
}

