/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;

public abstract class FilterEffect
extends Effect {
    protected FilterEffect() {
    }

    protected FilterEffect(Effect effect) {
        super(effect);
    }

    protected FilterEffect(Effect effect, Effect effect2) {
        super(effect, effect2);
    }

    public boolean operatesInUserSpace() {
        return false;
    }

    public Bounds2D getBounds(BaseTransform baseTransform, Effect effect) {
        Bounds2D bounds2D;
        int n = this.getNumInputs();
        BaseTransform baseTransform2 = baseTransform;
        if (this.operatesInUserSpace()) {
            baseTransform2 = BaseTransform.IDENTITY_TRANSFORM;
        }
        if (n == 1) {
            Effect effect2 = this.getDefaultedInput(0, effect);
            bounds2D = effect2.getBounds(baseTransform2, effect);
        } else {
            Bounds2D[] bounds2DArray = new Bounds2D[n];
            for (int i = 0; i < n; ++i) {
                Effect effect3 = this.getDefaultedInput(i, effect);
                bounds2DArray[i] = effect3.getBounds(baseTransform2, effect);
            }
            bounds2D = this.combineBounds(bounds2DArray);
        }
        if (baseTransform2 != baseTransform) {
            bounds2D = FilterEffect.transformBounds(baseTransform, bounds2D);
        }
        return bounds2D;
    }

    public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Effect effect) {
        int n = this.getNumInputs();
        ImageData[] imageDataArray = new ImageData[n];
        BaseTransform baseTransform2 = baseTransform;
        if (this.operatesInUserSpace()) {
            baseTransform2 = BaseTransform.IDENTITY_TRANSFORM;
        }
        for (int i = 0; i < n; ++i) {
            Effect effect2 = this.getDefaultedInput(i, effect);
            imageDataArray[i] = effect2.filter(filterContext, baseTransform2, effect);
            if (imageDataArray[i].validate(filterContext)) continue;
            for (int j = 0; j <= i; ++j) {
                imageDataArray[j].unref();
            }
            return new ImageData(filterContext, null, null);
        }
        ImageData imageData = this.filterImageDatas(filterContext, baseTransform, imageDataArray);
        for (int i = 0; i < n; ++i) {
            imageDataArray[i].unref();
        }
        if (baseTransform2 != baseTransform) {
            imageData = this.ensureTransform(filterContext, imageData, baseTransform);
        }
        return imageData;
    }

    public Point2D transform(Point2D point2D, Effect effect) {
        return this.getDefaultedInput(0, effect).transform(point2D, effect);
    }

    public Point2D untransform(Point2D point2D, Effect effect) {
        return this.getDefaultedInput(0, effect).untransform(point2D, effect);
    }

    protected abstract ImageData filterImageDatas(FilterContext var1, BaseTransform var2, ImageData ... var3);
}

