/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;

public class Reflection
extends CoreEffect {
    private float topOffset = 0.0f;
    private float topOpacity = 0.5f;
    private float bottomOpacity = 0.0f;
    private float fraction = 0.75f;

    public Reflection() {
        this(DefaultInput);
    }

    public Reflection(Effect effect) {
        super(effect);
        this.updatePeerKey("Reflection");
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect effect) {
        this.setInput(0, effect);
    }

    public float getTopOffset() {
        return this.topOffset;
    }

    public void setTopOffset(float f) {
        float f2 = this.topOffset;
        this.topOffset = f;
        this.firePropertyChange("topOffset", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getTopOpacity() {
        return this.topOpacity;
    }

    public void setTopOpacity(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Top opacity must be in the range [0,1]");
        }
        float f2 = this.topOpacity;
        this.topOpacity = f;
        this.firePropertyChange("topOpacity", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getBottomOpacity() {
        return this.bottomOpacity;
    }

    public void setBottomOpacity(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Bottom opacity must be in the range [0,1]");
        }
        float f2 = this.bottomOpacity;
        this.bottomOpacity = f;
        this.firePropertyChange("bottomOpacity", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getFraction() {
        return this.fraction;
    }

    public void setFraction(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Fraction must be in the range [0,1]");
        }
        float f2 = this.fraction;
        this.fraction = f;
        this.firePropertyChange("fraction", Float.valueOf(f2), Float.valueOf(f));
    }

    public Bounds2D getBounds(BaseTransform baseTransform, Effect effect) {
        Effect effect2 = this.getDefaultedInput(0, effect);
        Bounds2D bounds2D = effect2.getBounds(BaseTransform.IDENTITY_TRANSFORM, effect);
        bounds2D.roundOut();
        float f = bounds2D.x1;
        float f2 = bounds2D.y2 + this.topOffset;
        float f3 = bounds2D.x2;
        float f4 = f2 + this.fraction * bounds2D.getHeight();
        Bounds2D bounds2D2 = new Bounds2D(f, f2, f3, f4);
        bounds2D2.unionWith(bounds2D);
        return Reflection.transformBounds(baseTransform, bounds2D2);
    }

    public boolean operatesInUserSpace() {
        return true;
    }

    public Point2D transform(Point2D point2D, Effect effect) {
        return this.getDefaultedInput(0, effect).transform(point2D, effect);
    }

    public Point2D untransform(Point2D point2D, Effect effect) {
        return this.getDefaultedInput(0, effect).untransform(point2D, effect);
    }
}

