/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.sse;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;
import com.sun.scenario.effect.impl.state.LinearConvolvePeer;
import com.sun.scenario.effect.impl.sw.sse.SSEEffectPeer;
import java.nio.FloatBuffer;

public class SSELinearConvolvePeer
extends SSEEffectPeer
implements LinearConvolvePeer {
    public SSELinearConvolvePeer(FilterContext filterContext, Renderer renderer, String string) {
        super(filterContext, renderer, string);
    }

    protected final Effect getEffect() {
        return super.getEffect();
    }

    private LinearConvolveKernel getKernel() {
        return (LinearConvolveKernel)AccessHelper.getState(this.getEffect());
    }

    public int getPow2ScaleX(LinearConvolveKernel linearConvolveKernel) {
        return linearConvolveKernel.getPow2ScaleX();
    }

    public int getPow2ScaleY(LinearConvolveKernel linearConvolveKernel) {
        return linearConvolveKernel.getPow2ScaleY();
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, ImageData ... imageDataArray) {
        return this.getKernel().getScaledResultBounds(imageDataArray[0].getBounds(), this.getPass());
    }

    private int getCount() {
        return this.getKernel().getScaledKernelSize(this.getPass());
    }

    private float[] getOffset() {
        return this.getKernel().getVector(this.getInputNativeBounds(0), this.getPass());
    }

    private FloatBuffer getWeights() {
        return this.getKernel().getWeights(this.getPass());
    }

    public ImageData filter(Effect effect, BaseTransform baseTransform, ImageData ... imageDataArray) {
        this.setEffect(effect);
        this.setDestBounds(this.getResultBounds(baseTransform, imageDataArray));
        HeapImage heapImage = (HeapImage)imageDataArray[0].getImage();
        int n = heapImage.getPhysicalWidth();
        int n2 = heapImage.getPhysicalHeight();
        int n3 = heapImage.getScanlineStride();
        int[] nArray = heapImage.getPixelArray();
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        this.setInputBounds(0, imageDataArray[0].getBounds());
        this.setInputNativeBounds(0, rectangle);
        Rectangle rectangle2 = this.getDestBounds();
        int n4 = rectangle2.width;
        int n5 = rectangle2.height;
        HeapImage heapImage2 = (HeapImage)this.getRenderer().getCompatibleImage(n4, n5);
        this.setDestNativeBounds(heapImage2.getPhysicalWidth(), heapImage2.getPhysicalHeight());
        int n6 = heapImage2.getScanlineStride();
        int[] nArray2 = heapImage2.getPixelArray();
        int n7 = this.getCount();
        FloatBuffer floatBuffer = this.getWeights();
        LinearConvolveKernel.PassType passType = this.getKernel().getPassType(this.getPass());
        if (passType == LinearConvolveKernel.PassType.HORIZONTAL_CENTERED) {
            float[] fArray = new float[n7 * 2];
            floatBuffer.get(fArray, 0, n7);
            floatBuffer.rewind();
            floatBuffer.get(fArray, n7, n7);
            SSELinearConvolvePeer.filterHV(nArray2, n4, n5, 1, n6, nArray, n, n2, 1, n3, fArray);
        } else if (passType == LinearConvolveKernel.PassType.VERTICAL_CENTERED) {
            float[] fArray = new float[n7 * 2];
            floatBuffer.get(fArray, 0, n7);
            floatBuffer.rewind();
            floatBuffer.get(fArray, n7, n7);
            SSELinearConvolvePeer.filterHV(nArray2, n5, n4, n6, 1, nArray, n2, n, n3, 1, fArray);
        } else {
            float[] fArray = new float[n7];
            floatBuffer.get(fArray, 0, n7);
            float[] fArray2 = this.getSourceRegion(0);
            float f = fArray2[0] * (float)n;
            float f2 = fArray2[1] * (float)n2;
            float[] fArray3 = this.getOffset();
            float f3 = fArray3[0] * (float)n;
            float f4 = fArray3[1] * (float)n2;
            float f5 = fArray3[2] * (float)n;
            float f6 = fArray3[3] * (float)n2;
            SSELinearConvolvePeer.filterVector(nArray2, n4, n5, n6, nArray, n, n2, n3, fArray, n7, f, f2, f5, f6, f3, f4);
        }
        return new ImageData(this.getFilterContext(), heapImage2, rectangle2);
    }

    private static native void filterVector(int[] var0, int var1, int var2, int var3, int[] var4, int var5, int var6, int var7, float[] var8, int var9, float var10, float var11, float var12, float var13, float var14, float var15);

    private static native void filterHV(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int var6, int var7, int var8, int var9, float[] var10);
}

