/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.embeddedswing.EmbeddedToolkit;
import com.sun.embeddedswing.SwingGlueLayer;
import com.sun.scenario.ToolkitAccessor;
import com.sun.scenario.animation.FrameJob;
import com.sun.scenario.animation.Util;
import com.sun.scenario.scenegraph.JSGPanel;
import java.awt.Container;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class JSGPanelRepainter {
    private Set<JSGPanel> dirtyPanels = new HashSet<JSGPanel>();
    private Set<JSGPanel> newDirtyPanels;
    private final Set<JSGPanel> repaintedPanels = new HashSet<JSGPanel>();
    private final FrameJob frameJob = new FrameDisplay();
    private static final Object JSGPANEL_REPAINTER_KEY = new StringBuilder("JSGPanelRepainterKey");

    static JSGPanelRepainter getJSGPanelRepainter() {
        Map<Object, Object> map = SwingGlueLayer.getContextMap();
        JSGPanelRepainter jSGPanelRepainter = (JSGPanelRepainter)map.get(JSGPANEL_REPAINTER_KEY);
        if (jSGPanelRepainter == null) {
            jSGPanelRepainter = new JSGPanelRepainter();
            map.put(JSGPANEL_REPAINTER_KEY, jSGPanelRepainter);
        }
        return jSGPanelRepainter;
    }

    private JSGPanelRepainter() {
        Util.addFrameJob(this.frameJob);
    }

    void addDirtyPanel(JSGPanel jSGPanel) {
        if (this.repaintedPanels.contains(jSGPanel)) {
            if (this.newDirtyPanels == null) {
                this.newDirtyPanels = new HashSet<JSGPanel>();
            }
            this.newDirtyPanels.add(jSGPanel);
        } else {
            this.dirtyPanels.add(jSGPanel);
        }
        this.frameJob.wakeUp();
    }

    private JSGPanel getBottomPanel() {
        if (this.dirtyPanels.size() == 1) {
            return this.dirtyPanels.iterator().next();
        }
        HashSet<Container> hashSet = new HashSet<Container>();
        for (JSGPanel jSGPanel : this.dirtyPanels) {
            for (Container container = jSGPanel.getParent(); container != null && !hashSet.contains(container); container = container.getParent()) {
                hashSet.add(container);
            }
        }
        for (JSGPanel jSGPanel : this.dirtyPanels) {
            if (hashSet.contains(jSGPanel)) continue;
            return jSGPanel;
        }
        return null;
    }

    void repaintAll() {
        while (!this.dirtyPanels.isEmpty()) {
            JSGPanel jSGPanel = this.getBottomPanel();
            this.dirtyPanels.remove(jSGPanel);
            this.repaintedPanels.add(jSGPanel);
            boolean bl = !EmbeddedToolkit.isEmbedded(jSGPanel);
            jSGPanel.repaintDirtyRegions(bl);
        }
        this.repaintedPanels.clear();
        if (this.newDirtyPanels != null) {
            this.dirtyPanels = this.newDirtyPanels;
            this.newDirtyPanels = null;
        }
    }

    private class FrameDisplay
    extends FrameJob {
        private FrameDisplay() {
        }

        public void run() {
            ToolkitAccessor.firePulse();
            JSGPanelRepainter.this.repaintAll();
        }
    }
}

