/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.embeddedswing.EmbeddedPeer;
import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.scenegraph.JSGPanel;
import com.sun.scenario.scenegraph.PGComponent;
import com.sun.scenario.scenegraph.SGEmbeddedToolkit;
import com.sun.scenario.scenegraph.SGLeaf;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class SGComponent
extends SGLeaf
implements PGComponent {
    private SGEmbeddedPeer embeddedPeer = null;
    private Dimension size = null;

    public void setComponent(JComponent jComponent) {
        this.setComponent((Component)jComponent);
    }

    public final Component getComponent() {
        return this.embeddedPeer == null ? null : this.embeddedPeer.getEmbeddedComponent();
    }

    void setParent(Object object) {
        if (this.embeddedPeer != null && object == null) {
            this.embeddedPeer.setParentComponent(null);
        }
        super.setParent(object);
    }

    public void setComponent(Component component) {
        if (this.embeddedPeer != null) {
            this.embeddedPeer.dispose();
            this.embeddedPeer = null;
        }
        if (component != null) {
            this.embeddedPeer = (SGEmbeddedPeer)SGEmbeddedToolkit.getSGEmbeddedToolkit().embed(this.getPanel(), component, this);
            this.embeddedPeer.setSize(this.getSize());
        }
        this.contentBoundsChanged(true);
    }

    public void setWidth(float f) {
        Dimension dimension = this.getSize();
        int n = dimension != null ? dimension.height : Integer.MAX_VALUE;
        this.setSize(new Dimension((int)f, n));
    }

    public void setHeight(float f) {
        Dimension dimension = this.getSize();
        int n = dimension != null ? dimension.width : Integer.MAX_VALUE;
        this.setSize(new Dimension(n, (int)f));
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
        if (this.embeddedPeer != null) {
            this.embeddedPeer.setSize(dimension);
            this.embeddedPeer.validate();
        }
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    protected boolean computeContains(float f, float f2) {
        this.checkParentComponent();
        return super.computeContains(f, f2);
    }

    public void paint(Graphics2D graphics2D, BaseTransform baseTransform) {
        block2: {
            this.checkParentComponent();
            try {
                this.embeddedPeer.paint(graphics2D);
            }
            catch (NullPointerException nullPointerException) {
                if (graphics2D.getTransform().getDeterminant() == 0.0) break block2;
                throw nullPointerException;
            }
        }
    }

    public final Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.embeddedPeer == null) {
            bounds2D.setBounds(0.0f, 0.0f, 0.0f, 0.0f);
            return bounds2D;
        }
        this.checkParentComponent();
        this.embeddedPeer.setSizeUpdateEnabled(false);
        this.embeddedPeer.validate();
        this.embeddedPeer.setSizeUpdateEnabled(true);
        bounds2D.setBounds(0.0f, 0.0f, this.embeddedPeer.getShellPanel().getWidth(), this.embeddedPeer.getShellPanel().getHeight());
        SGComponent.transform(bounds2D, baseTransform);
        return bounds2D;
    }

    public void disconnect() {
        if (this.embeddedPeer != null) {
            this.embeddedPeer.setParentComponent(null);
        }
    }

    boolean hasOverlappingContents() {
        return true;
    }

    SGEmbeddedPeer getEmbeddedPeer() {
        return this.embeddedPeer;
    }

    private void checkParentComponent() {
        JSGPanel jSGPanel;
        if (this.embeddedPeer.getParentComponent() == null && (jSGPanel = this.getPanel()) != null) {
            this.embeddedPeer.setParentComponent(jSGPanel);
        }
    }

    class SGEmbeddedPeer
    extends EmbeddedPeer {
        private boolean sizeUpdateEnabled;

        SGEmbeddedPeer(JComponent jComponent, Component component) {
            super(jComponent, component);
            this.sizeUpdateEnabled = true;
        }

        public void repaint(final int n, final int n2, final int n3, final int n4) {
            if (EventQueue.isDispatchThread()) {
                this.repaintOnEDT(n, n2, n3, n4);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SGEmbeddedPeer.this.repaintOnEDT(n, n2, n3, n4);
                    }
                });
            }
        }

        private void repaintOnEDT(int n, int n2, int n3, int n4) {
            if (SGComponent.this.getComponent() == null) {
                SGComponent.this.visualsChanged(true);
                return;
            }
            SGComponent.this.visualsChanged(true);
        }

        void setSizeUpdateEnabled(boolean bl) {
            this.sizeUpdateEnabled = bl;
        }

        protected void sizeChanged(Dimension dimension, Dimension dimension2) {
            if (!this.sizeUpdateEnabled) {
                return;
            }
            if (EventQueue.isDispatchThread()) {
                SGComponent.this.contentBoundsChanged(true);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SGComponent.this.contentBoundsChanged(true);
                    }
                });
            }
        }

        protected SGEmbeddedToolkit getEmbeddedToolkit() {
            return SGEmbeddedToolkit.getSGEmbeddedToolkit();
        }

        SGComponent getNode() {
            return SGComponent.this;
        }
    }
}

