/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGMediaView;
import com.sun.javafx.tk.desktop.PerformanceTrackerHelper;
import com.sun.media.jmc.MediaFrameHandler;
import com.sun.media.jmc.MediaProvider;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.scenario.scenegraph.SGImage;
import com.sun.scenario.scenegraph.SGLeaf;
import com.sun.scenario.scenegraph.SwingMediaFrameHandler;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class SGMediaView
extends SGLeaf
implements PGMediaView,
MediaFrameHandler.FrameConsumer {
    private final Bounds2D dimension = new Bounds2D();
    private final Bounds2D viewport = new Bounds2D();
    private MediaFrameHandler handler;
    private Object interpolationHint = SGImage.getDefaultImageSmooth() ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    private final Runnable markVisualDirtyRunnable = new Runnable(){

        public void run() {
            SGMediaView.this.visualsChanged(true);
        }
    };
    private boolean firstFrameRendered = false;
    private volatile boolean firstFrameDelivered = false;

    public void setMediaProvider(Object object) {
        MediaProvider mediaProvider = (MediaProvider)object;
        if (this.handler != null) {
            this.handler.removeConsumer(this);
            this.handler = null;
        }
        if (mediaProvider != null) {
            this.handler = SwingMediaFrameHandler.getHandler(mediaProvider);
            this.handler.addConsumer(this);
        }
        this.contentBoundsChanged(true);
    }

    public boolean isSmooth() {
        return this.interpolationHint != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    }

    public void setSmooth(boolean bl) {
        Object object;
        Object object2 = object = bl ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (object != this.interpolationHint) {
            this.interpolationHint = object;
            this.visualsChanged(true);
        }
    }

    public void setViewport(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7 = this.handler != null ? (float)this.handler.getFrameWidth() : 0.0f;
        float f8 = this.handler != null ? (float)this.handler.getFrameHeight() : 0.0f;
        float f9 = f;
        float f10 = f2;
        if (f5 > 0.0f && f6 > 0.0f) {
            this.viewport.setBounds(f3, f4, f3 + f5, f4 + f6);
            f7 = f5;
            f8 = f6;
        } else {
            this.viewport.setBounds(0.0f, 0.0f, f7, f8);
        }
        if (f <= 0.0f && f2 <= 0.0f) {
            f9 = f7;
            f10 = f8;
        } else if (bl) {
            if ((double)f <= 0.0) {
                f9 = f8 > 0.0f ? f7 * (f2 / f8) : 0.0f;
                f10 = f2;
            } else if ((double)f2 <= 0.0) {
                f9 = f;
                f10 = f7 > 0.0f ? f8 * (f / f7) : 0.0f;
            } else {
                if (f7 == 0.0f) {
                    f7 = f;
                }
                if (f8 == 0.0f) {
                    f8 = f2;
                }
                float f11 = Math.min(f / f7, f2 / f8);
                f9 = f7 * f11;
                f10 = f8 * f11;
            }
        } else if ((double)f2 <= 0.0) {
            f10 = f8;
        } else if ((double)f <= 0.0) {
            f9 = f7;
        }
        if (f10 < 1.0f) {
            f10 = 1.0f;
        }
        if (f9 < 1.0f) {
            f9 = 1.0f;
        }
        this.dimension.x2 = this.dimension.x1 + f9;
        this.dimension.y2 = this.dimension.y1 + f10;
        this.contentBoundsChanged(true);
    }

    public void setX(float f) {
        if (f != this.dimension.x1) {
            float f2 = this.dimension.getWidth();
            this.dimension.x1 = f;
            this.dimension.x2 = f + f2;
            this.contentBoundsChanged(true);
        }
    }

    public void setY(float f) {
        if (f != this.dimension.y1) {
            float f2 = this.dimension.getHeight();
            this.dimension.y1 = f;
            this.dimension.y2 = f + f2;
            this.contentBoundsChanged(true);
        }
    }

    public void paint(Graphics2D graphics2D, BaseTransform baseTransform) {
        if (this.handler != null) {
            BufferedImage bufferedImage;
            if (this.firstFrameDelivered && !this.firstFrameRendered) {
                PerformanceTrackerHelper.logEvent("SGMediaView - first video frame rendered");
                PerformanceTrackerHelper.outputLog();
                this.firstFrameRendered = true;
            }
            if ((bufferedImage = (BufferedImage)this.handler.getLatestFrame(graphics2D)) != null) {
                int n;
                AffineTransform affineTransform;
                Object object;
                float f;
                float f2 = this.viewport.getWidth();
                float f3 = this.viewport.getHeight();
                boolean bl = !this.dimension.isEmpty();
                boolean bl2 = bl && (f2 != this.dimension.getWidth() || f3 != this.dimension.getHeight());
                graphics2D = (Graphics2D)graphics2D.create();
                graphics2D.translate(this.dimension.x1, this.dimension.y1);
                if (bl2 && f2 != 0.0f && f3 != 0.0f) {
                    float f4 = this.dimension.getWidth() / f2;
                    f = this.dimension.getHeight() / f3;
                    graphics2D.scale(f4, f);
                }
                if ((object = this.interpolationHint) != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR && (affineTransform = graphics2D.getTransform()).getType() <= 1) {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                f = 0.0f;
                float f5 = 0.0f;
                float f6 = f2;
                float f7 = f3;
                float f8 = this.viewport.x1;
                float f9 = this.viewport.y1;
                float f10 = f8 + f2;
                float f11 = f9 + f3;
                if (this.handler.isFrameVFlipped()) {
                    n = this.handler.getFrameHeight();
                    f9 = (float)n - f9;
                    f11 = (float)n - f11;
                }
                if (this.handler.isFrameHFlipped()) {
                    n = this.handler.getFrameWidth();
                    f8 = (float)n - f8;
                    f10 = (float)n - f10;
                }
                graphics2D.drawImage(bufferedImage, (int)f, (int)f5, (int)f6, (int)f7, (int)f8, (int)f9, (int)f10, (int)f11, null);
            }
        }
    }

    public VideoDataBuffer.Format[] getPreferredFormats() {
        return new VideoDataBuffer.Format[]{VideoDataBuffer.Format.XRGB};
    }

    public void notifyFrameArrived() {
        if (!this.firstFrameDelivered) {
            PerformanceTrackerHelper.logEvent("SGMediaView - first video frame delivered, media=");
            this.firstFrameDelivered = true;
        }
        EventQueue.invokeLater(this.markVisualDirtyRunnable);
    }

    public final Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        float f = this.dimension.x1;
        float f2 = this.dimension.y1;
        boolean bl = !this.dimension.isEmpty();
        float f3 = bl ? this.dimension.getWidth() : this.viewport.getWidth();
        float f4 = bl ? this.dimension.getHeight() : this.viewport.getHeight();
        bounds2D.setBounds(f, f2, f + f3, f2 + f4);
        baseTransform.transform(bounds2D, bounds2D);
        return bounds2D;
    }

    public boolean hasOverlappingContents() {
        return false;
    }
}

