/*
 * Decompiled with CFR 0.152.
 */
package com.sun.stylesheet.css;

class URIResolver {
    private static final long L_DIGIT = URIResolver.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URIResolver.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URIResolver.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_SCHEME = 0L | L_DIGIT | URIResolver.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | URIResolver.highMask("+-.");

    URIResolver() {
    }

    public static String resolve(String string, String string2) {
        if (string2.charAt(0) != '/' && !URIResolver.startsWithScheme(string2)) {
            return URIResolver.resolvePath(string, string2);
        }
        return string2;
    }

    private static boolean startsWithScheme(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (URIResolver.match(c, L_SCHEME, H_SCHEME)) continue;
            return c == ':';
        }
        return false;
    }

    private static long lowMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '@') continue;
            l |= 1L << c;
        }
        return l;
    }

    private static long highMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            l |= 1L << c - 64;
        }
        return l;
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static long highMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 127), 64) - 64;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    private static String resolvePath(String string, String string2) {
        CharSequence charSequence;
        int n = string.lastIndexOf(47);
        int n2 = string2.length();
        String string3 = "";
        if (n2 == 0) {
            if (n >= 0) {
                string3 = string.substring(0, n + 1);
            }
        } else {
            charSequence = new StringBuffer(string.length() + n2);
            if (n >= 0) {
                ((StringBuffer)charSequence).append(string.substring(0, n + 1));
            }
            ((StringBuffer)charSequence).append(string2);
            string3 = ((StringBuffer)charSequence).toString();
        }
        charSequence = URIResolver.normalize(string3);
        return charSequence;
    }

    private static int needsNormalization(String string) {
        int n;
        boolean bl = true;
        int n2 = 0;
        int n3 = string.length() - 1;
        for (n = 0; n <= n3 && string.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            bl = false;
        }
        int n4 = 0;
        n4 = string.indexOf("http://");
        if (n4 != -1) {
            n = n4 + 7;
            ++n2;
        } else {
            n4 = string.indexOf("https://");
            if (n4 != -1) {
                n = n4 + 8;
                ++n2;
            }
        }
        block1: while (n <= n3) {
            if (string.charAt(n) == '.' && (n == n3 || string.charAt(n + 1) == '/' || string.charAt(n + 1) == '.' && (n + 1 == n3 || string.charAt(n + 2) == '/'))) {
                bl = false;
            }
            ++n2;
            while (n <= n3) {
                if (string.charAt(n++) != '/') continue;
                while (n <= n3 && string.charAt(n) == '/') {
                    bl = false;
                    ++n;
                }
                continue block1;
            }
        }
        return bl ? -1 : n2;
    }

    private static void split(char[] cArray, int[] nArray) {
        int n;
        int n2 = cArray.length - 1;
        int n3 = 0;
        for (n = 0; n <= n2 && cArray[n] == '/'; ++n) {
            cArray[n] = '\u0000';
        }
        String string = new String(cArray);
        int n4 = 0;
        n4 = string.indexOf("http://");
        if (n4 != -1) {
            nArray[n3++] = n;
            cArray[n4 + 6] = '\u0000';
            n = n4 + 7;
        } else {
            n4 = string.indexOf("https://");
            if (n4 != -1) {
                nArray[n3++] = n;
                cArray[n4 + 7] = '\u0000';
                n = n4 + 8;
            }
        }
        block1: while (n <= n2) {
            nArray[n3++] = n++;
            while (n <= n2) {
                if (cArray[n++] != '/') continue;
                cArray[n - 1] = '\u0000';
                while (n <= n2 && cArray[n] == '/') {
                    cArray[n++] = '\u0000';
                }
                continue block1;
            }
        }
        if (n3 != nArray.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n3 = 0;
        if (cArray[n3] == '\u0000') {
            cArray[n3++] = 47;
        }
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            if (n4 == -1) continue;
            if (n3 == n4) {
                while (n3 <= n2 && cArray[n3] != '\u0000') {
                    ++n3;
                }
                if (n3 > n2) continue;
                cArray[n3++] = 47;
                continue;
            }
            if (n3 < n4) {
                while (n4 <= n2 && cArray[n4] != '\u0000') {
                    cArray[n3++] = cArray[n4++];
                }
                if (n4 > n2) continue;
                cArray[n3++] = 47;
                continue;
            }
            throw new InternalError();
        }
        return n3;
    }

    private static void removeDots(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5 = 0;
            do {
                if (cArray[n4 = nArray[i]] != '.') continue;
                if (n4 == n2) {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] == '\u0000') {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] != '.' || n4 + 1 != n2 && cArray[n4 + 2] != '\u0000') continue;
                n5 = 2;
                break;
            } while (++i < n);
            if (i > n || n5 == 0) break;
            if (n5 == 1) {
                nArray[i] = -1;
                continue;
            }
            for (n4 = i - 1; n4 >= 0 && nArray[n4] == -1; --n4) {
            }
            if (n4 < 0 || cArray[n3 = nArray[n4]] == '.' && cArray[n3 + 1] == '.' && cArray[n3 + 2] == '\u0000') continue;
            nArray[i] = -1;
            nArray[n4] = -1;
        }
    }

    private static void maybeAddLeadingDot(char[] cArray, int[] nArray) {
        int n;
        int n2;
        if (cArray[0] == '\u0000') {
            return;
        }
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3 && nArray[n2] < 0; ++n2) {
        }
        if (n2 >= n3 || n2 == 0) {
            return;
        }
        for (n = nArray[n2]; n < cArray.length && cArray[n] != ':' && cArray[n] != '\u0000'; ++n) {
        }
        if (n >= cArray.length || cArray[n] == '\u0000') {
            return;
        }
        cArray[0] = 46;
        cArray[1] = '\u0000';
        nArray[0] = 0;
    }

    static String normalize(String string) {
        int n = URIResolver.needsNormalization(string);
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n];
        URIResolver.split(cArray, nArray);
        URIResolver.removeDots(cArray, nArray);
        URIResolver.maybeAddLeadingDot(cArray, nArray);
        String string2 = new String(cArray, 0, URIResolver.join(cArray, nArray));
        if (string2.equals(string)) {
            return string;
        }
        return string2;
    }
}

