/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import com.sun.javafx.runtime.annotation.Def;
import com.sun.javafx.runtime.annotation.Inherited;
import com.sun.javafx.runtime.annotation.Package;
import com.sun.javafx.runtime.annotation.Protected;
import com.sun.javafx.runtime.annotation.Public;
import com.sun.javafx.runtime.annotation.PublicInitable;
import com.sun.javafx.runtime.annotation.PublicReadable;
import com.sun.javafx.runtime.annotation.SourceName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javafx.reflect.FXFunctionType;
import javafx.reflect.FXJavaArrayType;
import javafx.reflect.FXLocal;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceType;
import javafx.reflect.FXType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlatformUtils {
    PlatformUtils() {
    }

    static Type[] getGenericParameterTypes(Method method) {
        return method.getGenericParameterTypes();
    }

    static Type getGenericReturnType(Method method) {
        return method.getGenericReturnType();
    }

    static boolean isSynthetic(Field field) {
        return field.isSynthetic();
    }

    static boolean isSynthetic(Method method) {
        return method.isSynthetic();
    }

    static int checkInherited(Method method) {
        return method.getAnnotation(Inherited.class) != null ? 1 : 0;
    }

    static String getCanonicalName(Class clazz) {
        return clazz.getCanonicalName();
    }

    static String getSourceNameFromAnnotation(Field field) {
        SourceName sourceName = field.getAnnotation(SourceName.class);
        return sourceName == null ? null : sourceName.value();
    }

    static Annotation getAnnotation(FXLocal.ClassType classType, Class clazz) {
        Class clazz2 = classType.refClass;
        return clazz2.getAnnotation(clazz);
    }

    static <T extends Annotation> T getAnnotation(FXLocal.VarMember varMember, Class<T> clazz) {
        Field field = varMember.fld;
        if (field != null) {
            return field.getAnnotation(clazz);
        }
        Method method = varMember.getter;
        if (method != null) {
            return method.getAnnotation(clazz);
        }
        return null;
    }

    static int checkPublic(FXLocal.ClassType classType) {
        if (classType.isJfxType()) {
            return -1;
        }
        return PlatformUtils.getAnnotation(classType, Public.class) != null ? 1 : 0;
    }

    static int checkPackage(FXLocal.ClassType classType) {
        if (!classType.isJfxType()) {
            return -1;
        }
        return PlatformUtils.getAnnotation(classType, Package.class) != null ? 1 : 0;
    }

    static boolean isProtected(FXLocal.ClassType classType) {
        return PlatformUtils.getAnnotation(classType, Protected.class) != null;
    }

    static int checkAccess(FXLocal.VarMember varMember, Class clazz) {
        if (!varMember.getDeclaringClass().isJfxType()) {
            return -1;
        }
        return PlatformUtils.getAnnotation(varMember, clazz) != null ? 1 : 0;
    }

    static boolean checkAccessAnnotations(FXLocal.VarMember varMember) {
        if (PlatformUtils.getAnnotation(varMember, Public.class) != null) {
            varMember.flags |= 4;
        }
        if (PlatformUtils.getAnnotation(varMember, Protected.class) != null) {
            varMember.flags |= 8;
        }
        if (PlatformUtils.getAnnotation(varMember, Package.class) != null) {
            varMember.flags |= 0x10;
        }
        if (PlatformUtils.getAnnotation(varMember, PublicInitable.class) != null) {
            varMember.flags |= 0x20;
        }
        if (PlatformUtils.getAnnotation(varMember, PublicReadable.class) != null) {
            varMember.flags |= 0x40;
        }
        return true;
    }

    static int checkDef(FXLocal.VarMember varMember) {
        return PlatformUtils.checkAccess(varMember, Def.class);
    }

    static int checkAccess(FXLocal.FunctionMember functionMember, Class clazz) {
        if (!functionMember.getDeclaringClass().isJfxType()) {
            return -1;
        }
        return functionMember.method.getAnnotation(clazz) != null ? 1 : 0;
    }

    static int checkPublic(FXLocal.FunctionMember functionMember) {
        return PlatformUtils.checkAccess(functionMember, Public.class);
    }

    static int checkProtected(FXLocal.FunctionMember functionMember) {
        return PlatformUtils.checkAccess(functionMember, Protected.class);
    }

    static int checkPackage(FXLocal.FunctionMember functionMember) {
        return PlatformUtils.checkAccess(functionMember, Package.class);
    }

    static Object resolveGeneric(FXLocal.Context context, Type object) {
        String string;
        Type[] typeArray;
        Type[] typeArray2;
        Object object2;
        if (object instanceof ParameterizedType) {
            object2 = (ParameterizedType)object;
            typeArray2 = object2.getRawType();
            typeArray = object2.getActualTypeArguments();
            if (typeArray2 instanceof Class) {
                string = ((Class)typeArray2).getName();
                if ("com.sun.javafx.runtime.sequence.Sequence".equals(string) && typeArray.length == 1) {
                    return new FXSequenceType(context.makeTypeRef(typeArray[0]));
                }
                if ("com.sun.javafx.runtime.location.ObjectVariable".equals(string) && typeArray.length == 1) {
                    return context.makeTypeRef(typeArray[0]);
                }
                if ("com.sun.javafx.runtime.location.SequenceVariable".equals(string) && typeArray.length == 1) {
                    return new FXSequenceType(context.makeTypeRef(typeArray[0]));
                }
                if (string.startsWith("com.sun.javafx.functions.Function")) {
                    FXType[] fXTypeArray = new FXType[typeArray.length - 1];
                    int n = fXTypeArray.length;
                    while (--n >= 0) {
                        fXTypeArray[n] = context.makeTypeRef(typeArray[n + 1]);
                    }
                    FXType fXType = typeArray[0] == Void.class ? FXPrimitiveType.voidType : context.makeTypeRef(typeArray[0]);
                    return new FXFunctionType(fXTypeArray, fXType);
                }
            }
            object = typeArray2;
        }
        if (object instanceof WildcardType) {
            FXPrimitiveType fXPrimitiveType;
            object2 = (WildcardType)object;
            typeArray2 = object2.getUpperBounds();
            typeArray = object2.getLowerBounds();
            Object object3 = object = typeArray.length > 0 ? typeArray[0] : object2.getUpperBounds()[0];
            if (object instanceof Class && (fXPrimitiveType = context.getPrimitiveType(string = ((Class)object).getName())) != null) {
                return fXPrimitiveType;
            }
            return context.makeTypeRef((Type)object);
        }
        if (object instanceof GenericArrayType) {
            object2 = context.makeTypeRef(((GenericArrayType)object).getGenericComponentType());
            return new FXJavaArrayType((FXType)object2);
        }
        if (object instanceof TypeVariable) {
            object = Object.class;
        }
        return object;
    }
}

