/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.Iterator;
import org.antlr.runtime.misc.FastQueue;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;

public class TreeIterator
implements Iterator {
    protected TreeAdaptor adaptor;
    protected Object root;
    protected Object tree;
    protected boolean firstTime = true;
    public Object up;
    public Object down;
    public Object eof;
    protected FastQueue nodes;

    public TreeIterator(Object object) {
        this(new CommonTreeAdaptor(), object);
    }

    public TreeIterator(TreeAdaptor treeAdaptor, Object object) {
        this.adaptor = treeAdaptor;
        this.tree = object;
        this.root = object;
        this.nodes = new FastQueue();
        this.down = treeAdaptor.create(2, "DOWN");
        this.up = treeAdaptor.create(3, "UP");
        this.eof = treeAdaptor.create(-1, "EOF");
    }

    public void reset() {
        this.firstTime = true;
        this.tree = this.root;
        this.nodes.clear();
    }

    public boolean hasNext() {
        if (this.firstTime) {
            return this.root != null;
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            return true;
        }
        if (this.tree == null) {
            return false;
        }
        if (this.adaptor.getChildCount(this.tree) > 0) {
            return true;
        }
        return this.adaptor.getParent(this.tree) != null;
    }

    public Object next() {
        if (this.firstTime) {
            this.firstTime = false;
            if (this.adaptor.getChildCount(this.tree) == 0) {
                this.nodes.add(this.eof);
                return this.tree;
            }
            return this.tree;
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            return this.nodes.remove();
        }
        if (this.tree == null) {
            return this.eof;
        }
        if (this.adaptor.getChildCount(this.tree) > 0) {
            this.tree = this.adaptor.getChild(this.tree, 0);
            this.nodes.add(this.tree);
            return this.down;
        }
        Object object = this.adaptor.getParent(this.tree);
        while (object != null && this.adaptor.getChildIndex(this.tree) + 1 >= this.adaptor.getChildCount(object)) {
            this.nodes.add(this.up);
            this.tree = object;
            object = this.adaptor.getParent(this.tree);
        }
        if (object == null) {
            this.tree = null;
            this.nodes.add(this.eof);
            return this.nodes.remove();
        }
        int n = this.adaptor.getChildIndex(this.tree) + 1;
        this.tree = this.adaptor.getChild(object, n);
        this.nodes.add(this.tree);
        return this.nodes.remove();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

