package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import tno.geoenergy.doubletcalc.stochastic.TnoMyStochasticObjects;

public class ResultSet {

	public float[] pumpCasePumpPowers;
	public float[] pumpCaseQvolPumps;
	public float[] pumpCaseGeoThermalPowers;
	public float[] pumpCasePressureDrawdowns;
	public float[] pumpCaseCops;
	public TnoPipe baseCaseProducerPipe;
	public TnoPipe baseCaseInjectorPipe;
        public TnoPipe hydrostaticProducer;
	public TnoPipe hydrostaticInjector;
	public String[] doubletNodes;
	public static double[] baseCasePressureAlongDoublet;
	public static double[] baseCaseTemperatureAlongDoublet;
	

	public static String[] getStochGeoInputProperties() {
		String[] list = {
				TnoMyStochasticObjects.AQUIFER_PERMEABILITY,
                                TnoMyStochasticObjects.AQUIFER_NG,
                                TnoMyStochasticObjects.AQUIFER_THICKNESS,
                                TnoMyStochasticObjects.AQUIFER_TOPPRODUCTION,
				TnoMyStochasticObjects.AQUIFER_TOPINJECTION,
				TnoMyStochasticObjects.AQUIFER_SALINITY,
			};
		
		return list;
	}

	public static String[] getSingularGeoInputProperties() {

		String[] list = {  TnoMyStochasticObjects.SIMULATION_RUNS,
                                TnoMyStochasticObjects.KH_KV,
                                TnoMyStochasticObjects.TEMPERATURE_SURFACE,
                                TnoMyStochasticObjects.GEOTHERMAL_GRADIENT,
                                TnoMyStochasticObjects.AQUIFER_TEMPERATURE,
                                TnoMyStochasticObjects.AQUIFER_PRESSURE_PRODUCTION,
				TnoMyStochasticObjects.AQUIFER_PRESSURE_INJECTION,
                               
				TnoMyStochasticObjects.TEMPERATURE_INJECTION,
				TnoMyStochasticObjects.WELL_DISTANCE,
                                TnoMyStochasticObjects.PUMP_EFFICIENCY,
                                TnoMyStochasticObjects.PUMP_PRODUCTIONDEPTH,
				TnoMyStochasticObjects.PUMP_PRESSUREDIFFERENCE,

				
				TnoMyStochasticObjects.PRD_OUTERDIAMETER,
                                TnoMyStochasticObjects.SKIN_PRODUCTION,
                                TnoMyStochasticObjects.PRD_ANGLE_SKIN,

                                TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH,
				TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD,
				TnoMyStochasticObjects.PRD_TUBING_DIAMETER,
                                TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS,

                                TnoMyStochasticObjects.INJ_OUTERDIAMETER,
                                TnoMyStochasticObjects.SKIN_INJECTION,
				TnoMyStochasticObjects.INJ_ANGLE_SKIN,

                                TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH,
                                TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD,
                                TnoMyStochasticObjects.INJ_TUBING_DIAMETER,
				TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS,
                                };

		return list;
	}

       	public static String[] getStochGeoOutputProperties() {
		String[] list = { TnoMyStochasticObjects.AQUIFER_KH,
				TnoMyStochasticObjects.QMASS, TnoMyStochasticObjects.PUMP_QVOL,
				TnoMyStochasticObjects.PUMP_POWER_REQUIRED,
				TnoMyStochasticObjects.GEOTHERMAL_POWERS,
				TnoMyStochasticObjects.COP };

		return list;
	}

	public static String[] getBaseGeoOutputProperties() {
		String[] list = { TnoMyStochasticObjects.BASECASE_AQUIFER_KH,
				TnoMyStochasticObjects.BASECASE_QMASS,
				TnoMyStochasticObjects.BASECASE_PUMP_QVOL,
				TnoMyStochasticObjects.BASECASE_PUMP_POWER_REQUIRED,
				TnoMyStochasticObjects.BASECASE_GEOTHERMAL_POWERS,
				TnoMyStochasticObjects.BASECASE_COP, };

		return list;
	}

//        public static Object[][]getBaseCaseWellProperties(){
//            Object[][] list = {
//                                {"Aquifer Pressure at producer (bar)", pressureAlongDoublet[0] * 1e-5},
//                                {"Aquifer Pressure at Injector (bar)", pressureAlongDoublet[5] * 1e-5},
//                                {"Pressure difference at producer (bar)", (pressureAlongDoublet[0] - pressureAlongDoublet[1])* 1e-5},
//                                {"Pressure difference at Injector (bar)", (pressureAlongDoublet[4] - pressureAlongDoublet[5])* 1e-5},
//                                {"Aquifer temperature at producer (C) *", temperatureAlongDoublet[1]},
//                                {"Temperature at heat exchanger (C)", temperatureAlongDoublet[2]},
//            };
//            return list;
//        }

        public static String[] getBaseCaseWellProperties() {
		String[] list = { TnoMyStochasticObjects.BASECASE_AQP_PRD,
				TnoMyStochasticObjects.BASECASE_AQP_INJ,
                                TnoMyStochasticObjects.BASECASE_DP_PRD,
				TnoMyStochasticObjects.BASECASE_DP_INJ,
				TnoMyStochasticObjects.BASECASE_AQT_PRD,
				TnoMyStochasticObjects.BASECASE_T_HE,
                                TnoMyStochasticObjects.BASECASE_P_HE};
		return list;
	}

        public static String[] getStochWellProperties() {
		String[] list = { TnoMyStochasticObjects.AQP_PRD,
				TnoMyStochasticObjects.AQP_INJ,
                                TnoMyStochasticObjects.DP_PRD,
				TnoMyStochasticObjects.DP_INJ,
				TnoMyStochasticObjects.AQT_PRD,
				TnoMyStochasticObjects.T_HE};
                //,
                //                TnoMyStochasticObjects.P_HE};
		return list;
	}

	public void conditionPumpCaseArrays(int maxIndex) {

		pumpCasePumpPowers = new float[maxIndex];
		pumpCaseQvolPumps = new float[maxIndex];
		pumpCaseGeoThermalPowers = new float[maxIndex];
		pumpCasePressureDrawdowns = new float[maxIndex];
		pumpCaseCops = new float[maxIndex];
	}

}
