package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *         (c) 2009 TNO
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html         
 * 
 */

public class TnoDoublet {

	public TnoGeoThermalWell producer;
	public TnoGeoThermalWell injector;
	public String[] nodeNamesAlongDoublet = { "1, Aquifer_Prod",
			"2, Aquifer/Prod_Bottom", "5&6, Prod_Top/Entry_HE", "7&9, Exit_HE/Inj_Top",
			"10, Inj_Bottom/Aquifer", "11, Aquifer_Inj", "Residue" };
	public int pressNodeTopInj = 3;
	public double[] presAlongDoublet;
	public double[] tempAlongDoublet;

	public String name;
	public int idnumber;
        public double aquiferTopDepthAtProdBaseCase; // (mTVDSS)
	public double aquiferTopDepthAtInjBaseCase;
	public double aquiferTopDepthAtProd; // (mTVDSS)
	public double aquiferTopDepthAtInj; // (mTVDSS)
	public double aquiferThickness; // (m)
	public double aquiferNtG; // (1)
	public double aquiferK; // (m2)
	public double aquiferSalinity; // (ppm)

	public double aquiferStaticPresProd; // (Pa)
	public double aquiferStaticPresInj; // (Pa)

	public TnoGeoTemperature GeoTemperature;
	public double surfaceTemp; // (degC)
	public double geoThermalGradient; // (degC/m)
	public double exitTempHeatExchanger; // (degC)
	public double tempTopProductionAquifer; // (degC)
	public double tempMidProductionAquifer; // (degC)
	public PipeTempCalcMethod tempCalcOptionProducer;
	public PipeTempCalcMethod tempCalcOptionInjector;

	public double distanceWellsAtAquifer; // (m)
	public double[] depthSegmentsTVDProd; // (m)
	public double[] depthSegmentsTVDInj; // (m)
	public double[] depthSegmentsAHProd; // (m)
	public double[] depthSegmentsAHInj; // (m)
	public double segmentLength; // (m)
	public double outerDiameterInj; // (m)
	public double outerDiameterPrd; // (m)
	public double[] innerDiameterInj; // (m)
	public double[] innerDiameterPrd; // (m)
	public double[] roughnessInj; // (m)
	public double[] roughnessPrd; // (m)

	public double skinProducer; // (1)
	public double skinInjector; // (1)

	public double pumpDepth; // (mTVDSS)
	public double pumpPressureDrawDown; // (bar)
	public double pumpMaxRate; // (m3/s)
	public double pumpEfficiency; // 0 < eff <= 1

	public double geoThermalPower; // (W)
	public double[] geothermalPowerYears; // W
	public double geothermalPowerYearsSingle;

	public double coP; // // Coefficent of Performance
	public double pumpPower; // (W)

	public double qmass; // (kg/s)
	private double aquiferKHnet;
	private double qvolPump; // (m3/s)

	public double aquiferProductTopPressure;
	public double aquiferInjectTopPressure;

	public double productDensity;
	public double heatcapacity;
	public double deltaT;

	public TnoGeoThermalWell getProducer() {
		return producer;
	}

	public void setProducer(TnoGeoThermalWell producer) {
		this.producer = producer;
	}

	public TnoGeoThermalWell getInjector() {
		return injector;
	}

	public void setInjector(TnoGeoThermalWell injector) {
		this.injector = injector;
	}

	public String[] getNodeNamesAlongDoublet() {
		return nodeNamesAlongDoublet;
	}

	public void setNodeNamesAlongDoublet(String[] nodeNamesAlongDoublet) {
		this.nodeNamesAlongDoublet = nodeNamesAlongDoublet;
	}

	public int getPressNodeTopInj() {
		return pressNodeTopInj;
	}

	public void setPressNodeTopInj(int pressNodeTopInj) {
		this.pressNodeTopInj = pressNodeTopInj;
	}

	public double[] getPresAlongDoublet() {
		return presAlongDoublet;
	}

	public void setPresAlongDoublet(double[] presAlongDoublet) {
		this.presAlongDoublet = presAlongDoublet;
	}

	public double[] getTempAlongDoublet() {
		return tempAlongDoublet;
	}

	public void setTempAlongDoublet(double[] tempAlongDoublet) {
		this.tempAlongDoublet = tempAlongDoublet;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getIdnumber() {
		return idnumber;
	}

	public void setIdnumber(int idnumber) {
		this.idnumber = idnumber;
	}

	public double getAquiferTopDepthAtProd() {
		return aquiferTopDepthAtProd;
	}

	public void setAquiferTopDepthAtProd(double aquiferTopDepthAtProd) {
		this.aquiferTopDepthAtProd = aquiferTopDepthAtProd;
	}

	public double getAquiferTopDepthAtInj() {
		return aquiferTopDepthAtInj;
	}

	public void setAquiferTopDepthAtInj(double aquiferTopDepthAtInj) {
		this.aquiferTopDepthAtInj = aquiferTopDepthAtInj;
	}

	public double getAquiferThickness() {
		return aquiferThickness;
	}

	public void setAquiferThickness(double aquiferThickness) {
		this.aquiferThickness = aquiferThickness;
	}

	public double getAquiferNtG() {
		return aquiferNtG;
	}

	public void setAquiferNtG(double aquiferNtG) {
		this.aquiferNtG = aquiferNtG;
	}

	public double getAquiferK() {
		return aquiferK;
	}

	public void setAquiferK(double aquiferK) {
		this.aquiferK = aquiferK;
	}

	public double getAquiferSalinity() {
		return aquiferSalinity;
	}

	public void setAquiferSalinity(double aquiferSalinity) {
		this.aquiferSalinity = aquiferSalinity;
	}

	public double getAquiferStaticPresProd() {
		return aquiferStaticPresProd;
	}

	public void setAquiferStaticPresProd(double aquiferStaticPresProd) {
		this.aquiferStaticPresProd = aquiferStaticPresProd;
	}

	public double getAquiferStaticPresInj() {
		return aquiferStaticPresInj;
	}

	public void setAquiferStaticPresInj(double aquiferStaticPresInj) {
		this.aquiferStaticPresInj = aquiferStaticPresInj;
	}

	public TnoGeoTemperature getGeoTemperature() {
		return GeoTemperature;
	}

	public void setGeoTemperature(TnoGeoTemperature geoTemperature) {
		GeoTemperature = geoTemperature;
	}

	public double getSurfaceTemp() {
		return surfaceTemp;
	}

	public void setSurfaceTemp(double surfaceTemp) {
		this.surfaceTemp = surfaceTemp;
	}

	public double getGeoThermalGradient() {
		return geoThermalGradient;
	}

	public void setGeoThermalGradient(double geoThermalGradient) {
		this.geoThermalGradient = geoThermalGradient;
	}

	public double getExitTempHeatExchanger() {
		return exitTempHeatExchanger;
	}

	public void setExitTempHeatExchanger(double exitTempHeatExchanger) {
		this.exitTempHeatExchanger = exitTempHeatExchanger;
	}

	public double getTempTopProductionAquifer() {
		return tempTopProductionAquifer;
	}

	public void setTempTopProductionAquifer(double tempTopProductionAquifer) {
		this.tempTopProductionAquifer = tempTopProductionAquifer;
	}

	public double getTempMidProductionAquifer() {
		return tempMidProductionAquifer;
	}

	public void setTempMidProductionAquifer(double tempMidProductionAquifer) {
		this.tempMidProductionAquifer = tempMidProductionAquifer;
	}

	public PipeTempCalcMethod getTempCalcOptionProducer() {
		return tempCalcOptionProducer;
	}

	public void setTempCalcOptionProducer(
			PipeTempCalcMethod tempCalcOptionProducer) {
		this.tempCalcOptionProducer = tempCalcOptionProducer;
	}

	public PipeTempCalcMethod getTempCalcOptionInjector() {
		return tempCalcOptionInjector;
	}

	public void setTempCalcOptionInjector(
			PipeTempCalcMethod tempCalcOptionInjector) {
		this.tempCalcOptionInjector = tempCalcOptionInjector;
	}

	public double getDistanceWellsAtAquifer() {
		return distanceWellsAtAquifer;
	}

	public void setDistanceWellsAtAquifer(double distanceWellsAtAquifer) {
		this.distanceWellsAtAquifer = distanceWellsAtAquifer;
	}

	public double[] getDepthSegmentsTVDProd() {
		return depthSegmentsTVDProd;
	}

	public void setDepthSegmentsTVDProd(double[] segmentsTVDProd) {
		this.depthSegmentsTVDProd = segmentsTVDProd;
	}

	public double[] getDepthSegmentsTVDInj() {
		return depthSegmentsTVDInj;
	}

	public void setDepthSegmentsTVDInj(double[] segmentsTVDInj) {
		this.depthSegmentsTVDInj = segmentsTVDInj;
	}

	public double[] getDepthSegmentsAHProd() {
		return depthSegmentsAHProd;
	}

	public void setDepthSegmentsAHProd(double[] segmentsAHProd) {
		this.depthSegmentsAHProd = segmentsAHProd;
	}

	public double[] getDepthSegmentsAHInj() {
		return depthSegmentsAHInj;
	}

	public void setDepthSegmentsAHInj(double[] segmentsAHInj) {
		this.depthSegmentsAHInj = segmentsAHInj;
	}
	
	
	
	public double getSegmentLength() {
		return segmentLength;
	}

	public void setSegmentLength(double segmentLength) {
		this.segmentLength = segmentLength;
	}

	public double getOuterDiameterInj() {
		return outerDiameterInj;
	}

	public void setOuterDiameterInj(double outerDiameterInj) {
		this.outerDiameterInj = outerDiameterInj;
	}

	public double[] getInnerDiameterInj() {
		return innerDiameterInj;
	}

	public void setInnerDiameterInj(double[] innerDiameterInj) {
		this.innerDiameterInj = innerDiameterInj;
	}
	
	public double getOuterDiameterPrd() {
		return outerDiameterPrd;
	}

	public void setOuterDiameterPrd(double outerDiameterPrd) {
		this.outerDiameterPrd = outerDiameterPrd;
	}

	public double[] getInnerDiameterPrd() {
		return innerDiameterPrd;
	}

	public void setInnerDiameterPrd(double[] innerDiameterPrd) {
		this.innerDiameterPrd = innerDiameterPrd;
	}
	
	public double[] getRoughnessInj() {
		return roughnessInj;
	}

	public void setRoughnessInj(double[] roughness) {
		this.roughnessInj = roughness;
	}
	
	public double[] getRoughnessPrd() {
		return roughnessPrd;
	}

	public void setRoughnessPrd(double[] roughness) {
		this.roughnessPrd = roughness;
	}

	public double getSkinProducer() {
		return skinProducer;
	}

	public void setSkinProducer(double skinProducer) {
		this.skinProducer = skinProducer;
	}

	public double getSkinInjector() {
		return skinInjector;
	}

	public void setSkinInjector(double skinInjector) {
		this.skinInjector = skinInjector;
	}

	public double getPumpDepth() {
		return pumpDepth;
	}

	public void setPumpDepth(double pumpDepth) {
		this.pumpDepth = pumpDepth;
	}

	public double getPumpPressureDrawDown() {
		return pumpPressureDrawDown;
	}

	public void setPumpPressureDrawDown(double pumpPressureDrawDown) {
		this.pumpPressureDrawDown = pumpPressureDrawDown;
	}

	public double getPumpMaxRate() {
		return pumpMaxRate;
	}

	public void setPumpMaxRate(double pumpMaxRate) {
		this.pumpMaxRate = pumpMaxRate;
	}

	public double getPumpEfficiency() {
		return pumpEfficiency;
	}

	public void setPumpEfficiency(double pumpEfficiency) {
		this.pumpEfficiency = pumpEfficiency;
	}

	public double getGeoThermalPower() {
		return geoThermalPower;
	}

	public void setGeoThermalPower(double geoThermalPower) {
		this.geoThermalPower = geoThermalPower;
	}

	public double getCoP() {
		return coP;
	}

	public void setCoP(double coP) {
		this.coP = coP;
	}

	public double getPumpPower() {
		return pumpPower;
	}

	public void setPumpPower(double pumpPower) {
		this.pumpPower = pumpPower;
	}

	public double getQmass() {
		return qmass;
	}

	public void setQmass(double qmass) {
		this.qmass = qmass;
	}

	public double getQvolInjector() {
		return injector.wellTubing.qVolNode[0];
	}

	public double getAquiferKHnet() {
		return aquiferK * aquiferThickness * aquiferNtG;
	}

	public double getQvolPump() {
		return 0.5 * (producer.wellTubing.qVolNode[producer.wellTubing.PumpSegment] + producer.wellTubing.qVolNode[producer.wellTubing.PumpSegment + 1]); // in
		// m3/s
	}
	
	public double getProductDensity() {
		return productDensity;
	}
	
	public double getHeatCapacity(){
		return heatcapacity;
	}
	
	public double getDeltaT(){
		return deltaT;
	}

	public TnoDoublet() {
		name = "Doublet";
		presAlongDoublet = new double[nodeNamesAlongDoublet.length];
		tempAlongDoublet = new double[nodeNamesAlongDoublet.length];

	}

	public void LoadDataFromInput(TnoInputWindowData input) {
                aquiferTopDepthAtProdBaseCase = input.aquiferTopDepthAtProd.getDistribution()
				.getMedian();
		aquiferTopDepthAtProd = input.aquiferTopDepthAtProd.getDistribution()
				.getMedian(); // (mTVDSS)
                aquiferTopDepthAtInjBaseCase = input.aquiferTopDepthAtInj.getDistribution()
				.getMedian();
		aquiferTopDepthAtInj = input.aquiferTopDepthAtInj.getDistribution()
				.getMedian(); // (mTVDSS)
		aquiferThickness = input.aquiferThickness.getDistribution().getMedian();// (m)
		aquiferK = input.aquiferK.getDistribution().getMedian();// (m2)
		aquiferNtG = input.aquiferNtG.getDistribution().getMedian();// (1)

		aquiferSalinity = input.aquiferSalinity.getDistribution().getMedian(); // (1)

		surfaceTemp = input.surfaceTemp; // (degC)
		geoThermalGradient = input.geoThermalGradient; // (degC/m)
		tempTopProductionAquifer = input.tempTopProductionAquifer; // (degC)
		exitTempHeatExchanger = input.exitTempHeatExchanger; // (degC)

		distanceWellsAtAquifer = input.distanceWellsAtAquifer; // (m)
		depthSegmentsTVDProd = input.segmentsPrdTVD; // (m)
		depthSegmentsTVDInj = input.segmentsInjTVD; // (m)
		depthSegmentsAHProd = input.segmentsPrdAH; // (m)
		depthSegmentsAHInj = input.segmentsInjAH;
		segmentLength = input.segmentLength; // (m) target segment length

		outerDiameterInj = input.outerDiameterInject; // (m)
		outerDiameterPrd = input.outerDiameterProduct; // (m)
		innerDiameterInj = input.innerDiameterInj; // (m)
		innerDiameterPrd = input.innerDiameterPrd; // (m)
		roughnessInj = input.roughnessInj; // (m)
		roughnessPrd = input.roughnessPrd; // (m)
		skinProducer = input.skinProducer; // (1)
		skinInjector = input.skinInjector; // (1)

		pumpDepth = input.pumpDepth; // (mTVDSS) positive downwards
		pumpPressureDrawDown = input.pumpPressureDrawDown; // (Pa)
		// XXX this is a quick fix for debugging
		pumpMaxRate = 0; // (m3/s)
		pumpEfficiency = input.pumpEfficiency;// (1); 0 < eff <= 1

		tempCalcOptionProducer = input.tempCalcOptionProducer;
		tempCalcOptionInjector = input.tempCalcOptionInjector;

		aquiferProductTopPressure = input.aquiferProductTopPressure;
		aquiferInjectTopPressure = input.aquiferInjectTopPressure;

	}

	public void Build() {

		double pipeScalingPrd; // used for fitting pipe to MCcase simulation
                double pipeScalingInj;
		final boolean pumpPresent = true; // variable used for readability

		if (geoThermalGradient == 0 && tempTopProductionAquifer != 0) {
			GeoTemperature = new TnoGeoTemperature(surfaceTemp,
					tempTopProductionAquifer, aquiferTopDepthAtProd);
			geoThermalGradient = GeoTemperature.geoThermalGradient;
		} else {
			GeoTemperature = new TnoGeoTemperature(surfaceTemp,
					geoThermalGradient);
			tempTopProductionAquifer = GeoTemperature
					.TemperatureAt(aquiferTopDepthAtProd);
		}
		tempMidProductionAquifer = GeoTemperature
				.TemperatureAt(aquiferTopDepthAtProd + 0.5 * aquiferThickness);

		// define producer
                pipeScalingPrd =  aquiferTopDepthAtProdBaseCase - aquiferTopDepthAtProd; //should be zero for basecase
		producer = new TnoGeoThermalWell("Producer", pipeScalingPrd, depthSegmentsTVDProd,
				depthSegmentsAHProd, outerDiameterPrd, innerDiameterPrd,
				roughnessPrd, segmentLength, pumpPresent, -pumpDepth,
				pumpPressureDrawDown, pumpMaxRate, pumpEfficiency, skinProducer);

		// define injector
		pipeScalingInj =  aquiferTopDepthAtInjBaseCase - aquiferTopDepthAtInj;
		injector = new TnoGeoThermalWell("Injector", pipeScalingInj, depthSegmentsTVDInj,
				depthSegmentsAHInj, outerDiameterInj, innerDiameterInj, roughnessInj,
				segmentLength, !pumpPresent, 0, 0, 0, 0, skinInjector); // note:
                                                                                        // no
                                                                                        // pump;
                
		// for producer, calculate static BHP = AquiferPresProd
		// use geostatic temperature and salinity distribution
		double dSdZ = aquiferSalinity / aquiferTopDepthAtProd;
		for (int iN = 0; iN < producer.wellTubing.NodesCount; iN++) {
			producer.wellTubing.temperatureNode[iN] = GeoTemperature
					.TemperatureAt(-producer.wellTubing.zNode[iN]); // note: z
											// is
											// negative
			producer.wellTubing.salinityNode[iN] = -dSdZ
					* producer.wellTubing.zNode[iN]; // note: z is negative
		}
		if (aquiferProductTopPressure == 0) {
			producer.wellTubing.CalcPressuresAlongPipe(0,
					1.0 * TnoUnits.Bar_SI, 0, 0, PipeCalcDirection.BeginToEnd,
					PipeTempCalcMethod.Explicit); // initial pressure is 1 bar
			aquiferStaticPresProd = producer.wellTubing.pressureNode[producer.wellTubing.NodesCount - 1];// calculate
			// static
			// BHP
			// =
			// AquiferPresInj
		} else {
			aquiferStaticPresProd = aquiferProductTopPressure;
		}
		// for injector, calculate static BHP = AquiferPresInj
		// use geostatic temperature and salinity distribution
		for (int iN = 0; iN < injector.wellTubing.NodesCount; iN++) {
			injector.wellTubing.temperatureNode[iN] = GeoTemperature
					.TemperatureAt(-injector.wellTubing.zNode[iN]); // note: z
                                                                                        // is
                                                                                        // negative
			injector.wellTubing.salinityNode[iN] = -dSdZ
					* injector.wellTubing.zNode[iN];
		}
		if (aquiferInjectTopPressure == 0) {
			injector.wellTubing.CalcPressuresAlongPipe(0,
					1.0 * TnoUnits.Bar_SI, 0, 0, PipeCalcDirection.BeginToEnd,
					PipeTempCalcMethod.Explicit);
			aquiferStaticPresInj = injector.wellTubing.pressureNode[injector.wellTubing.NodesCount - 1];
		} else{
			aquiferStaticPresInj = aquiferInjectTopPressure;
		}

                // printout for debugging
//                System.out.println("producer");
//                System.out.println("depth pressure density temp salinity");
//                for (int i=0; i<producer.wellTubing.NodesCount; i++){
//                    System.out.println(producer.wellTubing.zNode[i] + " " +
//                            producer.wellTubing.pressureNode[i] + " " +
//                            producer.wellTubing.densityNode[i] + " " +
//                            producer.wellTubing.temperatureNode[i]+ " " +
//                            producer.wellTubing.salinityNode[i]);
//                }
  
                //save hydrostatic data
                producer.saveHydrostatic();
                injector.saveHydrostatic();


		for (int iN = 0; iN < producer.wellTubing.NodesCount; iN++) {
                        producer.wellTubing.tempEnvironmentNode[iN] = GeoTemperature
					.TemperatureAt(-producer.wellTubing.zNode[iN]);
			producer.wellTubing.salinityNode[iN] = aquiferSalinity;
		}

		for (int iN = 0; iN < injector.wellTubing.NodesCount; iN++) {
                        injector.wellTubing.tempEnvironmentNode[iN] = GeoTemperature
					.TemperatureAt(-injector.wellTubing.zNode[iN]);
			injector.wellTubing.salinityNode[iN] = aquiferSalinity;
		}

	}

	public double CalcMassRate(double pumpPressureDiff) {

		final double tolerance = 10; // tolerance on Newton Rapson; max pressure
		// residue (Pa)

		double qk, qkm1, qkm2; // pres @ k, k-1, and k-2
		double funckm1, funckm2; // func @ k-1, and k-2
		double dFuncDq; // derivative of func w.r.t. q

		// solve q (mass) from func(q) = CalcRoundPressureResidue(q) = 0
		// to solve for func(p) = 0, use Newton Rapson:
		// q[k] = q[k-1] - func(q[k-1])/func'(q[k-1])
		// where func'(q[k-1]) = (func(q[k-1]) - func(q[k-2])/(q[k-1]) - q[k-2])

		// calculate first estimate of q
		// using rule of thumb that sum of pressure losses in skins and aquifer
		// (dpWellsAquifer)
		// are about 80% of pump pressure

		// calculate dp = sum of pressure drop for producer and injector for
		// rate of 1 kg/s
		double rateMass = 1.0;
		double density;
		double viscosity;
		double dpWellsToAquifer = 0.0;

		density = TnoWaterProperties.Density(aquiferStaticPresProd,
				tempTopProductionAquifer, aquiferSalinity);
		viscosity = TnoWaterProperties.Viscosity(aquiferStaticPresProd,
				tempTopProductionAquifer, aquiferSalinity);
		dpWellsToAquifer = producer.DpWellAquifer(rateMass / density,
				getAquiferKHnet(), distanceWellsAtAquifer, viscosity);

		density = TnoWaterProperties.Density(aquiferStaticPresInj,
				exitTempHeatExchanger, aquiferSalinity);
		viscosity = TnoWaterProperties.Viscosity(aquiferStaticPresInj,
				exitTempHeatExchanger, aquiferSalinity);
		dpWellsToAquifer += injector.DpWellAquifer(rateMass / density,
				getAquiferKHnet(), distanceWellsAtAquifer, viscosity);

		// hence, first estimate:
		qk = 0.80 * pumpPressureDiff / dpWellsToAquifer;

		// we need func(q) at a previous estimate, use for previous estimate 99%
		// of best estimate
		qkm1 = qk * 0.99;
		funckm1 = CalcPressureBalance(qkm1, pumpPressureDiff);

		boolean converged = false;
		int k = 0;
		while (!converged) {
			k++;
			// catch if not converting
			if (k > 100) {
				TnoGeoThermalProject.notConverging = true;
				break;
			}

			qkm2 = qkm1;
			funckm2 = funckm1;
			qkm1 = qk;
			funckm1 = CalcPressureBalance(qkm1, pumpPressureDiff);

			dFuncDq = (funckm2 - funckm1) / (qkm2 - qkm1);
			qk = qkm1 - funckm1 / dFuncDq;

			if (qk <= 0) {
				qk = 0.5 * qkm1;
			}

			converged = Math.abs(funckm1) < tolerance;
		}

		// get final pressures at solution
		CalcPressureBalance(qk, pumpPressureDiff);

		// save solution
		qmass = qk;

		return qk;
	}

	private double CalcPressureBalance(double rateMass, double pumpPressure) {
		double dp, dT;
		double presAtNode = 0;
		double tempAtNode = 0;
		int iDoubletNode = 0;

		// start pressure round with pressure and temperature of aquifer at
		// producer
		presAtNode += aquiferStaticPresProd;
		tempAtNode += tempMidProductionAquifer;
		presAlongDoublet[iDoubletNode] = presAtNode;
		tempAlongDoublet[iDoubletNode] = tempAtNode;
		iDoubletNode++;

		// add pressure and temperature difference aquifer-->producer
		double density = TnoWaterProperties.Density(presAtNode,
				tempTopProductionAquifer, aquiferSalinity);
		double viscosity = TnoWaterProperties.Viscosity(presAtNode,
				tempTopProductionAquifer, aquiferSalinity);
		dp = -producer.DpWellAquifer(rateMass / density, getAquiferKHnet(),
				distanceWellsAtAquifer, viscosity);
		dT = 0; // no temperature difference in aquifer
		presAtNode += dp;
		tempAtNode += dT;
		presAlongDoublet[iDoubletNode] = presAtNode;
		tempAlongDoublet[iDoubletNode] = tempAtNode;
		iDoubletNode++;

                // add pressure and temperature difference in tubing producer
		producer.wellTubing.CalcPressuresAlongPipe(-rateMass, presAtNode,
				tempAtNode, pumpPressure, PipeCalcDirection.EndToBegin,
				tempCalcOptionProducer);
		dp = -producer.wellTubing.DpTotal;
		dT = -producer.wellTubing.DTTotal;
		presAtNode += dp;
		tempAtNode += dT;
		presAlongDoublet[iDoubletNode] = presAtNode; 
		tempAlongDoublet[iDoubletNode] = tempAtNode;
		iDoubletNode++;

		// add pressure and temperature difference in heat exchanger
		dp = 0; // no pressured rop over heatexhanger
		dT = exitTempHeatExchanger - tempAtNode; // Exit temperature of heat
		// exchanger is set by user
		presAtNode += dp;
		tempAtNode += dT;
		presAlongDoublet[iDoubletNode] = presAtNode;
		tempAlongDoublet[iDoubletNode] = tempAtNode;
		iDoubletNode++;

		// add pressure and temperature difference in tubing injector
		injector.wellTubing.CalcPressuresAlongPipe(rateMass, presAtNode,
				tempAtNode, pumpPressure, PipeCalcDirection.BeginToEnd,
				tempCalcOptionInjector);
		dp = injector.wellTubing.DpTotal;
		dT = injector.wellTubing.DTTotal;
		presAtNode += dp;
		tempAtNode += dT;
		presAlongDoublet[iDoubletNode] = presAtNode;
		tempAlongDoublet[iDoubletNode] = tempAtNode;
		iDoubletNode++;

		// add pressure and temperature difference injector-->aquifer
		density = TnoWaterProperties.Density(presAtNode, tempAtNode,
				aquiferSalinity);
		viscosity = TnoWaterProperties.Viscosity(presAtNode,
				tempAtNode, aquiferSalinity);
		dp = -injector.DpWellAquifer(rateMass / density, getAquiferKHnet(),
				distanceWellsAtAquifer, viscosity);
		dT = tempMidProductionAquifer - tempAtNode;
		presAtNode += dp;
		tempAtNode += dT;
		presAlongDoublet[iDoubletNode] = presAtNode;
		tempAlongDoublet[iDoubletNode] = tempAtNode;
		iDoubletNode++;
//                System.out.println("inj density " + density + " viscosity " + viscosity + " dp " + dp + " rate " + rateMass);

		// substract static pressure aquifer at injector for pressure balance
		dp = -aquiferStaticPresInj;
		dT = 0;
		presAtNode += dp;
		tempAtNode += dT;
		presAlongDoublet[iDoubletNode] = presAtNode;
		tempAlongDoublet[iDoubletNode] = tempAtNode;
		iDoubletNode++;

		return presAtNode; // this is equal to the Pressure Balance

	}

	public void CalcPowerData() {
		double P = producer.wellTubing.pressureNode[0];
		double Tentry = producer.wellTubing.temperatureNode[0];
		double S = producer.wellTubing.salinityNode[0];
		double Texit = exitTempHeatExchanger;

		double cp = TnoWaterProperties.HeatCapacity(P, Tentry, S);
		geoThermalPower = qmass * cp * (Tentry - Texit);
		heatcapacity = cp;
		deltaT = Tentry - Texit;

		int iPumpNode1 = producer.wellTubing.PumpSegment;
		int iPumpNode2 = iPumpNode1 + 1;

		double densProductAvg = 0.5 * (producer.wellTubing.densityNode[iPumpNode1] + producer.wellTubing.densityNode[iPumpNode2]);
		double qVolPump = qmass / densProductAvg;
		productDensity = densProductAvg;

		pumpPower = qVolPump * pumpPressureDrawDown / pumpEfficiency;

		coP = geoThermalPower / pumpPower;

	}

        private static double[] cloneDoubleArray(double[] inputList){

		int length = inputList.length;
		double[] outputList = new double[length];
		for (int i=0; i<length; i++){
			outputList[i] = inputList[i];
		}
		return outputList;
	}
        
	public TnoDoublet Clone() {
		
		TnoDoublet c = new TnoDoublet();
		c.producer = this.producer;
		c.injector = this.injector;
		c.nodeNamesAlongDoublet = this.nodeNamesAlongDoublet;
		c.pressNodeTopInj = this.pressNodeTopInj;
		c.presAlongDoublet = cloneDoubleArray(this.presAlongDoublet);
		c.tempAlongDoublet = cloneDoubleArray(this.tempAlongDoublet);
		c.name = this.name;
		c.idnumber = this.idnumber;
		c.aquiferTopDepthAtProd = this.aquiferTopDepthAtProd;
                c.aquiferTopDepthAtProdBaseCase = this.aquiferTopDepthAtProdBaseCase;
		c.aquiferTopDepthAtInj = this.aquiferTopDepthAtInj;
                c.aquiferTopDepthAtInjBaseCase = this.aquiferTopDepthAtInjBaseCase;
		c.aquiferThickness = this.aquiferThickness;
		c.aquiferNtG = this.aquiferNtG;
		c.aquiferK = this.aquiferK;
		c.aquiferThickness = this.aquiferThickness;
		c.aquiferSalinity = this.aquiferSalinity;
		c.aquiferStaticPresProd = this.aquiferStaticPresProd;
		c.aquiferStaticPresInj = this.aquiferStaticPresInj;
		c.GeoTemperature = this.GeoTemperature;
		c.surfaceTemp = this.surfaceTemp;
		c.geoThermalGradient = this.geoThermalGradient;
		c.exitTempHeatExchanger = this.exitTempHeatExchanger;
		c.tempTopProductionAquifer = this.tempTopProductionAquifer;
		c.tempMidProductionAquifer = this.tempMidProductionAquifer;
		c.tempCalcOptionProducer = this.tempCalcOptionProducer;
		c.tempCalcOptionInjector = this.tempCalcOptionInjector;
		c.distanceWellsAtAquifer = this.distanceWellsAtAquifer;
		c.depthSegmentsTVDProd = this.depthSegmentsTVDProd;
		c.depthSegmentsTVDInj = this.depthSegmentsTVDInj;
		c.segmentLength = this.segmentLength;
		c.outerDiameterInj = this.outerDiameterInj;
		c.innerDiameterInj = this.innerDiameterInj;
		c.roughnessInj = this.roughnessInj;
		c.outerDiameterPrd = this.outerDiameterPrd;
		c.innerDiameterPrd = this.innerDiameterPrd;
		c.roughnessPrd = this.roughnessPrd;
		c.skinProducer = this.skinProducer;
		c.skinInjector = this.skinInjector;
		c.pumpDepth = this.pumpDepth;
		c.pumpPressureDrawDown = this.pumpPressureDrawDown;
		c.pumpMaxRate = this.pumpMaxRate;
		c.pumpEfficiency = this.pumpEfficiency;
		c.geoThermalPower = this.geoThermalPower;
		c.coP = this.coP;
		c.pumpPower = this.pumpPower;
		c.qmass = this.qmass;
		c.aquiferKHnet = this.aquiferKHnet;
		c.qvolPump = this.qvolPump;
		c.productDensity = this.productDensity;
		c.heatcapacity = this.heatcapacity;
		c.deltaT = this.deltaT;
		c.depthSegmentsAHProd = this.depthSegmentsAHProd;
		c.depthSegmentsAHInj = this.depthSegmentsAHInj;
		c.geothermalPowerYears = new double [this.geothermalPowerYears.length];
        for (int i= 0; i< this.geothermalPowerYears.length; i++)
        {
            c.geothermalPowerYears[i] = this.geoThermalPower*1e-6;
        }
		return c;
	}

}
