package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *         (c) 2009 TNO
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html         
 * 
 */

class TnoGeoTemperature {

	private double surfaceTemp; // (degC)
	public double geoThermalGradient; // (degC/m)

	public TnoGeoTemperature(double surfTemp, double tempGradient) {
		surfaceTemp = surfTemp;
		geoThermalGradient = tempGradient;
	}

	public TnoGeoTemperature(double surfTemp, double tempAtDepth, double depth) {
		surfaceTemp = surfTemp;
		geoThermalGradient = (tempAtDepth - surfTemp) / depth;
	}

	public double getSurfaceTemp() {
		return surfaceTemp;
	}

	public void setSurfaceTemp(double surfaceTemp) {
		this.surfaceTemp = surfaceTemp;
	}

	public double getGeoThermalGradient() {
		return geoThermalGradient;
	}

	public void setGeoThermalGradient(double geoThermalGradient) {
		this.geoThermalGradient = geoThermalGradient;
	}

	public double TemperatureAt(double depth) {
		return surfaceTemp + depth * geoThermalGradient;
	}

}
