package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import java.awt.Frame;
import java.util.ArrayList;

import tno.geoenergy.doubletcalc.stochastic.TnoMyStochasticObjects;
import tno.geoenergy.doubletcalc.stochastic.TnoRunControl;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerTS;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerVar;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticVariable;
import javax.swing.JOptionPane;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularVariable;

public class TnoGeoThermalProject {

	TnoInputWindowData input = new TnoInputWindowData();

	public TnoDoublet doublet = new TnoDoublet();

	public static float progress;

	public String Name;

	public static boolean notConverging;

	public TnoGeoThermalProject() {
		Name = input.name;
		doublet.LoadDataFromInput(input);// load input data into doublet
	}

	public TnoGeoThermalProject(TnoInputWindowData inputSpecified) {

		input = inputSpecified;
		Name = input.name;

		doublet.LoadDataFromInput(input);// load input data into doublet
	}
	
	private static double[] cloneDoubleArray(double[] inputList){
		
		int length = inputList.length;
		double[] outputList = new double[length];
		for (int i=0; i<length; i++){
			outputList[i] = inputList[i];
		}
		return outputList;
	}
	
	private static String[] cloneStringArray(String[] inputList){
		
		int length = inputList.length;
		String[] outputList = new String[length];
		for (int i=0; i<length; i++){
			outputList[i] = inputList[i];
		}
		return outputList;
	}



	public static void getWarning() {
            if (!TnoRunControl.BATCH) {
                Frame frame = new Frame();
                JOptionPane.showMessageDialog(
                    frame,
                    "Iteration is not converging. Please choose other input values!",
                    "Warning", JOptionPane.WARNING_MESSAGE);
            } else {
                System.out.println("Iteration is not converging. Please choose other input values! ");
            }
        }

        
	
	public ResultSet calculate() {
		notConverging = false;

		TnoRunControl.numSamples = input.numberOfSimulations;

		TnoStochasticContainerTS.initializeRunAllStochastics(
				TnoRunControl.numSamples, TnoRunControl.numYears);
		TnoStochasticContainerVar
				.initializeRunAllStochastics(TnoRunControl.numSamples);
		doublet.geothermalPowerYears = new double[TnoRunControl.numYears];

		TnoStochasticVariable AquiferK_Stoch = input.aquiferK;
		TnoStochasticVariable AquiferThickness_Stoch = input.aquiferThickness;
		TnoStochasticVariable AquiferNtG_Stoch = input.aquiferNtG;
		TnoStochasticVariable AquiferTopAtProd_Stoch = input.aquiferTopDepthAtProd;
		TnoStochasticVariable AquiferTopAtInj_Stoch = input.aquiferTopDepthAtInj;
		TnoStochasticVariable AquiferSalinity_Stoch = input.aquiferSalinity;


		// ==== Base Case ====

		doublet.aquiferK = AquiferK_Stoch.getDistribution().getMedian();
		doublet.aquiferThickness = AquiferThickness_Stoch.getDistribution()
				.getMedian();
		doublet.aquiferNtG = AquiferNtG_Stoch.getDistribution().getMedian();
		doublet.aquiferTopDepthAtProd = AquiferTopAtProd_Stoch
				.getDistribution().getMedian();
		doublet.aquiferTopDepthAtInj = AquiferTopAtInj_Stoch.getDistribution()
				.getMedian();
		doublet.aquiferSalinity = AquiferSalinity_Stoch.getDistribution()
		.getMedian();
                doublet.aquiferTopDepthAtProdBaseCase = AquiferTopAtProd_Stoch.getDistribution().getMedian();
                doublet.aquiferTopDepthAtInjBaseCase = AquiferTopAtInj_Stoch.getDistribution().getMedian();
                
		doublet.name = "Base Case";
		doublet.idnumber = -1;
		doublet.Build();
		if (notConverging) {
			getWarning();
			return null;
		}

                

		doublet.CalcMassRate(doublet.pumpPressureDrawDown);
		if (notConverging) {
			getWarning();
			return null;
		}

		doublet.CalcPowerData();
		
		TnoDoublet baseCase = doublet.Clone();

                ResultSet resultSet = new ResultSet();
		// store base case scenario in result set
		TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_AQUIFER_KH)
				.setValue(
						(float) (AquiferK_Stoch.getDistribution().getMedian()
								* AquiferThickness_Stoch.getDistribution()
										.getMedian()
								* AquiferNtG_Stoch.getDistribution()
										.getMedian() * TnoUnits.SI_Darcy));
		
		
		// store base case in ResultSet
                resultSet.hydrostaticProducer = baseCase.producer.hydrostatic;
                resultSet.hydrostaticInjector = baseCase.injector.hydrostatic;
		resultSet.baseCaseProducerPipe = baseCase.producer.wellTubing;
		resultSet.baseCaseInjectorPipe = baseCase.injector.wellTubing;
		resultSet.doubletNodes = cloneStringArray(baseCase.nodeNamesAlongDoublet);
		resultSet.baseCaseTemperatureAlongDoublet = cloneDoubleArray( baseCase.tempAlongDoublet);
		resultSet.baseCasePressureAlongDoublet = cloneDoubleArray(baseCase.presAlongDoublet);
		
		
		TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_QMASS)
				.setValue((float) baseCase.qmass);
		TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_PUMP_QVOL)
				.setValue((float) (-baseCase.getQvolPump() * 3600)); // m3/h
		TnoSingularContainer.find(
				TnoMyStochasticObjects.BASECASE_PUMP_POWER_REQUIRED).setValue(
				(float) (baseCase.getPumpPower() / 1e3)); // kW
		TnoSingularContainer.find(
				TnoMyStochasticObjects.BASECASE_GEOTHERMAL_POWERS).setValue(
				(float) (baseCase.getGeoThermalPower() / 1e6));
		TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_COP)
				.setValue((float) (baseCase.coP));

                TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_AQP_PRD)
				.setValue((float) (baseCase.presAlongDoublet[0]));
                TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_AQP_INJ)
				.setValue((float) (baseCase.presAlongDoublet[5]));
                TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_DP_PRD)
				.setValue((float) (baseCase.presAlongDoublet[0] - baseCase.presAlongDoublet[1]));
                TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_DP_INJ)
				.setValue((float) (baseCase.presAlongDoublet[4] - baseCase.presAlongDoublet[5]));
                TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_AQT_PRD)
				.setValue((float) (baseCase.tempMidProductionAquifer));
                TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_T_HE)
				.setValue((float) (baseCase.tempAlongDoublet[2]));
                TnoSingularContainer.find(TnoMyStochasticObjects.BASECASE_P_HE)
				.setValue((float) (baseCase.presAlongDoublet[2]));

		if (TnoRunControl.runMCetc) {

			// ==== Monte Carlo Cases ====

			int monteCarloSimulations = input.numberOfSimulations;
			int mcCasesCount = monteCarloSimulations; // first scenario will
			// have CDF=1.0, last
			// CDF=0.0

			ArrayList<TnoDoublet> mcCases = new ArrayList<TnoDoublet>();

			for (int iCase = 0; iCase < mcCasesCount; iCase++) {

				doublet.aquiferK = AquiferK_Stoch.NextValue(iCase);
				doublet.aquiferThickness = AquiferThickness_Stoch
						.NextValue(iCase);
				doublet.aquiferNtG = AquiferNtG_Stoch.NextValue(iCase);
				doublet.aquiferTopDepthAtProd = AquiferTopAtProd_Stoch
						.NextValue(iCase);
				doublet.aquiferTopDepthAtInj = AquiferTopAtInj_Stoch
						.NextValue(iCase);
				doublet.aquiferSalinity = AquiferSalinity_Stoch
						.NextValue(iCase);
			
				doublet.name = String.format("Monte Carlo Case {"+ iCase +
                                                "}: K={"+ doublet.aquiferK +
                                                "}, T={" + doublet.aquiferThickness +
                                                "}, NtG={" + doublet.aquiferNtG +
                                                "}, ProdDepth={" + doublet.aquiferTopDepthAtProd +
                                                "}, InjDepth={" + doublet.aquiferTopDepthAtInj+
                                                "}, Salinity={" + doublet.aquiferSalinity +"}");

				doublet.idnumber = iCase;

				doublet.Build();
				if (notConverging) {
					getWarning();
					return null;
				}

				doublet.CalcMassRate(doublet.pumpPressureDrawDown);
				if (notConverging) {
					getWarning();
					return null;
				}

				doublet.CalcPowerData();
				mcCases.add(doublet.Clone());

				
			}

			// save data
			
			saveMcCases(mcCasesCount, mcCases);
			
			/*
			Arrays.sort(powers);
			Arrays.sort(cop);
			Arrays.sort(qVolPump);
			Arrays.sort(pumpPowers);
			Arrays.sort(aquiferKHnets);
			Arrays.sort(qmasses);
			*/

                        if (TnoRunControl.runFingerPrinting){

                            // ==== pump cases / fingerprinting ====

                            double pumpPressureStart = input.getPumpPressureDrawDown() * 0.33; // 33%
                            if (pumpPressureStart < 10e5)
                                    pumpPressureStart = 10e5; // minimum 10 bar
                            double pumpPressureEnd = input.getPumpPressureDrawDown() * 1.5; // 150%
                            if (pumpPressureEnd < 15e5)
                                    pumpPressureEnd = 15e5; // minimum 15 bar
                            double pumpPressureStep = (pumpPressureEnd - pumpPressureStart) / 100; // 1
                            // bar

                            int pumpCasesCount = (int) Math
                                            .round((pumpPressureEnd - pumpPressureStart)
                                                            / pumpPressureStep) + 1;
                            pumpPressureStep = (pumpPressureEnd - pumpPressureStart)
                                            / (pumpCasesCount - 1);

                            ArrayList<TnoDoublet> pumpCases = new ArrayList<TnoDoublet>();

                            doublet = baseCase.Clone();
                            for (int iCase = 0; iCase < pumpCasesCount; iCase++) {

                                    doublet.pumpPressureDrawDown = pumpPressureStart + iCase
                                                    * pumpPressureStep;
                                    doublet.name = String.format("Pump Case {0}: P={1}", iCase,
                                                    doublet.pumpPressureDrawDown * TnoUnits.SI_Bar);
                                    doublet.idnumber = iCase;
    //                                doublet.aquiferTopDepthAtProd = AquiferTopAtProd_Stoch.getDistribution().getMedian();
    //                                doublet.aquiferTopDepthAtInj = AquiferTopAtInj_Stoch.getDistribution().getMedian();
                                    doublet.Build();
                                    doublet.CalcMassRate(doublet.pumpPressureDrawDown);
                                    doublet.CalcPowerData();
                                    pumpCases.add(doublet.Clone());
                            }

                            //int maxIndex = powers.length;

                            int maxIndex = pumpCases.size();
                            resultSet.conditionPumpCaseArrays(maxIndex);

                            // transfer to ResultSet

                            for (int index = 0; index < maxIndex; index++) {
                                    resultSet.pumpCasePumpPowers[index] = (float) pumpCases.get(
                                                    index).getPumpPower() * 1e-3f;
                                    resultSet.pumpCaseQvolPumps[index] = -(float) pumpCases.get(
                                                    index).getQvolPump() * 3600;
                                    resultSet.pumpCaseGeoThermalPowers[index] = (float) pumpCases
                                                    .get(index).getGeoThermalPower() * 1e-6f;
                                    resultSet.pumpCasePressureDrawdowns[index] = (float) (pumpCases
                                                    .get(index).getPumpPressureDrawDown() * TnoUnits.SI_Bar);
                                    resultSet.pumpCaseCops[index] = (float) pumpCases.get(index)
                                                    .getCoP();

                            }
			
                        }

		}

		return resultSet;
	}

	public void saveMcCases(int mcCasesCount, ArrayList<TnoDoublet> mcCases){
		
		// save data
		double[] powers = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.GEOTHERMAL_POWERS).getRealisations();
		double[] cop = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.COP).getRealisations();
		double[] qVolPump = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.PUMP_QVOL).getRealisations();
		double[] pumpPowers = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.PUMP_POWER_REQUIRED)
				.getRealisations();
		double[] aquiferKHnets = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.AQUIFER_KH).getRealisations();
		double[] qmasses = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.QMASS).getRealisations();
		double[] pdensities = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.PRODUCT_DENSITY).getRealisations();
		double[] heatcapacities = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.HEAT_CAPACITY).getRealisations();
		double[] deltaTemp = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.DELTA_T).getRealisations();

                double[] aquiferpProd = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.AQP_PRD).getRealisations();
                double[] aquiferpInj = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.AQP_INJ).getRealisations();
                double[] dpProd = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.DP_PRD).getRealisations();
                double[] dpInj = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.DP_INJ).getRealisations();
                double[] aquifertProd = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.AQT_PRD).getRealisations();
                double[] tHeatEx = TnoStochasticContainerVar.find(
				TnoMyStochasticObjects.T_HE).getRealisations();
                double[] pHeatEx = TnoStochasticContainerVar.find(
                                TnoMyStochasticObjects.P_HE).getRealisations();


		for (int iCase = 0; iCase < mcCasesCount; iCase++) {
			powers[iCase] = mcCases.get(iCase).geoThermalPower * 1e-6;
			cop[iCase] = mcCases.get(iCase).coP;
			qVolPump[iCase] = -mcCases.get(iCase).getQvolPump() * 3600;
			pumpPowers[iCase] = mcCases.get(iCase).getPumpPower() * 1e-3;
			aquiferKHnets[iCase] = mcCases.get(iCase).getAquiferKHnet()
					* TnoUnits.SI_Darcy;
			qmasses[iCase] = mcCases.get(iCase).getQmass();
			pdensities[iCase] = mcCases.get(iCase).getProductDensity();
			heatcapacities[iCase] = mcCases.get(iCase).getHeatCapacity();
			deltaTemp[iCase] = mcCases.get(iCase).getDeltaT();

                        aquiferpProd[iCase] = mcCases.get(iCase).presAlongDoublet[0];
                        aquiferpInj[iCase] = mcCases.get(iCase).presAlongDoublet[5];
                        dpProd[iCase] = mcCases.get(iCase).presAlongDoublet[0] - mcCases.get(iCase).presAlongDoublet[1];
                        dpInj[iCase] = mcCases.get(iCase).presAlongDoublet[4] - mcCases.get(iCase).presAlongDoublet[5];
                        aquifertProd[iCase] = mcCases.get(iCase).tempMidProductionAquifer;
                        tHeatEx[iCase] = mcCases.get(iCase).tempAlongDoublet[2];
                        pHeatEx[iCase] = mcCases.get(iCase).presAlongDoublet[2];
                }
	}
	
}
