package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *         (c) 2009 TNO
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html         
 * 
 */

public class TnoGeoThermalWell {

	public TnoPipe wellTubing;
        public TnoPipe hydrostatic;

	private String name;
	private double outerDiameter; // (m)

	// private double outerRadius { get { return OuterDiameter / 2; } set {
	// OuterDiameter = 2 * value; } } // (m)
	private double skin; // (1)

	double getSkin() {
		return skin;
	}

	void setSkin(double skin) {
		this.skin = skin;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	double getOuterDiameter() {
		return outerDiameter;
	}

	void setOuterDiameter(double outerDiameter) {
		this.outerDiameter = outerDiameter;
	}

	double getOuterRadius() {
		return outerDiameter / 2;
	}

	void setOuterRadius(float value) {
		outerDiameter = 2 * value;
	}

	public TnoGeoThermalWell(String name, double pipeScaling, double[] depthSpec,
			double[] segmentSpec, double outDiamSpec, double[] inDiamSpec,
			double[] roughSpec, double segmentLengthTarget, boolean pumpPresent,
			double pumpZ, double pumpMaxPresDif, double pumpMaxCap,
			double pumpEfficiency, double skinSpec) {
		this.name = name;
		this.skin = skinSpec;
		wellTubing = new TnoPipe(name + "_Tubing", pipeScaling, depthSpec,
				segmentSpec, outDiamSpec, inDiamSpec, roughSpec,
				segmentLengthTarget, pumpPresent, pumpZ, pumpMaxPresDif,
				pumpMaxCap, pumpEfficiency);
                hydrostatic = new TnoPipe();
		outerDiameter = outDiamSpec;
	}
        public void saveHydrostatic(){
            
            hydrostatic = wellTubing.Clone();
        }

	public double DpWellAquifer(double rateVol, double khNet,
			double distanceWells, double viscosity) {

		double dP = rateVol * viscosity
				* (Math.log(distanceWells / getOuterRadius()) + skin)
				/ (2 * Math.PI * khNet);

		return dP;
	}

}
