package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import tno.geoenergy.doubletcalc.stochastic.TnoMyStochasticObjects;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerVar;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticVariable;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;

public class TnoInputWindowData {

	// obsolete? -  variable used in TnoGeoThermalProject, but not set
	public String name;

	public TnoStochasticVariable aquiferTopDepthAtProd = TnoStochasticContainerVar
			.find(TnoMyStochasticObjects.AQUIFER_TOPPRODUCTION); // (mTVDSS)
	public TnoStochasticVariable aquiferTopDepthAtInj = TnoStochasticContainerVar
			.find(TnoMyStochasticObjects.AQUIFER_TOPINJECTION); // (mTVDSS)
	public TnoStochasticVariable aquiferThickness = TnoStochasticContainerVar
			.find(TnoMyStochasticObjects.AQUIFER_THICKNESS); // (m)
	public TnoStochasticVariable aquiferK = TnoStochasticContainerVar
			.find(TnoMyStochasticObjects.AQUIFER_PERMEABILITY); // (m2)
	public TnoStochasticVariable aquiferNtG = TnoStochasticContainerVar
			.find(TnoMyStochasticObjects.AQUIFER_NG); // (1)

	public TnoStochasticVariable aquiferSalinity = TnoStochasticContainerVar.find(
			TnoMyStochasticObjects.AQUIFER_SALINITY); // (ppm)
	
	public double surfaceTemp = TnoSingularContainer.find(
			TnoMyStochasticObjects.TEMPERATURE_SURFACE).getValue(); // (degC)
	public double geoThermalGradient = TnoSingularContainer.find(
			TnoMyStochasticObjects.GEOTHERMAL_GRADIENT).getValue(); // (degC/m)
	public double exitTempHeatExchanger = TnoSingularContainer.find(
			TnoMyStochasticObjects.TEMPERATURE_INJECTION).getValue(); // (degC)
	
	// obsolete? - variable set in TnoDoublet.built()
	public double tempTopProductionAquifer; // (degC)
	public double tempMidProductionAquifer; // (degC)

	public PipeTempCalcMethod tempCalcOptionProducer = PipeTempCalcMethod.Implicit;
	public PipeTempCalcMethod tempCalcOptionInjector = PipeTempCalcMethod.Implicit;

	public double distanceWellsAtAquifer = TnoSingularContainer.find(
			TnoMyStochasticObjects.WELL_DISTANCE).getValue(); // (m)
	public double[] segmentsPrdTVD = TnoSingularContainer.find(
			TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_TVD).getArray(); // (m)
	public double[] segmentsInjTVD = TnoSingularContainer.find(
			TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_TVD).getArray(); // (m)
	public double segmentLength = TnoSingularContainer.find(
			TnoMyStochasticObjects.SEGMENT_LENGTH).getValue(); // (m)
	public double outerDiameterInject = TnoSingularContainer.find(
			TnoMyStochasticObjects.INJ_OUTERDIAMETER).getValue(); // (m)
	public double outerDiameterProduct = TnoSingularContainer.find(
			TnoMyStochasticObjects.PRD_OUTERDIAMETER).getValue(); // (m)
	public double[] innerDiameterInj = TnoSingularContainer.find(
			TnoMyStochasticObjects.INJ_TUBING_DIAMETER).getArray(); // (m)
	public double[] roughnessInj = TnoSingularContainer.find(
			TnoMyStochasticObjects.INJ_TUBING_ROUGHNESS).getArray(); // (m)
	public double[] segmentsInjAH = TnoSingularContainer.find(
			TnoMyStochasticObjects.INJ_TUBING_SEGMENTS_AH).getArray(); // (m)
	public double[] innerDiameterPrd = TnoSingularContainer.find(
			TnoMyStochasticObjects.PRD_TUBING_DIAMETER).getArray(); // (m)
	public double[] roughnessPrd = TnoSingularContainer.find(
			TnoMyStochasticObjects.PRD_TUBING_ROUGHNESS).getArray(); // (m)
	public double[] segmentsPrdAH = TnoSingularContainer.find(
			TnoMyStochasticObjects.PRD_TUBING_SEGMENTS_AH).getArray(); // (m)

	public double skinProducer = TnoSingularContainer.find(
			TnoMyStochasticObjects.TOTAL_SKIN_PRODUCTION).getValue(); // (1)
	public double skinInjector = TnoSingularContainer.find(
			TnoMyStochasticObjects.TOTAL_SKIN_INJECTION).getValue(); // (1)

	public double pumpDepth = TnoSingularContainer.find(
			TnoMyStochasticObjects.PUMP_PRODUCTIONDEPTH).getValue(); // (mTVDSS)
	public double pumpPressureDrawDown = TnoSingularContainer.find(
			TnoMyStochasticObjects.PUMP_PRESSUREDIFFERENCE).getValue(); // (bar)
	public double pumpEfficiency = TnoSingularContainer.find(
			TnoMyStochasticObjects.PUMP_EFFICIENCY).getValue(); // 0 < eff <= 1

	public int numberOfSimulations = (int) TnoSingularContainer.find(
			TnoMyStochasticObjects.SIMULATION_RUNS).getValue();

	public double aquiferProductTopPressure = TnoSingularContainer.find(
			TnoMyStochasticObjects.AQUIFER_PRESSURE_PRODUCTION).getValue();
	public double aquiferInjectTopPressure = TnoSingularContainer.find(
			TnoMyStochasticObjects.AQUIFER_PRESSURE_INJECTION).getValue();
	
	public double aquiferKhKv = TnoSingularContainer.find(
			TnoMyStochasticObjects.KH_KV).getValue();

	
	// getter and setter obsolete? 
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public double getAquiferKhKv() {
		return aquiferKhKv;
	}

	public void setAquiferKhKv(double aquiferKhKv) {
		this.aquiferKhKv = aquiferKhKv;
	}
	
	public TnoStochasticVariable getAquiferTopDepthAtProd() {
		return aquiferTopDepthAtProd;
	}

	public void setAquiferTopDepthAtProd(
			TnoStochasticVariable aquiferTopDepthAtProd) {
		this.aquiferTopDepthAtProd = aquiferTopDepthAtProd;
	}

	public TnoStochasticVariable getAquiferTopDepthAtInj() {
		return aquiferTopDepthAtInj;
	}

	public void setAquiferTopDepthAtInj(
			TnoStochasticVariable aquiferTopDepthAtInj) {
		this.aquiferTopDepthAtInj = aquiferTopDepthAtInj;
	}

	public TnoStochasticVariable getAquiferThickness() {
		return aquiferThickness;
	}

	public void setAquiferThickness(TnoStochasticVariable aquiferThickness) {
		this.aquiferThickness = aquiferThickness;
	}

	public TnoStochasticVariable getAquiferK() {
		return aquiferK;
	}

	public void setAquiferK(TnoStochasticVariable aquiferK) {
		this.aquiferK = aquiferK;
	}

	public TnoStochasticVariable getAquiferNtG() {
		return aquiferNtG;
	}

	public void setAquiferNtG(TnoStochasticVariable aquiferNtG) {
		this.aquiferNtG = aquiferNtG;
	}

	public TnoStochasticVariable getAquiferSalinity() {
		return aquiferSalinity;
	}

	public void setAquiferSalinity(TnoStochasticVariable aquiferSalinity) {
		this.aquiferSalinity = aquiferSalinity;
	}


	public double getSurfaceTemp() {
		return surfaceTemp;
	}

	public void setSurfaceTemp(double surfaceTemp) {
		this.surfaceTemp = surfaceTemp;
	}

	public double getGeoThermalGradient() {
		return geoThermalGradient;
	}

	public void setGeoThermalGradient(double geoThermalGradient) {
		this.geoThermalGradient = geoThermalGradient;
	}

	public double getExitTempHeatExchanger() {
		return exitTempHeatExchanger;
	}

	public void setExitTempHeatExchanger(double exitTempHeatExchanger) {
		this.exitTempHeatExchanger = exitTempHeatExchanger;
	}

	public double getTempTopProductionAquifer() {
		return tempTopProductionAquifer;
	}

	public void setTempTopProductionAquifer(double tempTopProductionAquifer) {
		this.tempTopProductionAquifer = tempTopProductionAquifer;
	}

	public double getTempMidProductionAquifer() {
		return tempMidProductionAquifer;
	}

	public void setTempMidProductionAquifer(double tempMidProductionAquifer) {
		this.tempMidProductionAquifer = tempMidProductionAquifer;
	}

	public PipeTempCalcMethod getTempCalcOptionProducer() {
		return tempCalcOptionProducer;
	}

	public void setTempCalcOptionProducer(
			PipeTempCalcMethod tempCalcOptionProducer) {
		this.tempCalcOptionProducer = tempCalcOptionProducer;
	}

	public PipeTempCalcMethod getTempCalcOptionInjector() {
		return tempCalcOptionInjector;
	}

	public void setTempCalcOptionInjector(
			PipeTempCalcMethod tempCalcOptionInjector) {
		this.tempCalcOptionInjector = tempCalcOptionInjector;
	}

	public double getDistanceWellsAtAquifer() {
		return distanceWellsAtAquifer;
	}

	public void setDistanceWellsAtAquifer(double distanceWellsAtAquifer) {
		this.distanceWellsAtAquifer = distanceWellsAtAquifer;
	}

	public double[] getSegmentsPrdTVD() {
		return segmentsPrdTVD;
	}

	public void setSegmentsPrdTVD(double[] TVDPrd) {
		this.segmentsPrdTVD = TVDPrd;
	}

	public double[] getSegmentsInjTVD() {
		return segmentsInjTVD;
	}

	public void setSegmentsInjTVD(double[] TVDInj) {
		this.segmentsInjTVD = TVDInj;
	}

	public double getSegmentLength() {
		return segmentLength;
	}

	public void setSegmentLength(double segmentLength) {
		this.segmentLength = segmentLength;
	}

	public double getOuterDiameterInj() {
		return outerDiameterInject;
	}

	public void setOuterDiameterInj(double outerDiameterInject) {
		this.outerDiameterInject = outerDiameterInject;
	}
	
	public double getOuterDiameterPrd() {
		return outerDiameterProduct;
	}

	public void setOuterDiameterPrd(double outerDiameterProduct) {
		this.outerDiameterProduct = outerDiameterProduct;
	}

	public double[] getInnerDiameterInj() {
		return innerDiameterInj;
	}

	public void setInnerDiameterInj(double[] innerDiameterInj) {
		this.innerDiameterInj = innerDiameterInj;
	}

	public double[] getRoughnessInj() {
		return roughnessInj;
	}

	public void setRoughnessInj(double[] roughnessInj) {
		this.roughnessInj = roughnessInj;
	}
	public double[] getSegmentsInj() {
		return segmentsInjAH;
	}

	public void setSegmentsInj(double[] segmentsInj) {
		this.segmentsInjAH = segmentsInj;
	}
	
	public double[] getInnerDiameterPrd() {
		return innerDiameterPrd;
	}

	public void setInnerDiameter(double[] innerDiameterPrd) {
		this.innerDiameterPrd = innerDiameterPrd;
	}

	public double[] getRoughnessPrd() {
		return roughnessPrd;
	}

	public void setRoughnessPrd(double[] roughnessPrd) {
		this.roughnessPrd = roughnessPrd;
	}
	public double[] getSegmentsPrd() {
		return segmentsPrdAH;
	}

	public void setSegmentsPrd(double[] segmentsPrd) {
		this.segmentsPrdAH = segmentsPrd;
	}
	
	
	public double getSkinProducer() {
		return skinProducer;
	}

	public void setSkinProducer(double skinProducer) {
		this.skinProducer = skinProducer;
	}

	public double getSkinInjector() {
		return skinInjector;
	}

	public void setSkinInjector(double skinInjector) {
		this.skinInjector = skinInjector;
	}

	public double getPumpDepth() {
		return pumpDepth;
	}

	public void setPumpDepth(double pumpDepth) {
		this.pumpDepth = pumpDepth;
	}

	public double getPumpPressureDrawDown() {
		return pumpPressureDrawDown;
	}

	public void setPumpPressureDrawDown(double pumpPressureDrawDown) {
		this.pumpPressureDrawDown = pumpPressureDrawDown;
	}

	public double getPumpEfficiency() {
		return pumpEfficiency;
	}

	public void setPumpEfficiency(double pumpEfficiency) {
		this.pumpEfficiency = pumpEfficiency;
	}

	public void setNumberOfSimulations(int num) {
		numberOfSimulations = num;
	}

	public int getNumberOfSimulations() {
		return numberOfSimulations;
	}

	public void setAquiferProductTopPressure(double pressure) {
		this.aquiferProductTopPressure = pressure;
	}

	public double getAquiferProductTopPressure() {
		return this.aquiferProductTopPressure;
	}

	public void setAquiferInjectTopPressure(double pressure) {
		this.aquiferInjectTopPressure = pressure;
	}

	public double getAquiferInjectTopPressure() {
		return this.aquiferInjectTopPressure;
	}

	public TnoInputWindowData Clone() {
		TnoInputWindowData c = new TnoInputWindowData();
		c.name = this.name;
		c.aquiferTopDepthAtProd = this.aquiferTopDepthAtProd;
		c.aquiferTopDepthAtInj = this.aquiferTopDepthAtInj;
		c.aquiferThickness = this.aquiferThickness;
		c.aquiferNtG = this.aquiferNtG;
		c.aquiferK = this.aquiferK;
		c.aquiferSalinity = this.aquiferSalinity;
		c.surfaceTemp = this.surfaceTemp;
		c.geoThermalGradient = this.geoThermalGradient;
		c.exitTempHeatExchanger = this.exitTempHeatExchanger;
		c.tempTopProductionAquifer = this.tempTopProductionAquifer;
		c.tempMidProductionAquifer = this.tempMidProductionAquifer;
		c.tempCalcOptionProducer = this.tempCalcOptionProducer;
		c.tempCalcOptionInjector = this.tempCalcOptionInjector;
		c.distanceWellsAtAquifer = this.distanceWellsAtAquifer;
		c.segmentsPrdTVD = this.segmentsPrdTVD;
		c.segmentsInjTVD = this.segmentsInjTVD;
		c.segmentLength = this.segmentLength;
		c.outerDiameterInject = this.outerDiameterInject;
		c.outerDiameterProduct = this.outerDiameterProduct;
		c.innerDiameterInj = this.innerDiameterInj;
		c.roughnessInj = this.roughnessInj;
		c.segmentsInjAH = this.segmentsInjAH;
		c.innerDiameterPrd = this.innerDiameterPrd;
		c.roughnessPrd = this.roughnessPrd;
		c.segmentsPrdAH = this.segmentsPrdAH;
		c.skinProducer = this.skinProducer;
		c.skinInjector = this.skinInjector;
		c.pumpDepth = this.pumpDepth;
		c.pumpPressureDrawDown = this.pumpPressureDrawDown;
		c.pumpEfficiency = this.pumpEfficiency;

		return c;
	}

}
