package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *         (c) 2009 TNO
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html        
 * 
 */

public class TnoUnits {

	public static final double GravConstant = 9.80665; // m/s2 or N/kg 0 - this
														// is exact SI value
	public static final double EulerConstant = 0.57721566490153286060651209008240243104215933593992; // Euler
																										// constant
																										// see
																										// Wikipedia
	public static final double ExpEulerConstant = Math.exp(EulerConstant); // e^eulerConstant

	public static final double SI_Bar = 1e-5; // Pa to Bar - exact
	public static final double Bar_SI = 1e+5; // bar to Pa - exact
	public static final double Atm_SI = 1.01325e5; // Atm to Pa - this is exact
													// SI value
	public static final double Darcy_SI = 1e-12 / 1.01325;
	public static final double SI_Darcy = 1.01325e12;
	public static final double mDarcy_SI = 1e-15 / 1.01325;
	public static final double SI_mDarcy = 1.01325e15;
	public static final double Inch_SI = 0.0254;
	public static final double SI_Inch = 1 / 0.0254;

	public static final double T = 1e+3;
	public static final double G = 1e+6;
	public static final double k = 1e+3;
	public static final double c = 1e-2;
	public static final double m = 1e-3;
	public static final double mu = 1e-6;

}
