package tno.geoenergy.doubletcalc;

/**
 * @author Van Hooff, Kronimus
 * 
 * 
 *         (c) 2009 TNO
 *         
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html         
 * 
 */

public class TnoWaterProperties {

	public static double Density(double P, double T, double S) {
		P = Math.max(P, 1); // min P is 1 Pa
		T = Math.max(T, 0); // min T is 0 degC
		S = Math.max(S, 0); // min S is 0

		// convert to units used in correletation
		P *= 1e-6; // convert from Pa to MPa

		double densityFresh = 1 + 1e-6 * (-80.0 * T - 3.3 * T * T + 0.00175 * T
				* T * T + 489.0 * P - 2.0 * T * P + 0.016 * T * T * P - 1.3e-5
				* T * T * T * P - 0.333 * P * P - 0.002 * T * P * P);
		double density = densityFresh
				+ S
				* (0.668 + 0.44 * S + 1e-6 * (300.0 * P - 2400.0 * P * S + T
						* (80.0 + 3.0 * T - 3300.0 * S - 13.0 * P + 47.0 * P
								* S)));

		density *= 1000.0; // convert from g/cm3 to kg/m3

		return density;
	}

	public static double Viscosity(double P, double T, double S) {
		P = Math.max(P, 1); // min P is 1 Pa
		T = Math.max(T, 0); // min T is 0 degC
		S = Math.max(S, 0); // min S is 0

		// in this correlation viscosity is independent of P
		double viscosity = 0.1
				+ 0.333
				* S
				+ (1.65 + 91.90 * S * S * S)
				* Math
						.exp(-(0.42 * Math.pow((Math.pow(S, 0.8) - 0.17), 2.0) + 0.045)
								* Math.pow(T, 0.8));

		viscosity *= 1e-3; // convert from cP to Pa.s

		return viscosity;
	}

	public static double HeatCapacity(double P, double T, double S) {
		P = Math.max(P, 1); // min P is 1 Pa
		T = Math.max(T, 0); // min T is 0 degC
		S = Math.max(S, 0); // min S is 0

		// Note in this correlation heatcapacity is independent of P

		// convert to units used in correletation
		T += 273.15; // convert from deg C to K
		S *= 1e+3; // convert from fraction (e.g. kg/kg) to g/kg

		double heatCapacity = (5.328 + -9.76e-2 * S + 4.04e-4 * S * S)
				+ (-6.913 * 1e-3 + 7.351 * 1e-4 * S - 3.15 * 1e-6 * S * S) * T
				+ (9.6 * 1e-6 - 1.927 * 1e-6 * S + 8.23e-9 * S * S) * T * T
				+ (2.5 * 1e-9 + 1.666 * 1e-9 * S - 7.125 * 1e-12 * S * S) * T
				* T * T;

		heatCapacity *= 1e+3; // convert from kJ/kg/K to J/kg/K

		return heatCapacity;
	}

}
