package tno.geoenergy.doubletcalc.io.file;

/*
 * CreateXML.fx
*
 * @author Kronimus
 *
 *
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 *
 */

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.System;
import javafx.data.xml.QName;
import javafx.data.pull.PullParser;
import javafx.data.pull.Event;
import javafx.scene.paint.Color;
import java.io.File;
import tno.geoenergy.doubletcalc.io.screen.InputWindow;
import java.io.FileNotFoundException;


/**
 * @author Kronimusra
 */
public def EMPTY: String = "                                                                                                     ";

public class CreateXML {

    public function createXML(filename: File, inp: InputWindow ): Void {

    var bw: BufferedWriter = null;

    //var e: IOException;

    def tab: String = "    ";

    try{

        bw = new BufferedWriter(new FileWriter(filename));

            bw.write('<?xml version="1.0" encoding="UTF-8"?>');
            bw.newLine();
            bw.write("<doublet>");
            bw.newLine();
            bw.write('{tab}<permeabilitymin val="{inp.permeabilityMin}"/>');
            bw.newLine();
            bw.write('{tab}<permeabilitylikely val="{inp.permeabilityLikely}"/>');
            bw.newLine();
            bw.write('{tab}<permeabilitymax val="{inp.permeabilityMax}"/>');
            bw.newLine();
            bw.write('{tab}<thicknessmin val="{inp.thicknessMin}"/>');
            bw.newLine();
            bw.write('{tab}<thicknesslikely val="{inp.thicknessLikely}"/>');
            bw.newLine();
            bw.write('{tab}<thicknessmax val="{inp.thicknessMax}"/>');
            bw.newLine();
            bw.write('{tab}<pressinjtop val="{inp.pressInjTop}"/>');
            bw.newLine();
            bw.write('{tab}<pressprodtop val="{inp.pressProdTop}"/>');
            bw.newLine();
            bw.write('{tab}<temptop val="{inp.tempTop}"/>');
            bw.newLine();
            bw.write('{tab}<salinitymin val="{inp.salinityMin}"/>');
            bw.newLine();
            bw.write('{tab}<salinitylikely val="{inp.salinityLikely}"/>');
            bw.newLine();
            bw.write('{tab}<salinitymax val="{inp.salinityMax}"/>');
            bw.newLine();
            bw.write('{tab}<geothermgradient val="{inp.geothermGradient}"/>');
            bw.newLine();
            bw.write('{tab}<surfacetemp val="{inp.surfaceTemp}"/>');
            bw.newLine();
            bw.write('{tab}<injecttopreservoirdepthlikely val="{inp.injectTopReservoirDepthLikely}"/>');
            bw.newLine();
            bw.write('{tab}<prodtopreservoirdepthlikely val="{inp.prodTopReservoirDepthLikely}"/>');
            bw.newLine();
            bw.write('{tab}<welldistance val="{inp.wellDistance}"/>');
            bw.newLine();
            bw.write('{tab}<pumpefficiency val="{inp.pumpEfficiency}"/>');
            bw.newLine();;
            bw.write('{tab}<welldiameterinjector val="{toString(inp.id)}"/>');
            bw.newLine();
            bw.write('{tab}<welldiameterproducer val="{toString(inp.pd)}"/>');
            bw.newLine();
            bw.write('{tab}<nettogrossmin val="{inp.netToGrossMin}"/>');
            bw.newLine();
            bw.write('{tab}<nettogrosslikely val="{inp.netToGrossLikely}"/>');
            bw.newLine();
            bw.write('{tab}<nettogrossmax val="{inp.netToGrossMax}"/>');
            bw.newLine();
            bw.write('{tab}<runs val="{inp.runs}"/>');
            bw.newLine();
            bw.write('{tab}<segmentlength val="{inp.segmentlength}"/>');
            bw.newLine();
            bw.write('{tab}<maxdifference val="{inp.maxDifference}"/>');
            bw.newLine();
            bw.write('{tab}<skinproduct val="{inp.skinProduct}"/>');
            bw.newLine();
            bw.write('{tab}<skininject val="{inp.skinInject}"/>');
            bw.newLine();
            bw.write('{tab}<tempinjectwater val="{inp.tempInjectWater}"/>');
            bw.newLine();
            bw.write('{tab}<segmentsproducertvd val="{toString(inp.psd)}"/>');
            bw.newLine();
            bw.write('{tab}<segmentsinjectortvd val="{toString(inp.isd)}"/>');
            bw.newLine();
            bw.write('{tab}<outerdiameterinj val="{inp.outerDiameterInject}"/>');
            bw.newLine();
            bw.write('{tab}<outerdiameterprd val="{inp.outerDiameterProduct}"/>');
            bw.newLine();
            bw.write('{tab}<pumpdepth val="{inp.pumpDepth}"/>');
            bw.newLine();
            bw.write('{tab}<roughnessinjector val="{toString(inp.ir)}"/>');
            bw.newLine();
            bw.write('{tab}<roughnessproducer val="{toString(inp.pr)}"/>');
            bw.newLine();
            bw.write('{tab}<khkvratio val="{inp.khkv}"/>');
            bw.newLine();
            bw.write('{tab}<injectionangle val="{inp.injAngle}"/>');
            bw.newLine();
            bw.write('{tab}<productionangle val="{inp.prdAngle}"/>');
            bw.newLine();
            bw.write('{tab}<segmentsinjector val="{toString(inp.is)}"/>');
            bw.newLine();
            bw.write('{tab}<segmentsproducer val="{toString(inp.ps)}"/>');
            bw.newLine();
            bw.write("</doublet>");


		}
		catch(ex: IOException)
		{
       System.out.println("error");
		}
        finally{
            bw.flush();
            bw.close();
        }

     }

	function toString(array: String[]){
		var flat: String = "";
	    for (str in array){
	        if (str != "") {
	        	flat += str .concat(",");
	        }
	    }
	    flat = flat.substring(0,flat.length()-1);
		return flat
	}

     public function loadXML(filename: java.io.File, scr: InputWindow): Void {


         var error: Boolean = false;

         var inpStream: FileInputStream;

         try{
         inpStream = new FileInputStream(filename);
        // inpStream.close();
         }
         catch(fnfe: FileNotFoundException){
             error = true;
             scr.file = EMPTY;
             scr.file = "  file not found!";
             scr.filecol = Color.RED;
             }
             finally{
                inpStream.close();
             }

         if(not error) executeXML(filename, scr);



         }

     public function executeXML(filename: java.io.File, scr: InputWindow): Void {

     var error: Boolean = false;

     def valQ = QName{name: "val"};

     def parser = PullParser{
         documentType: PullParser.XML;
         input: new FileInputStream(filename)
         onEvent: function(e: Event){

         if (e.type == PullParser.START_ELEMENT and e.level == 1){

         if(e.qname.name.equals("permeabilitymin")) scr.permeabilityMin = e.getAttributeValue(valQ);
         if(e.qname.name.equals("permeabilitylikely")) scr.permeabilityLikely = e.getAttributeValue(valQ);
         if(e.qname.name.equals("permeabilitymax")) scr.permeabilityMax = e.getAttributeValue(valQ);
         if(e.qname.name.equals("thicknessmin")) scr.thicknessMin = e.getAttributeValue(valQ);
         if(e.qname.name.equals("thicknesslikely")) scr.thicknessLikely = e.getAttributeValue(valQ);
         if(e.qname.name.equals("thicknessmax")) scr.thicknessMax = e.getAttributeValue(valQ);
         if(e.qname.name.equals("pressinjtop")) scr.pressInjTop = e.getAttributeValue(valQ);
         if(e.qname.name.equals("pressprodtop")) scr.pressProdTop = e.getAttributeValue(valQ);
         if(e.qname.name.equals("temptop")) scr.tempTop = e.getAttributeValue(valQ);
         if(e.qname.name.equals("salinitymin")) scr.salinityMin = e.getAttributeValue(valQ);
         if(e.qname.name.equals("salinitylikely")) scr.salinityLikely = e.getAttributeValue(valQ);
         if(e.qname.name.equals("salinitymax")) scr.salinityMax = e.getAttributeValue(valQ);
         if(e.qname.name.equals("geothermgradient")) scr.geothermGradient = e.getAttributeValue(valQ);
         if(e.qname.name.equals("surfacetemp")) scr.surfaceTemp = e.getAttributeValue(valQ);
         if(e.qname.name.equals("injecttopreservoirdepthlikely")) scr.injectTopReservoirDepthLikely = e.getAttributeValue(valQ);
         if(e.qname.name.equals("prodtopreservoirdepthlikely")) scr.prodTopReservoirDepthLikely = e.getAttributeValue(valQ);
         if(e.qname.name.equals("welldistance")) scr.wellDistance = e.getAttributeValue(valQ);
         if(e.qname.name.equals("pumpefficiency")) scr.pumpEfficiency = e.getAttributeValue(valQ);
         // "welldiameter" included for backward compability
         if(e.qname.name.equals("welldiameterinjector") or e.qname.name.equals("welldiameter")) scr.pushXMLimportID(e.getAttributeValue(valQ));
         if(e.qname.name.equals("welldiameterproducer") or e.qname.name.equals("welldiameter")) scr.pushXMLimportPD(e.getAttributeValue(valQ));
         if(e.qname.name.equals("nettogrossmin")) scr.netToGrossMin = e.getAttributeValue(valQ);
         if(e.qname.name.equals("nettogrosslikely")) scr.netToGrossLikely = e.getAttributeValue(valQ);
         if(e.qname.name.equals("nettogrossmax")) scr.netToGrossMax = e.getAttributeValue(valQ);
         if(e.qname.name.equals("runs")) scr.runs = e.getAttributeValue(valQ);
         if(e.qname.name.equals("segmentlength")) scr.segmentlength = e.getAttributeValue(valQ);
         if(e.qname.name.equals("maxdifference")) scr.maxDifference = e.getAttributeValue(valQ);
         if(e.qname.name.equals("skinproduct")) scr.skinProduct = e.getAttributeValue(valQ);
         if(e.qname.name.equals("skininject")) scr.skinInject = e.getAttributeValue(valQ);
         if(e.qname.name.equals("tempinjectwater")) scr.tempInjectWater = e.getAttributeValue(valQ);
         if(e.qname.name.equals("segmentsinjectortvd")) scr.pushXMLimportISD(e.getAttributeValue(valQ));
         if(e.qname.name.equals("segmentsproducertvd")) scr.pushXMLimportPSD(e.getAttributeValue(valQ));
         // "outerdiameter" included for backward compability
         if(e.qname.name.equals("outerdiameterinj")or e.qname.name.equals("outerdiameter")) scr.outerDiameterInject = e.getAttributeValue(valQ);
         if(e.qname.name.equals("outerdiameterprd")or e.qname.name.equals("outerdiameter")) scr.outerDiameterProduct = e.getAttributeValue(valQ);
         if(e.qname.name.equals("pumpdepth")) scr.pumpDepth = e.getAttributeValue(valQ);
         // "roughness" included for backward compability
         if(e.qname.name.equals("roughnessinjector") or e.qname.name.equals("roughness")) scr.pushXMLimportIR(e.getAttributeValue(valQ));
         if(e.qname.name.equals("roughnessproducer") or e.qname.name.equals("roughness")) scr.pushXMLimportPR(e.getAttributeValue(valQ));
         if(e.qname.name.equals("khkvratio")) scr.khkv = e.getAttributeValue(valQ);
         if(e.qname.name.equals("injectionangle")) scr.injAngle = e.getAttributeValue(valQ);
         if(e.qname.name.equals("productionangle")) scr.prdAngle = e.getAttributeValue(valQ);
         if(e.qname.name.equals("segmentsinjector")) scr.pushXMLimportIS(e.getAttributeValue(valQ));
         if(e.qname.name.equals("segmentsproducer")) scr.pushXMLimportPS(e.getAttributeValue(valQ));
         }

        }// onEvent

     }// PullParser



      try{
       parser.parse();
        }
      catch(ex: IOException){
          System.out.println("parse Error");
      }
      finally{

           parser.input.close();
      }



   }// function



}






