package tno.geoenergy.doubletcalc.io.file;

/**
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html         
 * 
 */

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import java.awt.Frame;
import javax.swing.JOptionPane;

public class FileDialog {

	private static FileDialog uniqueInstance;
	private JFileChooser fileChooser = new JFileChooser();
	private Frame frame = new Frame();
	private String title;
	private String extension = ".txt";
	private CustomFileFilter filter = new CustomFileFilter();
	private File fileInfo;
	private static File directory = new File(".");

	private FileDialog() {
	}

	public static FileDialog getInstance() {
		if (uniqueInstance == null)
			uniqueInstance = new FileDialog();
		return uniqueInstance;
	}

	public void setTitle(String s) {
		title = s;
	}

	public void setExtension(String s) {
		extension = s;
	}

	public File getDirectory() {
		return directory;
	}

	private File checkExtension(File f) {
		String fileName = f.toString().toLowerCase();
		if (fileName.endsWith(extension.toLowerCase()))
			return new File(fileName);
		else
			return new File(fileName + extension.toLowerCase());
	}

	private void initializeDialog() {
		fileChooser.setDialogTitle(title);
		filter.setCustomFileFilter(extension);
		fileChooser.setFileFilter(filter);
		fileChooser.setCurrentDirectory(directory);
	}

	private int getSecurityDialog() {
		return JOptionPane.showConfirmDialog(frame, fileChooser
				.getSelectedFile().getName()
				+ " already exists. Replace?", title,
				JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);

	}

	private void getInfoDialog() {
		JOptionPane.showMessageDialog(frame, fileChooser.getSelectedFile()
				.getName()
				+ " does not exist.", title, JOptionPane.WARNING_MESSAGE);
	}

	public File saveDialog() {
		initializeDialog();
		boolean onFileDialog = true;

		while (onFileDialog) {
			int retValue = fileChooser.showSaveDialog(frame);

			if (retValue == JFileChooser.APPROVE_OPTION) {
				fileInfo = checkExtension(fileChooser.getSelectedFile());
				if (fileChooser.getSelectedFile().exists()) {
					if (getSecurityDialog() == JOptionPane.YES_OPTION)
						break;
				} else
					break;
			} // retValue == JFileChooser.APPROVE_OPTION
			else { // Cancel Option
				fileInfo = null;
				break;
			}

		} // while

		directory = fileChooser.getCurrentDirectory();

		return fileInfo;
	}

	public File openDialog() {
		initializeDialog();
		boolean onFileDialog = true;

		while (onFileDialog) {

			int retValue = fileChooser.showOpenDialog(frame);

			if (retValue == JFileChooser.APPROVE_OPTION) {
				if (fileChooser.getSelectedFile().exists()) {
					fileInfo = fileChooser.getSelectedFile();
					break;
				} else {
					getInfoDialog();
				}
			} else {
				fileInfo = null;
				break;
			}
		}
		directory = fileChooser.getCurrentDirectory();

		return fileInfo;
	}

	private class CustomFileFilter extends FileFilter {

		private String extension;

		private CustomFileFilter() {
		}

		private void setCustomFileFilter(String ext) {
			extension = ext;
		}

		@Override
		public boolean accept(File f) {

			if (f.isDirectory())
				return true;

			// regular file
			String fileName = f.getName().toLowerCase();

			if (fileName.endsWith(extension.toLowerCase()))
				return true;

			return false;
		}

		@Override
		public String getDescription() {

			return extension;
		}
	}

}