package tno.geoenergy.doubletcalc.io.file;

/**
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *          
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html          
 * 
 */

import java.io.File;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import java.awt.Frame;


public class StringToFile {

    private File file;
    private String[] script;

    

    public StringToFile(File file, String[] script){
        this.file = file;
        this.script = script;
    }


    public static void showNotFoundError(){
    	Frame frame = new Frame();
    	JOptionPane.showMessageDialog(frame,
                "Error writing file. File is probably used by another process.",
                "Error",
                JOptionPane.WARNING_MESSAGE);
    }
    
    public static void showIOError(){
    	Frame frame = new Frame();
    	JOptionPane.showMessageDialog(frame,
                "Error writing file.",
                "Error",
                JOptionPane.WARNING_MESSAGE);
    }

    public void writeFile(){

        try
		{
		    BufferedWriter bw = new BufferedWriter( new FileWriter(file) );


            for (String row : script){

                bw.write(row);
                bw.newLine();
             }

            bw.write("=== end of file ===");
            bw.newLine();
            
			bw.flush();
			bw.close();
		}
        catch(FileNotFoundException e)
		{
             e.printStackTrace();
             showNotFoundError();             
		}
         catch(IOException e)
 		{
              e.printStackTrace();
              showIOError();
 		}
    }

}
