package tno.geoenergy.doubletcalc.io.screen;

/*
 * AquiferOutput.fx
*
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 * 
 */

import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.Group;
import javafx.scene.layout.VBox;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.paint.Color;
import java.lang.Math;
import javafx.scene.Cursor;
import javafx.scene.shape.Rectangle;
import javafx.scene.layout.Tile;
import javafx.geometry.HPos;
import java.io.File;
import javafx.util.Sequences;
import javafx.ext.swing.SwingLabel;
import javafx.ext.swing.SwingTextField;
import javafx.ext.swing.SwingHorizontalAlignment;
import javafx.scene.image.Image;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerVar;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;
import tno.geoenergy.doubletcalc.stochastic.TnoMyStochasticObjects;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticVariable;
import tno.geoenergy.doubletcalc.io.screen.StochasticPlotManager;
import tno.geoenergy.doubletcalc.ResultSet;
import tno.geoenergy.doubletcalc.io.file.Dataexport;
import tno.geoenergy.doubletcalc.io.file.FileDialog;
import javafx.ext.swing.SwingButton;
import javafx.scene.control.ScrollView;
import javafx.scene.text.FontPosture;
import tno.geoenergy.doubletcalc.TnoPipe;
import java.awt.Frame;
import javax.swing.JOptionPane;



 var resTitle: String = "{InputWindow.NORM_TITLE} Result Table";




public class AquiferOutput { //output instances of the aquifer
   //fields
  var rs: ResultSet;


  public function getResultTable(rs: ResultSet){
      this.rs = rs;
      resultTable();
  }


   public function getOutPutwarningsWarning() {
        var pHE: Number = rs.baseCasePressureAlongDoublet[2];
        var minPPrd: Number = Sequences.min(rs.baseCaseProducerPipe.pressureNode) as Number;
        var minPInj: Number = Sequences.min(rs.baseCaseInjectorPipe.pressureNode) as Number;

        var errormsg: String = "";

        if (pHE<0){
            errormsg = "heat exchanger";
        }
        if (minPPrd<0){
            if (errormsg != ""){
                errormsg += ", "
            }
            errormsg += "producer";
        }
        if (minPInj<0){
             if (errormsg != ""){
                errormsg += ", "
            }
            errormsg += "injector";
        }

        if (errormsg != ""){
            var frame: Frame = new Frame();
              JOptionPane.showMessageDialog(frame,
              "Negative pressure at {errormsg}! \nPlease change pump pressure, pump depth or well configuration.",
              "Warning",
              JOptionPane.WARNING_MESSAGE);
        }

   }


protected function createBaseCaseCSV(){

    var fd: FileDialog = FileDialog.getInstance();
       fd.setTitle("Export Base Case Details");
       fd.setExtension(".csv");

       var filename: File = fd.saveDialog();

      if (filename != null) Dataexport.createBaseCaseCSV(filename, rs);

}



    function generateFingerprint(){

    //var maxCop: Number = Sequences.max(rs.pumpCaseCops) as Number;
    //var maxDrawdown: Number = Sequences.max(rs.pumpCasePressureDrawdowns) as Number;
    var maxIndex: Integer = sizeof(rs.pumpCasePressureDrawdowns)-1;
    var maxPumpPower: Number = Sequences.max(rs.pumpCasePumpPowers ) as Number;
    var maxPumpFlow: Number = Sequences.max(rs.pumpCaseQvolPumps ) as Number;
    var minPumpPower: Number = Sequences.min(rs.pumpCasePumpPowers ) as Number;
    var minPumpFlow: Number = Sequences.min(rs.pumpCaseQvolPumps ) as Number;
    var y1max: Number;
    var y1min: Number;

	if ( maxPumpFlow >= maxPumpPower) y1max = maxPumpFlow
	else y1max = maxPumpPower;
	
	if ( minPumpFlow <= minPumpPower) y1min = minPumpFlow
	else y1min = minPumpPower;


        var fingerpr: Fingerprint = Fingerprint{
            cop: rs.pumpCaseCops;
            y1MinValue: y1min;
            y1MaxValue: y1max;
            y2MinValue: (Sequences.min(rs.pumpCaseGeoThermalPowers) as Number);
            y2MaxValue: (Sequences.max(rs.pumpCaseGeoThermalPowers) as Number);
            y3MinValue: Sequences.min(rs.pumpCaseCops) as Number;
            y3MaxValue: Sequences.max(rs.pumpCaseCops) as Number;
            minValue: Sequences.min(rs.pumpCasePressureDrawdowns) as Number;
            maxValue:  Sequences.max(rs.pumpCasePressureDrawdowns) as Number;
            x: 125;
            y: 65;
            scriptSize: 13;
            stroke: 2;
        	xTitle: "{TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_PRESSUREDIFFERENCE).getTitle()}  (intake - discharge)";
            wTitle: "{InputWindow.NORM_TITLE} Fingerprint Plot (median values)";
            y1aTitle: TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_QVOL).getTitle();
            y1bTitle: TnoSingularContainer.find(TnoMyStochasticObjects.PUMP_POWER_REQUIRED).getTitle();
            y2Title: TnoSingularContainer.find(TnoMyStochasticObjects.GEOTHERMAL_POWERS).getTitle();
            y3Title: TnoSingularContainer.find(TnoMyStochasticObjects.COP).getTitle();
            };

           for (i in[0..maxIndex]){
               fingerpr.drawdown[i] = rs.pumpCasePressureDrawdowns[i];
               fingerpr.pumpFlow[i] = rs.pumpCaseQvolPumps[i];
               fingerpr.pumpPower[i] = rs.pumpCasePumpPowers[i];
               fingerpr.thermalPower[i] = rs.pumpCaseGeoThermalPowers[i];
               fingerpr.cop[i] = rs.pumpCaseCops[i];
           }



        AquiferOutput.cursor = Cursor.DEFAULT;
        AquiferOutput.resTitle = "{InputWindow.NORM_TITLE} Result Table";
        fingerpr.getFingerprint();
    }



    package function resultTable(){


       var scene:Scene;
var contentarea: VBox;

    rt = Stage {
            title: bind resTitle
            
            icons: [Image{
                          url: "{__DIR__}TNO.png"}]
            onClose: function(){
                    Fingerprint.fingWin.close();
                    StochasticPlotManager.stochWin.close();
                    }
            scene: scene = Scene {
                width: 950
                height: 935
                cursor: bind cursor
                content: [
                     ScrollView {
                        width: bind scene.width
                        height: bind scene.height
                        node:
                         Group {
                            content: [
                                Rectangle {
                                    width: bind contentarea.width + 24
                                    height: bind contentarea.height + 10
                                    fill: Color.WHITE
                                    stroke: null
                                },
                            contentarea = VBox{           // outer VBox
                            //spacing: 3
                            content:[
                                upperGroup,
                               
                                    SwingLabel{
                               text: InputWindow.file
                               foreground: bind InputWindow.filecol
                               font: Font.font("Arial", FontWeight.REGULAR, FontPosture.REGULAR, 13)
                               visible:true
                               width: 600
                           },
                                geotechnics

                       ]
                    } // outer VBox
                    ]
                  }
                  }
                ]//Scene
            } //Scene
         } //stage
    } //result table


    protected var upperGroup: HBox = HBox{
                                spacing: 25
                                 content:[
                                   SwingButton {
                                        width: 170
                                        text: "probabilistic plots"
                                        action: function() {
                                            
                                        if ( not StochasticPlotManager.stochWinExec ){   
                                        StochasticPlotManager{
                                            title: "{InputWindow.NORM_TITLE} Probabilistic Plots"
                                            width: 800
                                            height: 550
                                            selectorItems:
                                            [
                                              TnoMyStochasticObjects.PUMP_QVOL,
                                              TnoMyStochasticObjects.GEOTHERMAL_POWERS,
                                              TnoMyStochasticObjects.COP,                                             
                                              ]
                                        }.getPlotWindow();
                                        }
                                        else StochasticPlotManager.stochWin.toFront();
                                        }
                                    },
//                                  
                                    SwingButton {
                                        width: 170
                                        text: "fingerprinting"
                                        action: function() {

                                        if (not Fingerprint.fingExec) {
                                            cursor = Cursor.WAIT;
                                            generateFingerprint();

                                            }
                                        else Fingerprint.fingWin.toFront();
                                        }
                                    },
                                   
                                    SwingButton {
                                        text: "export base case details"
                                        width: 170
                                        action: function() {
                                            createBaseCaseCSV();
                                        }
                                    }
                                    ]
                             
                            }

   protected var geotechnics: HBox = HBox{ // two result columns
                                spacing: 25
                                fillHeight: false
                                content: [
                                        VBox{  //VBox 1
                                        fillWidth:false
                                        spacing: 4
                                        content: [
                                            SwingLabel{
                                                       text: " Geotechnics (Input)"
                                                       foreground: Color.BLUE
                                                       font: Font.font("Arial", FontWeight.BOLD, 26  )
                                                   },

                                            OutputRow{}.getEmptyRow(),

                                            OutputRow{
                                                title: "Property"
                                                min: "min"
                                                median: "median"
                                                max: "max"
                                                isBold: true
                                            }.getRow(),
                                           for (identifier in ResultSet.getStochGeoInputProperties() ){
                                               var stochVar: TnoStochasticVariable = TnoStochasticContainerVar.find(identifier);
                                               var unitFactor: Double = stochVar.getUnitFactor();
                                               var round: Integer = stochVar.getRound();
                                               OutputRow{
                                                title: stochVar.getTitle()
                                                min: numRound(stochVar.getDistribution().getMin() * unitFactor, round).toString();
                                                median: numRound(stochVar.getDistribution().getMedian() * unitFactor, round).toString();
                                                max: numRound(stochVar.getDistribution().getMax() * unitFactor, round).toString();
                                            }.getRow()
                                           },
                                           OutputRow{}.getEmptyRow(),
                                           OutputRow{
                                           		isBold: true 
                                                title: "Property"
                                                min: "value"
                                                dataColumnSize: 20
                                                }.getSmallRow(),
                                                                          
                                           for (identifier in ResultSet.getSingularGeoInputProperties() ){
                                                                                             OutputRow{
                                                title: TnoSingularContainer.find(identifier).getTitle()
                                                min: TnoSingularContainer.find(identifier).getStrValueForm().toString()
                                                dataColumnSize: 20
                                            }.getSmallRow()
                                            
                                           },
                                           

                                        ]
                                    },  //VBox1
      
                                    VBox{  //VBox 2
                                        fillWidth:false
                                        spacing: 4
                                        content: [
                                            SwingLabel{
                                               text: " Geotechnics (Output)"
                                               foreground: Color.RED
                                               font: Font.font("Arial", FontWeight.BOLD, 26  )
                                           },

                                           OutputRow{}.getEmptyRow(),
                                           
                                           OutputRow{
                                                title: "Monte Carlo cases (stochastic inputs)"
                                                min: "P90"
                                                median: "P50"
                                                max: "P10"
                                                isBold: true
                                            }.getRow(),

                                     for (identifier in ResultSet.getStochGeoOutputProperties() ){

                                         OutputRow {
                                                title: TnoStochasticContainerVar.find(identifier).getTitle()
                                                min: TnoStochasticContainerVar.find(identifier).calcPValueForm(90.0).toString();
                                                median: TnoStochasticContainerVar.find(identifier).calcPValueForm(50.0).toString();
                                                max: TnoStochasticContainerVar.find(identifier).calcPValueForm(10.0).toString();
                                            }.getRow()
                                        },
                                        //SwingTextField{visible: false},
                                        OutputRow{}.getEmptyRow(),

                                         for (identifier in ResultSet.getStochWellProperties() ){
                                             OutputRow {
                                                title: TnoStochasticContainerVar.find(identifier).getTitle()
                                                min: TnoStochasticContainerVar.find(identifier).calcPValueForm(90.0).toString();
                                                median: TnoStochasticContainerVar.find(identifier).calcPValueForm(50.0).toString();
                                                max: TnoStochasticContainerVar.find(identifier).calcPValueForm(10.0).toString();
                                            }.getRow()
                                         },
                                         OutputRow{}.getEmptyRow(),

                                              OutputRow{
                                                title: "base case (median value inputs)"
                                                min: "value"
                                                isBold: true
                                                isSmall: true
                                            }.getRow(),

                                         for (identifier in ResultSet.getBaseGeoOutputProperties() ){

                                            OutputRow {
                                                title: TnoSingularContainer.find(identifier).getTitle()
                                                min:  TnoSingularContainer.find(identifier).getValueForm().toString()
                                                isSmall: true
                                            }.getSmallRow()
                                          },

                                         OutputRow{}.getEmptyRow(),
                                         for (identifier in ResultSet.getBaseCaseWellProperties() ){
                                             OutputRow {
                                                title: TnoSingularContainer.find(identifier).getTitle()
                                                min: TnoSingularContainer.find(identifier).getValueForm().toString()
                                                isSmall: true
                                            }.getSmallRow()
                                         },
                                         
                                         SwingLabel{
                                    	    text: "* @ mid aquifer depth"
                                    	    font: Font.font("Arial", FontWeight.REGULAR, 13.0);
                                    	    foreground: Color.DARKGREEN;
                                    	}



                                         for (x in [0..3]){
                                              OutputRow{}.getEmptyRow()
                                         },


                                        ]
                                    },  //VBox2



                                ]
                            }// two result coluns HBox
                        
              
} //class

public function numRound(num: Double, dec: Integer): Number {

    def p:Number= Math.pow(10, dec);
    return Math.round(num*p)/p;
    }


def sz: Number= 13.5;
def hd: Number= 13.0;
var copPlot: Plot;
public var cursor: Cursor= Cursor.DEFAULT;
var notDef: SwingLabel = SwingLabel {
                        horizontalAlignment: SwingHorizontalAlignment.RIGHT
                        width: 60
                        font: Font.font("Arial", FontWeight.REGULAR, sz)
                        text: "--"
                        visible: true
                        };

public var rt: Stage;


