package tno.geoenergy.doubletcalc.io.screen;

/*
 * Fingerprint.fx
*
 * @author Kronimus
 * 
 * 
 *          (c) 2009 TNO
 *
 *   Disclaimer
 *	 see
 *   http://www.tno.nl/downloads/Disclaimer%20websites%20TNO.UK1.pdf
 *	 and
 *	 http://www.nlog.nl/nl/home/termsNLOG.html
 * 
 */

import java.lang.System;
import java.lang.Math;
import javafx.scene.Node;
import javafx.scene.Group;
import javafx.scene.shape.Line;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.ext.swing.SwingButton;
import java.io.File;
import javafx.scene.image.Image;
import tno.geoenergy.doubletcalc.stochastic.TnoMyStochasticObjects;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;
import tno.geoenergy.doubletcalc.io.screen.PlotManager;
import tno.geoenergy.doubletcalc.io.file.*;





public class Fingerprint extends Plot{


package var drawdown: Number[];
package var pumpFlow: Number[];
package var cop: Number[];
package var pumpPower: Number[];
package var thermalPower: Number[];
package var minY1: Number;
package var maxY1: Number;
package var minY2: Number;
package var maxY2: Number;
package var minY3: Number;
package var maxY3: Number;
package var y1Interv: Number;
package var y2Interv: Number;
package var y3Interv: Number;
package var dimY1: Number;
package var dimY2: Number;
package var dimY3: Number;
package var y1MinValue: Number;
package var y1MaxValue: Number;
package var y2MinValue: Number;
package var y2MaxValue: Number;
package var y3MinValue: Number;
package var y3MaxValue: Number;
package var y1aTitle: String;
package var y1bTitle: String;
package var y2Title: String;
package var y3Title: String;




function createFingerprintCSV(): Void{
    
    var script: String[];
    
    insert "{InputWindow.NORM_TITLE} Fingerprinting Results" into script;
    insert "" into script;
 
    var headerItems: String[] = [TnoMyStochasticObjects.PUMP_PRESSUREDIFFERENCE,
    							TnoMyStochasticObjects.BASECASE_PUMP_POWER_REQUIRED,
    							TnoMyStochasticObjects.BASECASE_COP ,
    							TnoMyStochasticObjects.BASECASE_PUMP_QVOL,
    							TnoMyStochasticObjects.BASECASE_GEOTHERMAL_POWERS
    							];
    							
    var header: String;
    
    for (item in headerItems){
    		header += "{TnoSingularContainer.find(item).getTitle()}, " ;
    }
   
    header = PlotManager.removeSeparator(header);
    insert header into script;
    
    for (i in [0..sizeof drawdown-1]){
        var line = "{drawdown[i]}, {pumpPower[i]}, {cop[i]}, {pumpFlow[i]}, {thermalPower[i]}";
		insert line into script;
    }

    var fd: FileDialog = FileDialog.getInstance();
               fd.setTitle("Export Fingerprint CSV file");
               fd.setExtension(".csv");
    
               var filename: File = fd.saveDialog();
    
               var toFile: StringToFile = new StringToFile(filename, script);
               if (filename != null) toFile.writeFile();
   
    
}



function getInterval(n: Number): Number{
    
    var interval: Number;
    
    if(n >5.0)      interval = 1.0;
    if(n <= 5.0)    interval = 0.5;
    if(n <= 2.50)   interval = 0.25;
    if(n <= 2.0)    interval = 0.2;
    if(n <= 1.0)    interval = 0.1;
    
    return interval;
}


 function setY1Intervals():Void{
 var n: Number;
 var dif: Number;

     dif = this.maxY1 - this.minY1;
     this.dimY1 =getDimension(dif);
     n= dif/Math.pow(10, this.dimY1);
     
     this.y1Interv = getInterval(n);

};

 function setY2Intervals():Void{
 var n: Number;
 var dif: Number;

     dif = this.maxY2 - this.minY2;
     this.dimY2 =getDimension(dif);
     n= dif/Math.pow(10, this.dimY2);
     
     this.y2Interv = getInterval(n);

};


function setY3Intervals():Void{
 var n: Number;
 var dif: Number;

     dif = this.maxY3 - this.minY3;
     this.dimY3 =getDimension(dif);
     n= dif/Math.pow(10, this.dimY3);
     
     this.y3Interv = getInterval(n);
}



function setBorderY1(): Void{
var dim: Number;
var dif: Number;
var q: Number;
var roundVal: Number;
// left border

dim = getDimension(y1MaxValue);
q = this.y1MinValue/Math.pow(10, dim );

roundVal = Math.floor(q);

//this.minY1 = roundVal * Math.pow(10, dim);
this.minY1 = getLowBorder(this.y1MinValue, y1MaxValue);

// right border
maxY1 = this.y1MaxValue; // mmaX will be recalculated in function displayXAxis()

};

function setBorderY2(): Void{
    
var dim: Number;
var q: Number;
var roundVal: Number;
// left border

dim = getDimension(this.y2MinValue);
q = this.y2MinValue/Math.pow(10, dim );

roundVal = Math.floor(q);

 //    this.minY2 = roundVal * Math.pow(10, dim );
this.minY2 = getLowBorder(this.y2MinValue, y2MaxValue);
// right border

maxY2 = this.y2MaxValue; // mmaY2 will be recalculated in function displayY2Axis()
};


function getLowBorder(minValue: Number, maxValue: Number): Number{
    
    var dim: Number;
    var q: Number;
    var roundVal: Number;
    
    dim = getDimension(maxValue - minValue);
    q = minValue/Math.pow(10, dim );
    
    roundVal = Math.floor(q);
    
    return roundVal * Math.pow(10, dim );
}

function setBorderY3(): Void{

this.minY3 = getLowBorder(this.y3MinValue, y3MaxValue);
// right border

maxY3 = this.y3MaxValue; // mmaY2 will be recalculated in function displayY2Axis()

};


function getOffset(minY: Number, i: Integer, interval: Number, dim: Number): Integer{
    
    var offset: Integer;
    
    if( minY + i* interval * Math.pow(10, dim) >=1000)  offset = 0;
    if( minY + i* interval * Math.pow(10, dim) >=100) offset = 7;
    if( minY + i* interval * Math.pow(10, dim) <=90) offset = 14;
    if( minY + i* interval * Math.pow(10, dim) ==0) offset = 21;
   
   return offset;
}



function displayY1Axis(): Node{

    var gr: Group;
    var offset: Integer;

    def ticks: Integer= (Math.floor((this.maxY1-this.minY1)/(this.y1Interv * Math.pow(10, this.dimY1))) as Integer) + 1 ;

    this.maxY1 = minY1 + ticks * (this.y1Interv * Math.pow(10, this.dimY1));

    gr=Group{
    content:[
        Line {
            startX: this.x
            startY: this.y
            endX: this.x
            endY: this.y + this.height
            strokeWidth: 1
            stroke: Color.BLACK
        },
        Text {
            font: Font.font("Arial", FontWeight.BOLD, this.scriptSize + 2)
            fill: Color.RED
            x: this.x - 163
            y: 355
            content: this.y1aTitle
            rotate: -90
        },
        Text {
            font: Font.font("Arial", FontWeight.BOLD, this.scriptSize + 2)
            fill: Color.BLUE
            x: this.x - 170
            y:  155
            content: this.y1bTitle
            rotate: -90
        }
    ]
    } //Group

    for(i in [0..ticks]){
        offset = getOffset(minY1, i, y1Interv, dimY1);
       
       var ct: Number = numRound(this.minY1 + i* this.y1Interv * Math.pow(10, this.dimY1),2) ;
       
       insert[
        Text {
            font: Font {
                size: this.scriptSize
            }
            x: this.x - 60 + offset
            y: this.y + this.height - (this.height / ticks)*i  + 5
            content: ct.toString()
        },
        Line {
            startX: this.x - 7
            startY: this.y + (this.height / ticks) * i
            endX: this.x
            endY: this.y + (this.height / ticks) * i
            strokeWidth: 1
            stroke: Color.BLACK
        },
        Line {
            startX: this.x
            startY: this.y + (this.height / ticks) * i
            endX: this.x + this.width
            endY: this.y + (this.height / ticks) * i
            strokeWidth: 0.75
            stroke: Color.GREY
        }
    ] into gr.content;
    } //loop
    return gr;
}; // function displayY1Axis(): Void{

function displayY2Axis(): Node{

    var gr: Group;
    var offset: Integer;

    def ticks: Integer= (Math.floor((this.maxY2-this.minY2)/(this.y2Interv * Math.pow(10, this.dimY2))) as Integer) + 1 ;

    this.maxY2 = minY2 + ticks * (this.y2Interv * Math.pow(10, this.dimY2));

    gr=Group{
    content:[
        Line {
            startX: this.x + this.width
            startY: this.y
            endX: this.x + this.width
            endY: this.y + this.height
            strokeWidth: 1
            stroke: Color.BLACK
        },
        Text {
            font: Font.font("Arial", FontWeight.BOLD, this.scriptSize + 2)
            fill: Color.DARKGREEN
            x: this.x + 570
            y: this.y + this.height/2 + this.y2Title.length()
            content: this.y2Title
            rotate: -90
        }
    ]
    } //Group

    for(i in [0..ticks]){
        offset = getOffset(minY2, i, y2Interv, dimY2);
        
       insert[
        Text {
            font: Font {
                size: this.scriptSize
            }
            x: this.x + this.width  + offset
            y: this.y + this.height - (this.height / ticks)*i  + 5
            content: numRound(this.minY2 + i* this.y2Interv * Math.pow(10, this.dimY2),2).toString()
        },
        Line {
            startX: this.x + this.width
            startY: this.y + (this.height / ticks) * i
            endX: this.x + this.width + 7
            endY: this.y + (this.height / ticks) * i
            strokeWidth: 1
            stroke: Color.BLACK
        }
    ] into gr.content;
    } //loop
    return gr;
} // function displayY2Axis(): Void{


function displayY3Axis(): Node{

    var gr: Group;
    var offset: Integer;

    def ticks: Integer= (Math.floor((this.maxY3-this.minY3)/(this.y3Interv * Math.pow(10, this.dimY3))) as Integer) + 1 ;

    this.maxY3 = minY3 + ticks * (this.y3Interv * Math.pow(10, this.dimY3));

    gr=Group{
    content:[
        Line {
            startX: this.x + this.width + 100
            startY: this.y
            endX: this.x + this.width + 100
            endY: this.y + this.height
            strokeWidth: 1
            stroke: Color.BLACK
        },
        Text {
            font: Font.font("Arial", FontWeight.BOLD, this.scriptSize + 2)
            fill: Color.DARKMAGENTA
            x: 840
            y:  this.y + this.height/2 + this.y3Title.length()
            content: this.y3Title
            rotate: -90
        }
        
    ]
    } //Group

    for(i in [0..ticks]){
        offset = getOffset(minY3, i, y3Interv, dimY3);
       
       insert[
        Text {
            font: Font {
                size: this.scriptSize
            }
            x: this.x + this.width  + offset + 100
            y: this.y + this.height - (this.height / ticks)*i  + 5 
            content:  numRound(this.minY3 + i* this.y3Interv * Math.pow(10, this.dimY3),2).toString()
        },
        Line {
            startX: this.x + this.width + 100
            startY: this.y + (this.height / ticks) * i
            endX: this.x + this.width + 7 + 100
            endY: this.y + (this.height / ticks) * i
            strokeWidth: 1
            stroke: Color.BLACK
        },
         Line {
            startX: this.x
            startY: this.y + (this.height / ticks) * i
            endX: this.x + this.width + 100
            endY: this.y + (this.height / ticks) * i
            strokeWidth: 1
            stroke: Color.LIGHTGREY
            strokeDashArray: [16.0]
        }
    ] into gr.content;
    } //loop
    return gr;
} // function displayY3Axis(): Void{

    function displayCurvesY1(): Node{

    var gr: Group;
    def pixPerUnitX: Number = this.width/(this.maxX - this.minX);
    def pixPerUnitY: Number = this.height/(this.maxY1 - this.minY1);
    def maxIndex = sizeof this.pumpPower -1;
    var yValue: Number[];
    var col: Color;

    
    gr=Group{
        content:[
    
        for (n in [0..1]){
    
            if ( n==0 ) { yValue = this.pumpPower; col = Color.BLUE; };
            if ( n==1 ) { yValue = this.pumpFlow; col = Color.RED; };
    
         for(i in [1..maxIndex]){
    
             Line {
                 startX: this.x + (this.drawdown[i  -  1] - this.minX ) * pixPerUnitX
                 startY: (this.y + this.height) - (yValue[i - 1] - minY1) * pixPerUnitY
                 endX: this.x + (this.drawdown[i] - this.minX ) * pixPerUnitX
                 endY: (this.y + this.height) - (yValue[i] - minY1) * pixPerUnitY
                 strokeWidth: this.stroke
                 stroke: col
                
             }
        } // inner loop
        } // outer loop
        ]
        } // group
        
    return gr;
   } // function

   function displayCurvesY2(): Node{

    var gr: Group;
    def pixPerUnitX: Number = this.width/(this.maxX - this.minX);
    def pixPerUnitY: Number = this.height/(this.maxY2 - this.minY2);
    def maxIndex = sizeof this.pumpPower -1;
    var yValue: Number[];
    var col: Color;
System.out.println("miny2: {minY2}");

     yValue = this.thermalPower; col = Color.GREEN;

gr=Group{
    content:[
         
     for(i in [1..maxIndex]){

         Line {
             startX: this.x + (this.drawdown[i  -  1] - this.minX ) * pixPerUnitX
             startY: (this.y + this.height) - (yValue[i - 1] - minY2) * pixPerUnitY
             endX: this.x + (this.drawdown[i] - this.minX ) * pixPerUnitX
             endY: (this.y + this.height) - (yValue[i] - minY2) * pixPerUnitY
             strokeWidth: this.stroke
             stroke: col
             strokeDashArray: [3.0]
         }
    } // inner loop
  
    ]
    } // group
    return gr;
   } // function


   function displayCurvesY3(): Node{

    var gr: Group;
    def pixPerUnitX: Number = this.width/(this.maxX - this.minX);
    def pixPerUnitY: Number = this.height/(this.maxY3 - this.minY3);
    def maxIndex = sizeof this.pumpPower -1;
    var yValue: Number[];
    var col: Color;
    
 
      yValue = this.cop; col = Color.DARKMAGENTA;
    
    gr=Group{
        content:[
    
         for(i in [1..maxIndex]){
    
             Line {
                 startX: this.x + (this.drawdown[i  -  1] - this.minX ) * pixPerUnitX
                 startY: (this.y + this.height) - (yValue[i - 1] - minY3) * pixPerUnitY
                 endX: this.x + (this.drawdown[i] - this.minX ) * pixPerUnitX
                 endY: (this.y + this.height) - (yValue[i] - minY3) * pixPerUnitY
                 strokeWidth: this.stroke
                 stroke: col
             }
        } // inner loop
       
        ]
        } // group
    
    return gr;
   } // function




package function getFingerprint():Void{

    this.setBorders();
    this.setIntervals();
    
    this.setBorderY1();
    this.setY1Intervals();
    this.setBorderY2();
    this.setY2Intervals();
    this.setBorderY3();
    this.setY3Intervals();

   // System.out.println("Values:  y1min: {this.y1MinValue} y1max: {this.y1MaxValue}, y2min: {this.y2MinValue}, y2max: {this.y2MaxValue}, y3min: {this.y3MinValue}, y3max: {this.y3MaxValue} ");
   //  System.out.println("Borders: y1min: {this.minY1} y1max: {this.maxY1}, y2min: {this.minY2}, y2max: {this.maxY2}, y3min: {this.minY3}, y3max: {this.maxY3} ");

    var graph: Node = Group{
        content:[
        this.displayY3Axis(),
        this.displayXAxis(),
        this.displayY1Axis(),
        this.displayY2Axis(),
        this.displayCurvesY1(),
        this.displayCurvesY2(),
        this.displayCurvesY3()
        ]
    } //Group

   

   fingWin = Stage{
        title: this.wTitle
        width: this.width + 350
        height: this.height + 200
       icons: [Image{
                  url: "{__DIR__}TNO.png"}]
        resizable: false
        scene: Scene{
        content: [
                    
            SwingButton {
                text: "export CSV file"
                width: 120
                action: function() {
                    createFingerprintCSV();
                }
        },
          

        graph
        ]
        }//Scene
        onClose: function() {fingExec = false;}
        };
     fingExec = true;


    };

};

package var fingExec: Boolean = false;
package var fingWin: Stage;


